package com.pdd.pop.sdk.http.api.pop.response;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.PopBaseHttpResponse;

import java.util.List;



public class PddAdApiReportDailyReportQueryResponse extends PopBaseHttpResponse {

    /**
     * 
     */
    @JsonProperty("response")
    private Response response;

    public Response getResponse() {
        return response;
    }

    public static class Response {

        /**
         * 
         */
        @JsonProperty("errorCode")
        private Integer errorCode;

        /**
         * 
         */
        @JsonProperty("errorMsg")
        private String errorMsg;

        /**
         * 
         */
        @JsonProperty("result")
        private ResponseResult result;

        /**
         * 
         */
        @JsonProperty("success")
        private Boolean success;

        public Integer getErrorCode() {
            return errorCode;
        }

        public String getErrorMsg() {
            return errorMsg;
        }

        public ResponseResult getResult() {
            return result;
        }

        public Boolean getSuccess() {
            return success;
        }
    }

    public static class ResponseResult {

        /**
         * 分天报表数据列表
         */
        @JsonProperty("dailyReportList")
        private List<ResponseResultDailyReportListItem> dailyReportList;

        /**
         * 分天报表数据汇总
         */
        @JsonProperty("sumReport")
        private ResponseResultSumReport sumReport;

        public List<ResponseResultDailyReportListItem> getDailyReportList() {
            return dailyReportList;
        }

        public ResponseResultSumReport getSumReport() {
            return sumReport;
        }
    }

    public static class ResponseResultDailyReportListItem {

        /**
         * 每笔成交金额(average pay amount)，单位厘
         */
        @JsonProperty("avgPayAmount")
        private Double avgPayAmount;

        /**
         * 广告点击量
         */
        @JsonProperty("click")
        private Long click;

        /**
         * 平均点击花费，单位厘
         */
        @JsonProperty("cpc")
        private Double cpc;

        /**
         * 千次展现成本
         */
        @JsonProperty("cpm")
        private Double cpm;

        /**
         * 广告点击率
         */
        @JsonProperty("ctr")
        private Double ctr;

        /**
         * 点击转化率
         */
        @JsonProperty("cvr")
        private Double cvr;

        /**
         * 日期
         */
        @JsonProperty("date")
        private String date;

        /**
         * 广告转化支付金额，单位厘
         */
        @JsonProperty("gmv")
        private Long gmv;

        /**
         * 商品收藏数
         */
        @JsonProperty("goodsFavNum")
        private Long goodsFavNum;

        /**
         * 广告曝光量
         */
        @JsonProperty("impression")
        private Long impression;

        /**
         * 店铺关注数
         */
        @JsonProperty("mallFavNum")
        private Long mallFavNum;

        /**
         * 广告转化支付订单量
         */
        @JsonProperty("orderNum")
        private Long orderNum;

        /**
         * 广告投入产出比
         */
        @JsonProperty("roi")
        private Double roi;

        /**
         * 广告消耗,单位厘
         */
        @JsonProperty("spend")
        private Long spend;

        /**
         * 转化成本
         */
        @JsonProperty("transactionCost")
        private Double transactionCost;

        public Double getAvgPayAmount() {
            return avgPayAmount;
        }

        public Long getClick() {
            return click;
        }

        public Double getCpc() {
            return cpc;
        }

        public Double getCpm() {
            return cpm;
        }

        public Double getCtr() {
            return ctr;
        }

        public Double getCvr() {
            return cvr;
        }

        public String getDate() {
            return date;
        }

        public Long getGmv() {
            return gmv;
        }

        public Long getGoodsFavNum() {
            return goodsFavNum;
        }

        public Long getImpression() {
            return impression;
        }

        public Long getMallFavNum() {
            return mallFavNum;
        }

        public Long getOrderNum() {
            return orderNum;
        }

        public Double getRoi() {
            return roi;
        }

        public Long getSpend() {
            return spend;
        }

        public Double getTransactionCost() {
            return transactionCost;
        }
    }

    public static class ResponseResultSumReport {

        /**
         * 每笔成交金额(average pay amount)，单位厘
         */
        @JsonProperty("avgPayAmount")
        private Double avgPayAmount;

        /**
         * 广告点击量
         */
        @JsonProperty("click")
        private Long click;

        /**
         * 平均点击花费，单位厘
         */
        @JsonProperty("cpc")
        private Double cpc;

        /**
         * 千次展现成本
         */
        @JsonProperty("cpm")
        private Double cpm;

        /**
         * 广告点击率
         */
        @JsonProperty("ctr")
        private Double ctr;

        /**
         * 点击转化率
         */
        @JsonProperty("cvr")
        private Double cvr;

        /**
         * 广告转化支付金额，单位厘
         */
        @JsonProperty("gmv")
        private Long gmv;

        /**
         * 商品收藏数
         */
        @JsonProperty("goodsFavNum")
        private Long goodsFavNum;

        /**
         * 广告曝光量
         */
        @JsonProperty("impression")
        private Long impression;

        /**
         * 店铺关注数
         */
        @JsonProperty("mallFavNum")
        private Long mallFavNum;

        /**
         * 广告转化支付订单量
         */
        @JsonProperty("orderNum")
        private Long orderNum;

        /**
         * 广告投入产出比
         */
        @JsonProperty("roi")
        private Double roi;

        /**
         * 广告消耗,单位厘
         */
        @JsonProperty("spend")
        private Long spend;

        /**
         * 转化成本
         */
        @JsonProperty("transactionCost")
        private Double transactionCost;

        public Double getAvgPayAmount() {
            return avgPayAmount;
        }

        public Long getClick() {
            return click;
        }

        public Double getCpc() {
            return cpc;
        }

        public Double getCpm() {
            return cpm;
        }

        public Double getCtr() {
            return ctr;
        }

        public Double getCvr() {
            return cvr;
        }

        public Long getGmv() {
            return gmv;
        }

        public Long getGoodsFavNum() {
            return goodsFavNum;
        }

        public Long getImpression() {
            return impression;
        }

        public Long getMallFavNum() {
            return mallFavNum;
        }

        public Long getOrderNum() {
            return orderNum;
        }

        public Double getRoi() {
            return roi;
        }

        public Long getSpend() {
            return spend;
        }

        public Double getTransactionCost() {
            return transactionCost;
        }
    }
}