package com.pdd.pop.sdk.http.api.pop.response;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.PopBaseHttpResponse;

import java.util.List;



public class PddAdApiUnitBidQueryListResponse extends PopBaseHttpResponse {

    /**
     * 
     */
    @JsonProperty("response")
    private Response response;

    public Response getResponse() {
        return response;
    }

    public static class Response {

        /**
         * 
         */
        @JsonProperty("errorCode")
        private Integer errorCode;

        /**
         * 
         */
        @JsonProperty("errorMsg")
        private String errorMsg;

        /**
         * 
         */
        @JsonProperty("result")
        private List<ResponseResultItem> result;

        /**
         * 
         */
        @JsonProperty("success")
        private Boolean success;

        public Integer getErrorCode() {
            return errorCode;
        }

        public String getErrorMsg() {
            return errorMsg;
        }

        public List<ResponseResultItem> getResult() {
            return result;
        }

        public Boolean getSuccess() {
            return success;
        }
    }

    public static class ResponseResultItem {

        /**
         * 广告单元Id
         */
        @JsonProperty("adId")
        private Long adId;

        /**
         * 定向信息
         */
        @JsonProperty("adTargetingVO")
        private ResponseResultItemAdTargetingVO adTargetingVO;

        /**
         * 每笔成交金额(average pay amount)，单位厘
         */
        @JsonProperty("avgPayAmount")
        private Double avgPayAmount;

        /**
         * 出价Id
         */
        @JsonProperty("bidId")
        private Long bidId;

        /**
         * 定向类型 或 资源位类型
         */
        @JsonProperty("bidReferenceId")
        private Long bidReferenceId;

        /**
         * 出价，万分比
         */
        @JsonProperty("bidValue")
        private Long bidValue;

        /**
         * 广告点击量
         */
        @JsonProperty("click")
        private Long click;

        /**
         * 平均点击花费，单位厘
         */
        @JsonProperty("cpc")
        private Double cpc;

        /**
         * 千次展现成本
         */
        @JsonProperty("cpm")
        private Double cpm;

        /**
         * 广告点击率
         */
        @JsonProperty("ctr")
        private Double ctr;

        /**
         * 点击转化率
         */
        @JsonProperty("cvr")
        private Double cvr;

        /**
         * 广告转化支付金额，单位厘
         */
        @JsonProperty("gmv")
        private Long gmv;

        /**
         * 商品收藏数
         */
        @JsonProperty("goodsFavNum")
        private Long goodsFavNum;

        /**
         * 广告曝光量
         */
        @JsonProperty("impression")
        private Long impression;

        /**
         * 店铺收藏数
         */
        @JsonProperty("mallFavNum")
        private Long mallFavNum;

        /**
         * 广告主Id
         */
        @JsonProperty("mallId")
        private Long mallId;

        /**
         * 广告转化支付订单量
         */
        @JsonProperty("orderNum")
        private Long orderNum;

        /**
         * 广告投入产出比
         */
        @JsonProperty("roi")
        private Double roi;

        /**
         * 广告消耗，单位厘
         */
        @JsonProperty("spend")
        private Long spend;

        /**
         * 人群定向二级Id。当出价资源为展示场景兴趣点时表示兴趣点Id，当出价资源为展示场景人群包时表示人群包Id，当出价资源为展示场景地域时表示地域Id。
         */
        @JsonProperty("subBidReferenceId")
        private String subBidReferenceId;

        /**
         * 人群定向二级名称。当出价资源为展示场景兴趣点时表示兴趣点名称，当出价资源为展示场景人群包时表示人群包名称，当出价资源为展示场景地域时表示地域名称。
         */
        @JsonProperty("subBidReferenceName")
        private String subBidReferenceName;

        /**
         * 转化成本
         */
        @JsonProperty("transactionCost")
        private Double transactionCost;

        public Long getAdId() {
            return adId;
        }

        public ResponseResultItemAdTargetingVO getAdTargetingVO() {
            return adTargetingVO;
        }

        public Double getAvgPayAmount() {
            return avgPayAmount;
        }

        public Long getBidId() {
            return bidId;
        }

        public Long getBidReferenceId() {
            return bidReferenceId;
        }

        public Long getBidValue() {
            return bidValue;
        }

        public Long getClick() {
            return click;
        }

        public Double getCpc() {
            return cpc;
        }

        public Double getCpm() {
            return cpm;
        }

        public Double getCtr() {
            return ctr;
        }

        public Double getCvr() {
            return cvr;
        }

        public Long getGmv() {
            return gmv;
        }

        public Long getGoodsFavNum() {
            return goodsFavNum;
        }

        public Long getImpression() {
            return impression;
        }

        public Long getMallFavNum() {
            return mallFavNum;
        }

        public Long getMallId() {
            return mallId;
        }

        public Long getOrderNum() {
            return orderNum;
        }

        public Double getRoi() {
            return roi;
        }

        public Long getSpend() {
            return spend;
        }

        public String getSubBidReferenceId() {
            return subBidReferenceId;
        }

        public String getSubBidReferenceName() {
            return subBidReferenceName;
        }

        public Double getTransactionCost() {
            return transactionCost;
        }
    }

    public static class ResponseResultItemAdTargetingVO {

        /**
         * 定向集合
         */
        @JsonProperty("adTargetingSet")
        private ResponseResultItemAdTargetingVOAdTargetingSet adTargetingSet;

        /**
         * 定向Id
         */
        @JsonProperty("targetingId")
        private Long targetingId;

        /**
         * 定向名称
         */
        @JsonProperty("targetingName")
        private String targetingName;

        public ResponseResultItemAdTargetingVOAdTargetingSet getAdTargetingSet() {
            return adTargetingSet;
        }

        public Long getTargetingId() {
            return targetingId;
        }

        public String getTargetingName() {
            return targetingName;
        }
    }

    public static class ResponseResultItemAdTargetingVOAdTargetingSet {

        /**
         * 地域定向
         */
        @JsonProperty("areaStruct")
        private ResponseResultItemAdTargetingVOAdTargetingSetAreaStruct areaStruct;

        public ResponseResultItemAdTargetingVOAdTargetingSetAreaStruct getAreaStruct() {
            return areaStruct;
        }
    }

    public static class ResponseResultItemAdTargetingVOAdTargetingSetAreaStruct {

        /**
         * 地域Id列表。具体地域Id编码参见接口返回：pdd.ad.api.unit.bid.query.targeting.tag.list
         */
        @JsonProperty("areaIds")
        private List<Integer> areaIds;

        public List<Integer> getAreaIds() {
            return areaIds;
        }
    }
}