package com.pdd.pop.sdk.http.api.pop.response;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.PopBaseHttpResponse;

import java.util.List;



public class PddAdApiUnitCreativeQueryListResponse extends PopBaseHttpResponse {

    /**
     * 
     */
    @JsonProperty("response")
    private Response response;

    public Response getResponse() {
        return response;
    }

    public static class Response {

        /**
         * 
         */
        @JsonProperty("errorCode")
        private Integer errorCode;

        /**
         * 
         */
        @JsonProperty("errorMsg")
        private String errorMsg;

        /**
         * 
         */
        @JsonProperty("result")
        private List<ResponseResultItem> result;

        /**
         * 
         */
        @JsonProperty("success")
        private Boolean success;

        public Integer getErrorCode() {
            return errorCode;
        }

        public String getErrorMsg() {
            return errorMsg;
        }

        public List<ResponseResultItem> getResult() {
            return result;
        }

        public Boolean getSuccess() {
            return success;
        }
    }

    public static class ResponseResultItem {

        /**
         * 每笔成交金额(average pay amount)，单位厘
         */
        @JsonProperty("avgPayAmount")
        private Double avgPayAmount;

        /**
         * 广告点击量
         */
        @JsonProperty("click")
        private Long click;

        /**
         * 平均点击花费，单位厘
         */
        @JsonProperty("cpc")
        private Double cpc;

        /**
         * 千次展现成本
         */
        @JsonProperty("cpm")
        private Double cpm;

        /**
         * 创意类型。2表示静态创意创意，3表示智能创意。
         */
        @JsonProperty("creativeType")
        private Integer creativeType;

        /**
         * 广告点击率
         */
        @JsonProperty("ctr")
        private Double ctr;

        /**
         * 点击转化率
         */
        @JsonProperty("cvr")
        private Double cvr;

        /**
         * 启用状态。1表示启用，2表示暂停。
         */
        @JsonProperty("dataOperateStatus")
        private Integer dataOperateStatus;

        /**
         * 广告转化支付金额，单位厘
         */
        @JsonProperty("gmv")
        private Long gmv;

        /**
         * 商品收藏数
         */
        @JsonProperty("goodsFavNum")
        private Long goodsFavNum;

        /**
         * 创意图片高
         */
        @JsonProperty("imageHeight")
        private Integer imageHeight;

        /**
         * 创意图片链接
         */
        @JsonProperty("imageUrl")
        private String imageUrl;

        /**
         * 创意图片宽
         */
        @JsonProperty("imageWidth")
        private Integer imageWidth;

        /**
         * 广告曝光量
         */
        @JsonProperty("impression")
        private Long impression;

        /**
         * 店铺收藏数
         */
        @JsonProperty("mallFavNum")
        private Long mallFavNum;

        /**
         * 广告转化支付订单量
         */
        @JsonProperty("orderNum")
        private Long orderNum;

        /**
         * 广告投入产出比
         */
        @JsonProperty("roi")
        private Double roi;

        /**
         * 广告消耗，单位厘
         */
        @JsonProperty("spend")
        private Long spend;

        /**
         * 创意单元状态。1表示推广中，2表示手动暂停，3表示已删除，4表示待发布，5表示已驳回。
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 状态描述，当状态是驳回时显示驳回原因
         */
        @JsonProperty("statusDesc")
        private String statusDesc;

        /**
         * 创意标题
         */
        @JsonProperty("title")
        private String title;

        /**
         * 转化成本
         */
        @JsonProperty("transactionCost")
        private Double transactionCost;

        /**
         * 创意单元Id
         */
        @JsonProperty("unitCreativeId")
        private Long unitCreativeId;

        public Double getAvgPayAmount() {
            return avgPayAmount;
        }

        public Long getClick() {
            return click;
        }

        public Double getCpc() {
            return cpc;
        }

        public Double getCpm() {
            return cpm;
        }

        public Integer getCreativeType() {
            return creativeType;
        }

        public Double getCtr() {
            return ctr;
        }

        public Double getCvr() {
            return cvr;
        }

        public Integer getDataOperateStatus() {
            return dataOperateStatus;
        }

        public Long getGmv() {
            return gmv;
        }

        public Long getGoodsFavNum() {
            return goodsFavNum;
        }

        public Integer getImageHeight() {
            return imageHeight;
        }

        public String getImageUrl() {
            return imageUrl;
        }

        public Integer getImageWidth() {
            return imageWidth;
        }

        public Long getImpression() {
            return impression;
        }

        public Long getMallFavNum() {
            return mallFavNum;
        }

        public Long getOrderNum() {
            return orderNum;
        }

        public Double getRoi() {
            return roi;
        }

        public Long getSpend() {
            return spend;
        }

        public Integer getStatus() {
            return status;
        }

        public String getStatusDesc() {
            return statusDesc;
        }

        public String getTitle() {
            return title;
        }

        public Double getTransactionCost() {
            return transactionCost;
        }

        public Long getUnitCreativeId() {
            return unitCreativeId;
        }
    }
}