package com.pdd.pop.sdk.http.api.pop.response;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.PopBaseHttpResponse;

import java.util.List;



public class PddAdApiUnitQueryListResponse extends PopBaseHttpResponse {

    /**
     * 
     */
    @JsonProperty("response")
    private Response response;

    public Response getResponse() {
        return response;
    }

    public static class Response {

        /**
         * 
         */
        @JsonProperty("errorCode")
        private Integer errorCode;

        /**
         * 
         */
        @JsonProperty("errorMsg")
        private String errorMsg;

        /**
         * 
         */
        @JsonProperty("result")
        private List<ResponseResultItem> result;

        /**
         * 
         */
        @JsonProperty("success")
        private Boolean success;

        public Integer getErrorCode() {
            return errorCode;
        }

        public String getErrorMsg() {
            return errorMsg;
        }

        public List<ResponseResultItem> getResult() {
            return result;
        }

        public Boolean getSuccess() {
            return success;
        }
    }

    public static class ResponseResultItem {

        /**
         * 每笔成交金额(average pay amount)，单位厘
         */
        @JsonProperty("avgPayAmount")
        private Double avgPayAmount;

        /**
         * 广告单元出价。单位厘
         */
        @JsonProperty("bid")
        private Long bid;

        /**
         * 类目ID
         */
        @JsonProperty("catId")
        private Long catId;

        /**
         * 类目名称
         */
        @JsonProperty("catName")
        private String catName;

        /**
         * 广告点击量
         */
        @JsonProperty("click")
        private Long click;

        /**
         * 平均点击花费，单位厘
         */
        @JsonProperty("cpc")
        private Double cpc;

        /**
         * 千次展现成本
         */
        @JsonProperty("cpm")
        private Double cpm;

        /**
         * 广告点击率
         */
        @JsonProperty("ctr")
        private Double ctr;

        /**
         * 点击转化率
         */
        @JsonProperty("cvr")
        private Double cvr;

        /**
         * 智能推广数据积累状态。0表示未知，1表示智能投放期，2表示数据积累期，3表示数据积累缓慢。
         */
        @JsonProperty("dataAccumulationStatus")
        private Integer dataAccumulationStatus;

        /**
         * 操作状态。0表示未知，1表示启用，2表示暂停。
         */
        @JsonProperty("dataOperateStatus")
        private Integer dataOperateStatus;

        /**
         * 广告转化支付金额，单位厘
         */
        @JsonProperty("gmv")
        private Long gmv;

        /**
         * 商品收藏数
         */
        @JsonProperty("goodsFavNum")
        private Long goodsFavNum;

        /**
         * 商品ID
         */
        @JsonProperty("goodsId")
        private Long goodsId;

        /**
         * 商品名称
         */
        @JsonProperty("goodsName")
        private String goodsName;

        /**
         * 广告曝光量
         */
        @JsonProperty("impression")
        private Long impression;

        /**
         * 店铺关注数
         */
        @JsonProperty("mallFavNum")
        private Long mallFavNum;

        /**
         * 广告主ID
         */
        @JsonProperty("mallId")
        private Long mallId;

        /**
         * 最大团购价。单位厘
         */
        @JsonProperty("maxGroupPrice")
        private Long maxGroupPrice;

        /**
         * 最小团购价。单位厘
         */
        @JsonProperty("minGroupPrice")
        private Long minGroupPrice;

        /**
         * 优化目标。0表示不优化。1表示优化ROI，2表示优化转化成本。
         */
        @JsonProperty("optimizationGoal")
        private Integer optimizationGoal;

        /**
         * 智能优化广告相关
         */
        @JsonProperty("optimizationOutputMessage")
        private ResponseResultItemOptimizationOutputMessage optimizationOutputMessage;

        /**
         * 广告转化支付订单量
         */
        @JsonProperty("orderNum")
        private Long orderNum;

        /**
         * 广告计划ID
         */
        @JsonProperty("planId")
        private Long planId;

        /**
         * 广告计划名称
         */
        @JsonProperty("planName")
        private String planName;

        /**
         * 推广策略。0表示未知，1表示自定义推广，2表示智能推广。
         */
        @JsonProperty("planStrategy")
        private Integer planStrategy;

        /**
         * 广告惩罚原因
         */
        @JsonProperty("punishReason")
        private String punishReason;

        /**
         * 广告投入产出比
         */
        @JsonProperty("roi")
        private Double roi;

        /**
         * 广告消耗,单位厘
         */
        @JsonProperty("spend")
        private Long spend;

        /**
         * 单元状态。1表示推广中，2表示手动暂停，3表示商品售罄，4表示商品下架，5表示限制推广，6表示已删除，7表示审核中，8表示无推广中创意，9表示审核驳回。
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 商品图
         */
        @JsonProperty("thumbUrl")
        private String thumbUrl;

        /**
         * 转化成本
         */
        @JsonProperty("transactionCost")
        private Double transactionCost;

        /**
         * 广告单元ID
         */
        @JsonProperty("unitId")
        private Long unitId;

        /**
         * 广告单元名称
         */
        @JsonProperty("unitName")
        private String unitName;

        public Double getAvgPayAmount() {
            return avgPayAmount;
        }

        public Long getBid() {
            return bid;
        }

        public Long getCatId() {
            return catId;
        }

        public String getCatName() {
            return catName;
        }

        public Long getClick() {
            return click;
        }

        public Double getCpc() {
            return cpc;
        }

        public Double getCpm() {
            return cpm;
        }

        public Double getCtr() {
            return ctr;
        }

        public Double getCvr() {
            return cvr;
        }

        public Integer getDataAccumulationStatus() {
            return dataAccumulationStatus;
        }

        public Integer getDataOperateStatus() {
            return dataOperateStatus;
        }

        public Long getGmv() {
            return gmv;
        }

        public Long getGoodsFavNum() {
            return goodsFavNum;
        }

        public Long getGoodsId() {
            return goodsId;
        }

        public String getGoodsName() {
            return goodsName;
        }

        public Long getImpression() {
            return impression;
        }

        public Long getMallFavNum() {
            return mallFavNum;
        }

        public Long getMallId() {
            return mallId;
        }

        public Long getMaxGroupPrice() {
            return maxGroupPrice;
        }

        public Long getMinGroupPrice() {
            return minGroupPrice;
        }

        public Integer getOptimizationGoal() {
            return optimizationGoal;
        }

        public ResponseResultItemOptimizationOutputMessage getOptimizationOutputMessage() {
            return optimizationOutputMessage;
        }

        public Long getOrderNum() {
            return orderNum;
        }

        public Long getPlanId() {
            return planId;
        }

        public String getPlanName() {
            return planName;
        }

        public Integer getPlanStrategy() {
            return planStrategy;
        }

        public String getPunishReason() {
            return punishReason;
        }

        public Double getRoi() {
            return roi;
        }

        public Long getSpend() {
            return spend;
        }

        public Integer getStatus() {
            return status;
        }

        public String getThumbUrl() {
            return thumbUrl;
        }

        public Double getTransactionCost() {
            return transactionCost;
        }

        public Long getUnitId() {
            return unitId;
        }

        public String getUnitName() {
            return unitName;
        }
    }

    public static class ResponseResultItemOptimizationOutputMessage {

        /**
         * 优化出价
         */
        @JsonProperty("optimizationBid")
        private Long optimizationBid;

        /**
         * 优化启用时间。启用优化时未必立即开始，取决于数据积累状态。
         */
        @JsonProperty("optimizationEnableTime")
        private String optimizationEnableTime;

        /**
         * 优化目标。0表示不优化。1表示优化ROI，2表示优化转化成本。
         */
        @JsonProperty("optimizationGoal")
        private Integer optimizationGoal;

        /**
         * 优化方式。0表示不优化，1表示ECPC，2表示OCPC。
         */
        @JsonProperty("optimizationMethod")
        private Integer optimizationMethod;

        /**
         * 优化开始时间
         */
        @JsonProperty("optimizationStartTime")
        private String optimizationStartTime;

        /**
         * 可选优化目标信息列表
         */
        @JsonProperty("optionalOptimizationBidOutputMessageList")
        private List<ResponseResultItemOptimizationOutputMessageOptionalOptimizationBidOutputMessageListItem> optionalOptimizationBidOutputMessageList;

        public Long getOptimizationBid() {
            return optimizationBid;
        }

        public String getOptimizationEnableTime() {
            return optimizationEnableTime;
        }

        public Integer getOptimizationGoal() {
            return optimizationGoal;
        }

        public Integer getOptimizationMethod() {
            return optimizationMethod;
        }

        public String getOptimizationStartTime() {
            return optimizationStartTime;
        }

        public List<ResponseResultItemOptimizationOutputMessageOptionalOptimizationBidOutputMessageListItem> getOptionalOptimizationBidOutputMessageList() {
            return optionalOptimizationBidOutputMessageList;
        }
    }

    public static class ResponseResultItemOptimizationOutputMessageOptionalOptimizationBidOutputMessageListItem {

        /**
         * 可选优化目标出价
         */
        @JsonProperty("optimizationBid")
        private Long optimizationBid;

        /**
         * 可选优化目标
         */
        @JsonProperty("optimizationGoal")
        private Integer optimizationGoal;

        public Long getOptimizationBid() {
            return optimizationBid;
        }

        public Integer getOptimizationGoal() {
            return optimizationGoal;
        }
    }
}