package com.pdd.pop.sdk.http.api.pop.response;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.PopBaseHttpResponse;




public class PddFdsOrderGetResponse extends PopBaseHttpResponse {

    /**
     * response
     */
    @JsonProperty("pdd_fds_order_get_response")
    private InnerPddFdsOrderGetResponse pddFdsOrderGetResponse;

    public InnerPddFdsOrderGetResponse getPddFdsOrderGetResponse() {
        return pddFdsOrderGetResponse;
    }

    public static class InnerPddFdsOrderGetResponse {

        /**
         * 分配时间,毫秒
         */
        @JsonProperty("allow_time")
        private Long allowTime;

        /**
         * 市
         */
        @JsonProperty("city")
        private String city;

        /**
         * 区
         */
        @JsonProperty("district")
        private String district;

        /**
         * 商品名称
         */
        @JsonProperty("goods_name")
        private String goodsName;

        /**
         * 商品数量
         */
        @JsonProperty("goods_number")
        private Integer goodsNumber;

        /**
         * 规格
         */
        @JsonProperty("goods_spec")
        private String goodsSpec;

        /**
         * 代打店铺id
         */
        @JsonProperty("mall_mask_id")
        private String mallMaskId;

        /**
         * 代打店铺自定义名称
         */
        @JsonProperty("mall_mask_name")
        private String mallMaskName;

        /**
         * 代打订单号
         */
        @JsonProperty("order_mask_sn")
        private String orderMaskSn;

        /**
         * 省
         */
        @JsonProperty("province")
        private String province;

        /**
         * 卖家备注
         */
        @JsonProperty("remark")
        private String remark;

        /**
         * 分配状态 0：取消分配 1：已分配
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 结算价格，单位：分
         */
        @JsonProperty("product_price")
        private Integer productPrice;

        /**
         * 货号
         */
        @JsonProperty("product_sn")
        private String productSn;

        /**
         * 收件人姓名+电话+地址相同,receiver_id字段相同，该功能上线前字段为""
         */
        @JsonProperty("receiver_id")
        private String receiverId;

        /**
         * 商家设置的sku编码
         */
        @JsonProperty("out_sku_sn")
        private String outSkuSn;

        /**
         * 加价发顺丰0：不是 1：是
         */
        @JsonProperty("sf_only")
        private Integer sfOnly;

        /**
         * 运单回传状态 0：未回传 1：已回传
         */
        @JsonProperty("return_status")
        private Integer returnStatus;

        public Long getAllowTime() {
            return allowTime;
        }

        public String getCity() {
            return city;
        }

        public String getDistrict() {
            return district;
        }

        public String getGoodsName() {
            return goodsName;
        }

        public Integer getGoodsNumber() {
            return goodsNumber;
        }

        public String getGoodsSpec() {
            return goodsSpec;
        }

        public String getMallMaskId() {
            return mallMaskId;
        }

        public String getMallMaskName() {
            return mallMaskName;
        }

        public String getOrderMaskSn() {
            return orderMaskSn;
        }

        public String getProvince() {
            return province;
        }

        public String getRemark() {
            return remark;
        }

        public Integer getStatus() {
            return status;
        }

        public Integer getProductPrice() {
            return productPrice;
        }

        public String getProductSn() {
            return productSn;
        }

        public String getReceiverId() {
            return receiverId;
        }

        public String getOutSkuSn() {
            return outSkuSn;
        }

        public Integer getSfOnly() {
            return sfOnly;
        }

        public Integer getReturnStatus() {
            return returnStatus;
        }
    }
}