package com.pdd.pop.sdk.http.api.pop.response;

import com.pdd.pop.ext.fasterxml.jackson.annotation.JsonProperty;
import com.pdd.pop.sdk.http.PopBaseHttpResponse;

import java.util.List;



public class PddOpenKmsSearchBatchResponse extends PopBaseHttpResponse {

    /**
     * response
     */
    @JsonProperty("open_kms_search_batch_response")
    private OpenKmsSearchBatchResponse openKmsSearchBatchResponse;

    public OpenKmsSearchBatchResponse getOpenKmsSearchBatchResponse() {
        return openKmsSearchBatchResponse;
    }

    public static class OpenKmsSearchBatchResponse {

        /**
         * list
         */
        @JsonProperty("search_text_list")
        private List<OpenKmsSearchBatchResponseSearchTextListItem> searchTextList;

        public List<OpenKmsSearchBatchResponseSearchTextListItem> getSearchTextList() {
            return searchTextList;
        }
    }

    public static class OpenKmsSearchBatchResponseSearchTextListItem {

        /**
         * 输入的搜索内容
         */
        @JsonProperty("input")
        private String input;

        /**
         * search_text
         */
        @JsonProperty("search_text")
        private String searchText;

        /**
         * success
         */
        @JsonProperty("success")
        private Boolean success;

        /**
         * 敏感信息类型. id: 身份证号, phone: 手机号码, simple: 昵称, 地址等
         */
        @JsonProperty("type")
        private String type;

        public String getInput() {
            return input;
        }

        public String getSearchText() {
            return searchText;
        }

        public Boolean getSuccess() {
            return success;
        }

        public String getType() {
            return type;
        }
    }
}