/*
 * Decompiled with CFR 0.152.
 */
package com.ruleoftech.markdown.page.generator.plugin;

import com.ruleoftech.markdown.page.generator.plugin.MDToHTMLExpLinkRender;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.pegdown.Extensions;
import org.pegdown.LinkRenderer;
import org.pegdown.PegDownProcessor;

@Mojo(name="generate")
public class MdPageGeneratorMojo
extends AbstractMojo {
    @Parameter(property="generate.defaultTitle")
    private String defaultTitle;
    @Parameter(property="generate.alwaysUseDefaultTitle", defaultValue="false")
    private boolean alwaysUseDefaultTitle;
    @Parameter(property="generate.inputDirectory", defaultValue="${project.basedir}/src/main/resources/markdown/")
    private String inputDirectory;
    @Parameter(property="generate.outputDirectory", defaultValue="${project.build.directory}/html/")
    private String outputDirectory;
    @Parameter(property="generate.headerHtmlFile")
    private String headerHtmlFile;
    @Parameter(property="generate.footerHtmlFile")
    private String footerHtmlFile;
    @Parameter(property="generate.failIfFilesAreMissing", defaultValue="true")
    private boolean failIfFilesAreMissing;
    @Parameter(property="generate.recursiveInput", defaultValue="false")
    private boolean recursiveInput;
    @Parameter(property="generate.transformRelativeMarkdownLinks", defaultValue="false")
    private boolean transformRelativeMarkdownLinks;
    @Parameter(property="generate.inputEncoding", defaultValue="${project.build.sourceEncoding}")
    private String inputEncoding;
    @Parameter(property="generate.outputEncoding", defaultValue="${project.build.sourceEncoding}")
    private String outputEncoding;
    @Parameter(property="generate.parsingTimeoutInMillis")
    private Long parsingTimeoutInMillis;
    @Parameter(property="generate.inputFileExtension", defaultValue="md")
    private String inputFileExtension = "md";
    @Parameter(property="generate.pegdownExtensions", defaultValue="TABLES")
    private String pegdownExtensions;
    @Parameter(property="generate.copyDirectories")
    private String copyDirectories;
    private List<MarkdownDTO> markdownDTOs = new ArrayList<MarkdownDTO>();

    public void execute() throws MojoExecutionException {
        if (StringUtils.isNotEmpty((String)this.copyDirectories)) {
            this.getLog().info((CharSequence)"Copy files from directories");
            for (String dir : this.copyDirectories.split(",")) {
                this.copyFiles(this.inputDirectory + File.separator + dir, this.outputDirectory + File.separator + dir);
            }
        }
        this.getLog().info((CharSequence)"Read Markdown files from input directory");
        boolean hasFiles = this.readFiles();
        if (hasFiles) {
            this.getLog().info((CharSequence)"Process Pegdown extension options");
            int options = this.getPegdownExtensions(this.pegdownExtensions);
            this.getLog().info((CharSequence)"Parse Markdown to HTML");
            this.processMarkdown(this.markdownDTOs, options);
        }
    }

    private int getPegdownExtensions(String extensions) {
        int options = 0;
        for (String ext : Arrays.asList(extensions.split("\\s*,\\s*"))) {
            try {
                if (ext.isEmpty()) continue;
                Field f = Extensions.class.getField(ext);
                options |= f.getInt(null);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException("No such extension: " + ext);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot read int value for extension " + ext + ": " + e, e);
            }
        }
        return options;
    }

    private boolean readFiles() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Read files from: " + this.inputDirectory));
        try {
            File inputFile = new File(this.inputDirectory);
            if (!inputFile.exists()) {
                this.getLog().info((CharSequence)"There is no input folder for the project. Skipping.");
                return false;
            }
            int baseDepth = StringUtils.countMatches((String)inputFile.getAbsolutePath(), (String)File.separator);
            List<File> markdownFiles = this.getFilesAsArray(FileUtils.iterateFiles((File)new File(this.inputDirectory), (String[])new String[]{this.inputFileExtension}, (boolean)this.recursiveInput));
            for (File file : markdownFiles) {
                this.getLog().debug((CharSequence)("File getName() " + file.getName()));
                this.getLog().debug((CharSequence)("File getAbsolutePath() " + file.getAbsolutePath()));
                this.getLog().debug((CharSequence)("File getPath() " + file.getPath()));
                MarkdownDTO dto = new MarkdownDTO();
                dto.markdownFile = file;
                dto.folderDepth = StringUtils.countMatches((String)file.getAbsolutePath(), (String)File.separator) - (baseDepth + 1);
                if (this.alwaysUseDefaultTitle) {
                    dto.title = this.defaultTitle;
                } else {
                    List raw = FileUtils.readLines((File)file, (String)this.getInputEncoding());
                    dto.title = this.getTitle(raw);
                }
                for (String line : FileUtils.readLines((File)file, (String)this.getInputEncoding())) {
                    if (!MdPageGeneratorMojo.isVariableLine(line)) continue;
                    String key = line.replaceAll("(^\\{)|(=.*)", "");
                    String value = line.replaceAll("(^\\{(.*?)=)|(\\}$)", "");
                    this.getLog().debug((CharSequence)("Substitute: '" + key + "' -> '" + value + "'"));
                    dto.substitutes.put(key, value);
                }
                dto.htmlFile = new File(this.recursiveInput ? this.outputDirectory + File.separator + file.getParentFile().getPath().substring(inputFile.getPath().length()) + File.separator + file.getName().replaceAll("." + this.inputFileExtension, ".html") : this.outputDirectory + File.separator + file.getName().replaceAll("." + this.inputFileExtension, ".html"));
                this.markdownDTOs.add(dto);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to load file " + e.getMessage(), (Exception)e);
        }
        return true;
    }

    private void processMarkdown(List<MarkdownDTO> markdownDTOs, int options) throws MojoExecutionException {
        this.getLog().debug((CharSequence)"processMarkdown");
        this.getLog().debug((CharSequence)("inputEncoding: '" + this.getInputEncoding() + "', outputEncoding: '" + this.getOutputEncoding() + "'"));
        this.getLog().debug((CharSequence)("parsingTimeout: " + this.getParsingTimeoutInMillis() + " ms"));
        for (MarkdownDTO dto : markdownDTOs) {
            this.getLog().debug((CharSequence)("dto: " + dto));
            try {
                String headerHtml = "";
                String footerHtml = "";
                try {
                    if (StringUtils.isNotEmpty((String)this.headerHtmlFile)) {
                        headerHtml = FileUtils.readFileToString((File)new File(this.headerHtmlFile), (String)this.getInputEncoding());
                        headerHtml = this.addTitleToHtmlFile(headerHtml, dto.title);
                        headerHtml = this.replaceVariables(headerHtml, dto.substitutes);
                        headerHtml = this.updateRelativePaths(headerHtml, dto.folderDepth);
                    }
                    if (StringUtils.isNotEmpty((String)this.footerHtmlFile)) {
                        footerHtml = FileUtils.readFileToString((File)new File(this.footerHtmlFile), (String)this.getInputEncoding());
                        footerHtml = this.replaceVariables(footerHtml, dto.substitutes);
                        footerHtml = this.updateRelativePaths(footerHtml, dto.folderDepth);
                    }
                }
                catch (FileNotFoundException e) {
                    if (this.failIfFilesAreMissing) {
                        throw e;
                    }
                    this.getLog().warn((CharSequence)"header and/or footer file is missing.");
                    headerHtml = "";
                    footerHtml = "";
                }
                String markdown = FileUtils.readFileToString((File)dto.markdownFile, (String)this.getInputEncoding());
                markdown = this.replaceVariables(markdown, dto.substitutes);
                PegDownProcessor pegDownProcessor = new PegDownProcessor(options, this.getParsingTimeoutInMillis());
                String markdownAsHtml = this.transformRelativeMarkdownLinks ? pegDownProcessor.markdownToHtml(markdown, (LinkRenderer)new MDToHTMLExpLinkRender(this.inputFileExtension)) : pegDownProcessor.markdownToHtml(markdown);
                StringBuilder data = new StringBuilder();
                data.append(headerHtml);
                data.append(markdownAsHtml);
                data.append(footerHtml);
                FileUtils.writeStringToFile((File)dto.htmlFile, (String)data.toString(), (String)this.getOutputEncoding());
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Error : " + e.getMessage()), (Throwable)e);
                throw new MojoExecutionException("Unable to write file " + e.getMessage(), (Exception)e);
            }
        }
    }

    private String getInputEncoding() {
        if (StringUtils.isBlank((String)this.inputEncoding)) {
            return Charset.defaultCharset().name();
        }
        return this.inputEncoding;
    }

    private String getOutputEncoding() {
        if (StringUtils.isBlank((String)this.outputEncoding)) {
            return Charset.defaultCharset().name();
        }
        return this.outputEncoding;
    }

    public String getInputFileExtension() {
        return this.inputFileExtension;
    }

    private long getParsingTimeoutInMillis() {
        if (this.parsingTimeoutInMillis != null) {
            return this.parsingTimeoutInMillis;
        }
        return 2000L;
    }

    private String getTitle(List<String> raw) {
        if (raw == null) {
            return this.defaultTitle;
        }
        String previousLine = "";
        for (String line : raw) {
            if ((line = line.trim()).startsWith("#")) {
                line = line.replace("#", "");
                return line;
            }
            if (line.startsWith("=") && StringUtils.countMatches((String)line, (String)"=") == previousLine.length() && line.matches("^=+$") || line.startsWith("-") && StringUtils.countMatches((String)line, (String)"-") == previousLine.length() && line.matches("^-+$")) {
                return previousLine;
            }
            previousLine = line;
        }
        return this.defaultTitle;
    }

    private String addTitleToHtmlFile(String html, String title) {
        if (html == null) {
            return html;
        }
        if (title != null) {
            this.getLog().debug((CharSequence)("Setting the title in the HTML file to: " + title));
            return html.replaceFirst("titleToken", title);
        }
        this.getLog().debug((CharSequence)"Title was null, setting the title in the HTML file to an empty string");
        return html.replaceFirst("titleToken", "");
    }

    private String replaceVariables(String initialContent, Map<String, String> variables) {
        if (initialContent == null) {
            return null;
        }
        String newContent = initialContent.replaceAll("(\\{.*=.*\\}?)", "");
        if (variables != null) {
            for (Map.Entry<String, String> substitute : variables.entrySet()) {
                newContent = newContent.replace("${" + substitute.getKey() + "}", substitute.getValue());
            }
        }
        return newContent;
    }

    private static boolean isVariableLine(String line) {
        return line.matches("^\\{.*=.*\\}$");
    }

    private String updateRelativePaths(String html, int folderDepth) {
        if (html == null) {
            return html;
        }
        this.getLog().debug((CharSequence)"Updating relative paths in html includes (css, js).");
        return html.replaceAll("##SITE_BASE##", this.getSiteBasePrefix(folderDepth));
    }

    private String getSiteBasePrefix(int folderDepth) {
        String pathToBase = ".";
        while (folderDepth > 0) {
            pathToBase = pathToBase + "/..";
            --folderDepth;
        }
        return pathToBase;
    }

    private void copyFiles(String fromDir, String toDir) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("fromDir=" + fromDir + "; toDir=" + toDir));
        try {
            File fromDirFile = new File(fromDir);
            if (fromDirFile.exists()) {
                Iterator files = FileUtils.iterateFiles((File)new File(fromDir), null, (boolean)false);
                while (files.hasNext()) {
                    File file = (File)files.next();
                    if (file.exists()) {
                        FileUtils.copyFileToDirectory((File)file, (File)new File(toDir));
                        continue;
                    }
                    this.getLog().error((CharSequence)("File '" + file.getAbsolutePath() + "' does not exist. Skipping copy"));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy file " + e.getMessage(), (Exception)e);
        }
    }

    private List<File> getFilesAsArray(Iterator<File> iterator) {
        ArrayList<File> files = new ArrayList<File>();
        while (iterator.hasNext()) {
            files.add(iterator.next());
        }
        return files;
    }

    private class MarkdownDTO {
        public String title;
        public Map<String, String> substitutes = new HashMap<String, String>();
        public File htmlFile;
        public File markdownFile;
        public int folderDepth = 0;

        private MarkdownDTO() {
        }
    }

    private static enum EPegdownExtensions {
        NONE(0),
        SMARTS(1),
        QUOTES(2),
        SMARTYPANTS(SMARTS.getValue() + QUOTES.getValue()),
        ABBREVIATIONS(4),
        HARDWRAPS(8),
        AUTOLINKS(16),
        TABLES(32),
        DEFINITIONS(64),
        FENCED_CODE_BLOCKS(128),
        WIKILINKS(256),
        ALL(65535),
        SUPPRESS_HTML_BLOCKS(65536),
        SUPPRESS_INLINE_HTML(131072),
        SUPPRESS_ALL_HTML(196608),
        ANCHORLINKS(1024);

        private final int value;

        private EPegdownExtensions(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

