/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.messages.AutoValue_RegistryConfigs;
import com.spotify.docker.client.messages.AutoValue_RegistryConfigs_RegistryConfig;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.docker.client.shaded.javax.annotation.Nullable;
import java.util.Collections;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class RegistryConfigs {
    private static final RegistryConfigs EMPTY = RegistryConfigs.create(Collections.emptyMap());

    public static RegistryConfigs empty() {
        return EMPTY;
    }

    public abstract ImmutableMap<String, RegistryConfig> configs();

    @JsonCreator
    public static RegistryConfigs create(Map<String, RegistryConfig> configs) {
        ImmutableMap configsT = configs == null ? ImmutableMap.of() : ImmutableMap.copyOf(configs);
        return new AutoValue_RegistryConfigs((ImmutableMap<String, RegistryConfig>)configsT);
    }

    public static abstract class RegistryConfig {
        @JsonProperty(value="serveraddress")
        public abstract String serverAddress();

        @Nullable
        @JsonProperty(value="username")
        public abstract String username();

        @Nullable
        @JsonProperty(value="password")
        public abstract String password();

        @Nullable
        @JsonProperty(value="email")
        public abstract String email();

        @JsonProperty(value="auth")
        public abstract String auth();

        public static RegistryConfig create(String serveraddress, String username, String password, String email) {
            return RegistryConfig.create(serveraddress, username, password, email, "");
        }

        @JsonCreator
        static RegistryConfig create(@JsonProperty(value="serveraddress") String serveraddress, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="email") String email, @JsonProperty(value="auth") String auth) {
            return new AutoValue_RegistryConfigs_RegistryConfig(serveraddress, username, password, email, auth);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("serverAddress", (Object)this.serverAddress()).add("username", (Object)this.username()).add("email", (Object)this.email()).add("auth", (Object)this.auth()).toString();
        }
    }
}

