package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TbkActivityInfoGetResponse;

/**
 * TOP API: taobao.tbk.activity.info.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.12.05
 */
public class TbkActivityInfoGetRequest extends BaseTaobaoRequest<TbkActivityInfoGetResponse> {
	
	

	/** 
	* 官方活动会场ID，从淘宝客后台“我要推广-活动推广”中获取
	 */
	private String activityMaterialId;

	/** 
	* mm_xxx_xxx_xxx的第三位
	 */
	private Long adzoneId;

	/** 
	* 渠道关系id
	 */
	private Long relationId;

	/** 
	* mm_xxx_xxx_xxx 仅三方分成场景使用
	 */
	private String subPid;

	/** 
	* 自定义输入串，英文和数字组成，长度不能大于12个字符，区分不同的推广渠道
	 */
	private String unionId;

	public void setActivityMaterialId(String activityMaterialId) {
		this.activityMaterialId = activityMaterialId;
	}

	public String getActivityMaterialId() {
		return this.activityMaterialId;
	}

	public void setAdzoneId(Long adzoneId) {
		this.adzoneId = adzoneId;
	}

	public Long getAdzoneId() {
		return this.adzoneId;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Long getRelationId() {
		return this.relationId;
	}

	public void setSubPid(String subPid) {
		this.subPid = subPid;
	}

	public String getSubPid() {
		return this.subPid;
	}

	public void setUnionId(String unionId) {
		this.unionId = unionId;
	}

	public String getUnionId() {
		return this.unionId;
	}

	public String getApiMethodName() {
		return "taobao.tbk.activity.info.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("activity_material_id", this.activityMaterialId);
		txtParams.put("adzone_id", this.adzoneId);
		txtParams.put("relation_id", this.relationId);
		txtParams.put("sub_pid", this.subPid);
		txtParams.put("union_id", this.unionId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TbkActivityInfoGetResponse> getResponseClass() {
		return TbkActivityInfoGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(activityMaterialId, "activityMaterialId");
		RequestCheckUtils.checkNotEmpty(adzoneId, "adzoneId");
	}
	

}