package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TbkDgOptimusPromotionResponse;

/**
 * TOP API: taobao.tbk.dg.optimus.promotion request
 * 
 * @author top auto create
 * @since 1.0, 2022.06.20
 */
public class TbkDgOptimusPromotionRequest extends BaseTaobaoRequest<TbkDgOptimusPromotionResponse> {
	
	

	/** 
	* mm_xxx_xxx_xxx的第3段数字
	 */
	private Long adzoneId;

	/** 
	* 第几页，默认：1
	 */
	private Long pageNum;

	/** 
	* 页大小，一次请求请限制在10以内
	 */
	private Long pageSize;

	/** 
	* 官方提供的权益物料Id。有价券-37104、大额店铺券-37116、天猫店铺券-62191、券券补-61809 更多权益物料id敬请期待！
	 */
	private Long promotionId;

	public void setAdzoneId(Long adzoneId) {
		this.adzoneId = adzoneId;
	}

	public Long getAdzoneId() {
		return this.adzoneId;
	}

	public void setPageNum(Long pageNum) {
		this.pageNum = pageNum;
	}

	public Long getPageNum() {
		return this.pageNum;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setPromotionId(Long promotionId) {
		this.promotionId = promotionId;
	}

	public Long getPromotionId() {
		return this.promotionId;
	}

	public String getApiMethodName() {
		return "taobao.tbk.dg.optimus.promotion";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("adzone_id", this.adzoneId);
		txtParams.put("page_num", this.pageNum);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("promotion_id", this.promotionId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TbkDgOptimusPromotionResponse> getResponseClass() {
		return TbkDgOptimusPromotionResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(adzoneId, "adzoneId");
		RequestCheckUtils.checkNotEmpty(promotionId, "promotionId");
	}
	

}