package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TbkDgPunishOrderGetResponse;

/**
 * TOP API: taobao.tbk.dg.punish.order.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.10.11
 */
public class TbkDgPunishOrderGetRequest extends BaseTaobaoRequest<TbkDgPunishOrderGetResponse> {
	
	

	/** 
	* 入参的对象
	 */
	private String afOrderOption;

	public void setAfOrderOption(String afOrderOption) {
		this.afOrderOption = afOrderOption;
	}

	public void setAfOrderOption(TopApiAfOrderOption afOrderOption) {
		this.afOrderOption = new JSONWriter(false,true).write(afOrderOption);
	}

	public String getAfOrderOption() {
		return this.afOrderOption;
	}

	public String getApiMethodName() {
		return "taobao.tbk.dg.punish.order.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("af_order_option", this.afOrderOption);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TbkDgPunishOrderGetResponse> getResponseClass() {
		return TbkDgPunishOrderGetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 入参的对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopApiAfOrderOption extends TaobaoObject {

	private static final long serialVersionUID = 5371976848654165435L;

	/**
		 * pid中的第三段，adzoneId
		 */
		@ApiField("adzone_id")
		private Long adzoneId;
		/**
		 * pageNo
		 */
		@ApiField("page_no")
		private Long pageNo;
		/**
		 * pagesize
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 此参数不再使用，请勿入参
		 */
		@ApiField("punish_status")
		private Long punishStatus;
		/**
		 * 渠道关系id
		 */
		@ApiField("relation_id")
		private Long relationId;
		/**
		 * pid中的第二段，siteId
		 */
		@ApiField("site_id")
		private Long siteId;
		/**
		 * 查询时间跨度，不超过30天，单位是天
		 */
		@ApiField("span")
		private Long span;
		/**
		 * 此参数不再使用，请勿入参
		 */
		@ApiField("special_id")
		private Long specialId;
		/**
		 * 查询开始时间，以taoke订单创建时间开始
		 */
		@ApiField("start_time")
		private Date startTime;
		/**
		 * 子订单号
		 */
		@ApiField("tb_trade_id")
		private Long tbTradeId;
		/**
		 * 此参数不再使用，请勿入参
		 */
		@ApiField("tb_trade_parent_id")
		private Long tbTradeParentId;
		/**
		 * 此参数不再使用，请勿入参
		 */
		@ApiField("violation_type")
		private Long violationType;
	

	public Long getAdzoneId() {
			return this.adzoneId;
		}
		public void setAdzoneId(Long adzoneId) {
			this.adzoneId = adzoneId;
		}
		public Long getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(Long pageNo) {
			this.pageNo = pageNo;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public Long getPunishStatus() {
			return this.punishStatus;
		}
		public void setPunishStatus(Long punishStatus) {
			this.punishStatus = punishStatus;
		}
		public Long getRelationId() {
			return this.relationId;
		}
		public void setRelationId(Long relationId) {
			this.relationId = relationId;
		}
		public Long getSiteId() {
			return this.siteId;
		}
		public void setSiteId(Long siteId) {
			this.siteId = siteId;
		}
		public Long getSpan() {
			return this.span;
		}
		public void setSpan(Long span) {
			this.span = span;
		}
		public Long getSpecialId() {
			return this.specialId;
		}
		public void setSpecialId(Long specialId) {
			this.specialId = specialId;
		}
		public Date getStartTime() {
			return this.startTime;
		}
		public void setStartTime(Date startTime) {
			this.startTime = startTime;
		}
		public Long getTbTradeId() {
			return this.tbTradeId;
		}
		public void setTbTradeId(Long tbTradeId) {
			this.tbTradeId = tbTradeId;
		}
		public Long getTbTradeParentId() {
			return this.tbTradeParentId;
		}
		public void setTbTradeParentId(Long tbTradeParentId) {
			this.tbTradeParentId = tbTradeParentId;
		}
		public Long getViolationType() {
			return this.violationType;
		}
		public void setViolationType(Long violationType) {
			this.violationType = violationType;
		}

}


}