package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TbkDgVegasTljStopResponse;

/**
 * TOP API: taobao.tbk.dg.vegas.tlj.stop request
 * 
 * @author top auto create
 * @since 1.0, 2021.09.27
 */
public class TbkDgVegasTljStopRequest extends BaseTaobaoRequest<TbkDgVegasTljStopResponse> {
	
	

	/** 
	* adzoneId
	 */
	private Long adzoneId;

	/** 
	* 创建淘礼金时返回的rightsId
	 */
	private String rightsId;

	public void setAdzoneId(Long adzoneId) {
		this.adzoneId = adzoneId;
	}

	public Long getAdzoneId() {
		return this.adzoneId;
	}

	public void setRightsId(String rightsId) {
		this.rightsId = rightsId;
	}

	public String getRightsId() {
		return this.rightsId;
	}

	public String getApiMethodName() {
		return "taobao.tbk.dg.vegas.tlj.stop";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("adzone_id", this.adzoneId);
		txtParams.put("rights_id", this.rightsId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TbkDgVegasTljStopResponse> getResponseClass() {
		return TbkDgVegasTljStopResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(adzoneId, "adzoneId");
		RequestCheckUtils.checkNotEmpty(rightsId, "rightsId");
	}
	

}