package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TbkItemInfoGetResponse;

/**
 * TOP API: taobao.tbk.item.info.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.08.31
 */
public class TbkItemInfoGetRequest extends BaseTaobaoRequest<TbkItemInfoGetResponse> {
	
	

	/** 
	* 1-动态ID转链场景，2-消费者比价场景，3-商品库导购场景（不填默认为1）
	 */
	private String bizSceneId;

	/** 
	* ip地址，影响邮费获取，如果不传或者传入不准确，邮费无法精准提供
	 */
	private String ip;

	/** 
	* 商品ID串，用,分割，最大40个
	 */
	private String numIids;

	/** 
	* 链接形式：1：PC，2：无线，默认：１
	 */
	private Long platform;

	/** 
	* 1-自购省，2-推广赚（代理模式专属ID，代理模式必填，非代理模式不用填写该字段）
	 */
	private String promotionType;

	public void setBizSceneId(String bizSceneId) {
		this.bizSceneId = bizSceneId;
	}

	public String getBizSceneId() {
		return this.bizSceneId;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public String getIp() {
		return this.ip;
	}

	public void setNumIids(String numIids) {
		this.numIids = numIids;
	}

	public String getNumIids() {
		return this.numIids;
	}

	public void setPlatform(Long platform) {
		this.platform = platform;
	}

	public Long getPlatform() {
		return this.platform;
	}

	public void setPromotionType(String promotionType) {
		this.promotionType = promotionType;
	}

	public String getPromotionType() {
		return this.promotionType;
	}

	public String getApiMethodName() {
		return "taobao.tbk.item.info.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_scene_id", this.bizSceneId);
		txtParams.put("ip", this.ip);
		txtParams.put("num_iids", this.numIids);
		txtParams.put("platform", this.platform);
		txtParams.put("promotion_type", this.promotionType);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TbkItemInfoGetResponse> getResponseClass() {
		return TbkItemInfoGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(numIids, "numIids");
	}
	

}