package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TbkScPublisherInfoGetResponse;

/**
 * TOP API: taobao.tbk.sc.publisher.info.get request
 * 
 * @author top auto create
 * @since 1.0, 2023.02.09
 */
public class TbkScPublisherInfoGetRequest extends BaseTaobaoRequest<TbkScPublisherInfoGetResponse> {
	
	

	/** 
	* 淘宝客外部用户标记，如自身系统账户ID；微信ID等
	 */
	private String externalId;

	/** 
	* 1-微信、2-微博、3-抖音、4-快手、5-QQ，0-其他；默认为0
	 */
	private Long externalType;

	/** 
	* 类型，必选 1:渠道信息；2:会员信息
	 */
	private Long infoType;

	/** 
	* 第几页
	 */
	private Long pageNo;

	/** 
	* 每页大小
	 */
	private Long pageSize;

	/** 
	* 备案的场景：common（通用备案），etao（一淘备案），minietao（一淘小程序备案），offlineShop（线下门店备案），offlinePerson（线下个人备案）。如不填默认common。查询会员信息只需填写common即可
	 */
	private String relationApp;

	/** 
	* 渠道独占 - 渠道关系ID
	 */
	private Long relationId;

	/** 
	* 会员独占 - 会员运营ID
	 */
	private String specialId;

	public void setExternalId(String externalId) {
		this.externalId = externalId;
	}

	public String getExternalId() {
		return this.externalId;
	}

	public void setExternalType(Long externalType) {
		this.externalType = externalType;
	}

	public Long getExternalType() {
		return this.externalType;
	}

	public void setInfoType(Long infoType) {
		this.infoType = infoType;
	}

	public Long getInfoType() {
		return this.infoType;
	}

	public void setPageNo(Long pageNo) {
		this.pageNo = pageNo;
	}

	public Long getPageNo() {
		return this.pageNo;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setRelationApp(String relationApp) {
		this.relationApp = relationApp;
	}

	public String getRelationApp() {
		return this.relationApp;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Long getRelationId() {
		return this.relationId;
	}

	public void setSpecialId(String specialId) {
		this.specialId = specialId;
	}

	public String getSpecialId() {
		return this.specialId;
	}

	public String getApiMethodName() {
		return "taobao.tbk.sc.publisher.info.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("external_id", this.externalId);
		txtParams.put("external_type", this.externalType);
		txtParams.put("info_type", this.infoType);
		txtParams.put("page_no", this.pageNo);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("relation_app", this.relationApp);
		txtParams.put("relation_id", this.relationId);
		txtParams.put("special_id", this.specialId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TbkScPublisherInfoGetResponse> getResponseClass() {
		return TbkScPublisherInfoGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(infoType, "infoType");
		RequestCheckUtils.checkNotEmpty(relationApp, "relationApp");
	}
	

}