package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TbkTpwdCreateResponse;

/**
 * TOP API: taobao.tbk.tpwd.create request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.24
 */
public class TbkTpwdCreateRequest extends BaseTaobaoRequest<TbkTpwdCreateResponse> {
	
	

	/** 
	* 兼容旧版本api参数，无实际作用
	 */
	private String ext;

	/** 
	* 兼容旧版本api参数，无实际作用
	 */
	private String logo;

	/** 
	* 兼容旧版本api参数，无实际作用
	 */
	private String text;

	/** 
	* 联盟官方渠道获取的淘客推广链接，请注意，不要随意篡改官方生成的链接，否则可能无法生成淘口令
	 */
	private String url;

	/** 
	* 兼容旧版本api参数，无实际作用
	 */
	private String userId;

	public void setExt(String ext) {
		this.ext = ext;
	}

	public String getExt() {
		return this.ext;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public String getLogo() {
		return this.logo;
	}

	public void setText(String text) {
		this.text = text;
	}

	public String getText() {
		return this.text;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getUrl() {
		return this.url;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getUserId() {
		return this.userId;
	}

	public String getApiMethodName() {
		return "taobao.tbk.tpwd.create";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("ext", this.ext);
		txtParams.put("logo", this.logo);
		txtParams.put("text", this.text);
		txtParams.put("url", this.url);
		txtParams.put("user_id", this.userId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TbkTpwdCreateResponse> getResponseClass() {
		return TbkTpwdCreateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(url, "url");
	}
	

}