package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.tbk.dg.optimus.material response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TbkDgOptimusMaterialResponse extends TaobaoResponse {

	private static final long serialVersionUID = 1458768492769682781L;

	/** 
	 * 推荐信息-是否抄底
	 */
	@ApiField("is_default")
	private String isDefault;

	/** 
	 * resultList
	 */
	@ApiListField("result_list")
	@ApiField("map_data")
	private List<MapData> resultList;

	/** 
	 * 商品总数-目前只有全品库商品查询有该字段
	 */
	@ApiField("total_count")
	private Long totalCount;


	public void setIsDefault(String isDefault) {
		this.isDefault = isDefault;
	}
	public String getIsDefault( ) {
		return this.isDefault;
	}

	public void setResultList(List<MapData> resultList) {
		this.resultList = resultList;
	}
	public List<MapData> getResultList( ) {
		return this.resultList;
	}

	public void setTotalCount(Long totalCount) {
		this.totalCount = totalCount;
	}
	public Long getTotalCount( ) {
		return this.totalCount;
	}
	
	/**
 * 商品信息-商品关联词
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class WordMapData extends TaobaoObject {

	private static final long serialVersionUID = 2114839738651491945L;

	/**
		 * 链接-商品相关关联词落地页地址
		 */
		@ApiField("url")
		private String url;
		/**
		 * 商品相关的关联词
		 */
		@ApiField("word")
		private String word;
	

	public String getUrl() {
			return this.url;
		}
		public void setUrl(String url) {
			this.url = url;
		}
		public String getWord() {
			return this.word;
		}
		public void setWord(String word) {
			this.word = word;
		}

}

	/**
 * 选品库详细信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class FavoritesDetail extends TaobaoObject {

	private static final long serialVersionUID = 1751671929358164515L;

	/**
		 * 选品库id
		 */
		@ApiField("favorites_id")
		private Long favoritesId;
		/**
		 * 选品库标题
		 */
		@ApiField("favorites_title")
		private String favoritesTitle;
	

	public Long getFavoritesId() {
			return this.favoritesId;
		}
		public void setFavoritesId(Long favoritesId) {
			this.favoritesId = favoritesId;
		}
		public String getFavoritesTitle() {
			return this.favoritesTitle;
		}
		public void setFavoritesTitle(String favoritesTitle) {
			this.favoritesTitle = favoritesTitle;
		}

}

	/**
 * 选品库信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class FavoritesInfo extends TaobaoObject {

	private static final long serialVersionUID = 3453744299559263877L;

	/**
		 * 选品库详细信息
		 */
		@ApiListField("favorites_list")
		@ApiField("favorites_detail")
		private List<FavoritesDetail> favoritesList;
		/**
		 * 选品库总数量
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public List<FavoritesDetail> getFavoritesList() {
			return this.favoritesList;
		}
		public void setFavoritesList(List<FavoritesDetail> favoritesList) {
			this.favoritesList = favoritesList;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}

	/**
 * 前N件佣金信息-前N件佣金生效或预热时透出以下字段
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopNInfoDTO extends TaobaoObject {

	private static final long serialVersionUID = 7485476262176692332L;

	/**
		 * 前N件佣金结束时间
		 */
		@ApiField("topn_end_time")
		private String topnEndTime;
		/**
		 * 前N件剩余库存
		 */
		@ApiField("topn_quantity")
		private Long topnQuantity;
		/**
		 * 前N件佣金率
		 */
		@ApiField("topn_rate")
		private String topnRate;
		/**
		 * 前N件佣金开始时间
		 */
		@ApiField("topn_start_time")
		private String topnStartTime;
		/**
		 * 前N件初始总库存
		 */
		@ApiField("topn_total_count")
		private Long topnTotalCount;
	

	public String getTopnEndTime() {
			return this.topnEndTime;
		}
		public void setTopnEndTime(String topnEndTime) {
			this.topnEndTime = topnEndTime;
		}
		public Long getTopnQuantity() {
			return this.topnQuantity;
		}
		public void setTopnQuantity(Long topnQuantity) {
			this.topnQuantity = topnQuantity;
		}
		public String getTopnRate() {
			return this.topnRate;
		}
		public void setTopnRate(String topnRate) {
			this.topnRate = topnRate;
		}
		public String getTopnStartTime() {
			return this.topnStartTime;
		}
		public void setTopnStartTime(String topnStartTime) {
			this.topnStartTime = topnStartTime;
		}
		public Long getTopnTotalCount() {
			return this.topnTotalCount;
		}
		public void setTopnTotalCount(Long topnTotalCount) {
			this.topnTotalCount = topnTotalCount;
		}

}

	/**
 * 百亿补贴信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BybtInfoDTO extends TaobaoObject {

	private static final long serialVersionUID = 3412183135654814761L;

	/**
		 * 百亿补贴品牌logo
		 */
		@ApiField("bybt_brand_logo")
		private String bybtBrandLogo;
		/**
		 * 百亿补贴专属券面额，仅限百亿补贴场景透出
		 */
		@ApiField("bybt_coupon_amount")
		private String bybtCouponAmount;
		/**
		 * 商品的百亿补贴开始时间
		 */
		@ApiField("bybt_end_time")
		private String bybtEndTime;
		/**
		 * 百亿补贴商品特征标签，eg.今日发货、晚发补偿、限购一件等
		 */
		@ApiListField("bybt_item_tags")
		@ApiField("string")
		private List<String> bybtItemTags;
		/**
		 * 全网对比参考价格
		 */
		@ApiField("bybt_lowest_price")
		private String bybtLowestPrice;
		/**
		 * 百亿补贴白底图
		 */
		@ApiField("bybt_pic_url")
		private String bybtPicUrl;
		/**
		 * 百亿补贴页面实时价
		 */
		@ApiField("bybt_show_price")
		private String bybtShowPrice;
		/**
		 * 商品的百亿补贴结束时间
		 */
		@ApiField("bybt_start_time")
		private String bybtStartTime;
	

	public String getBybtBrandLogo() {
			return this.bybtBrandLogo;
		}
		public void setBybtBrandLogo(String bybtBrandLogo) {
			this.bybtBrandLogo = bybtBrandLogo;
		}
		public String getBybtCouponAmount() {
			return this.bybtCouponAmount;
		}
		public void setBybtCouponAmount(String bybtCouponAmount) {
			this.bybtCouponAmount = bybtCouponAmount;
		}
		public String getBybtEndTime() {
			return this.bybtEndTime;
		}
		public void setBybtEndTime(String bybtEndTime) {
			this.bybtEndTime = bybtEndTime;
		}
		public List<String> getBybtItemTags() {
			return this.bybtItemTags;
		}
		public void setBybtItemTags(List<String> bybtItemTags) {
			this.bybtItemTags = bybtItemTags;
		}
		public String getBybtLowestPrice() {
			return this.bybtLowestPrice;
		}
		public void setBybtLowestPrice(String bybtLowestPrice) {
			this.bybtLowestPrice = bybtLowestPrice;
		}
		public String getBybtPicUrl() {
			return this.bybtPicUrl;
		}
		public void setBybtPicUrl(String bybtPicUrl) {
			this.bybtPicUrl = bybtPicUrl;
		}
		public String getBybtShowPrice() {
			return this.bybtShowPrice;
		}
		public void setBybtShowPrice(String bybtShowPrice) {
			this.bybtShowPrice = bybtShowPrice;
		}
		public String getBybtStartTime() {
			return this.bybtStartTime;
		}
		public void setBybtStartTime(String bybtStartTime) {
			this.bybtStartTime = bybtStartTime;
		}

}

	/**
 * 猫超买返卡信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class MaifanPromotionDTO extends TaobaoObject {

	private static final long serialVersionUID = 5183456957276443622L;

	/**
		 * 猫超买返卡总数，-1代表不限量，其他大于等于0的值为总数
		 */
		@ApiField("maifan_promotion_condition")
		private String maifanPromotionCondition;
		/**
		 * 猫超买返卡面额
		 */
		@ApiField("maifan_promotion_discount")
		private String maifanPromotionDiscount;
		/**
		 * 猫超买返卡活动结束时间
		 */
		@ApiField("maifan_promotion_end_time")
		private String maifanPromotionEndTime;
		/**
		 * 猫超买返卡活动开始时间
		 */
		@ApiField("maifan_promotion_start_time")
		private String maifanPromotionStartTime;
	

	public String getMaifanPromotionCondition() {
			return this.maifanPromotionCondition;
		}
		public void setMaifanPromotionCondition(String maifanPromotionCondition) {
			this.maifanPromotionCondition = maifanPromotionCondition;
		}
		public String getMaifanPromotionDiscount() {
			return this.maifanPromotionDiscount;
		}
		public void setMaifanPromotionDiscount(String maifanPromotionDiscount) {
			this.maifanPromotionDiscount = maifanPromotionDiscount;
		}
		public String getMaifanPromotionEndTime() {
			return this.maifanPromotionEndTime;
		}
		public void setMaifanPromotionEndTime(String maifanPromotionEndTime) {
			this.maifanPromotionEndTime = maifanPromotionEndTime;
		}
		public String getMaifanPromotionStartTime() {
			return this.maifanPromotionStartTime;
		}
		public void setMaifanPromotionStartTime(String maifanPromotionStartTime) {
			this.maifanPromotionStartTime = maifanPromotionStartTime;
		}

}

	/**
 * 定向计划集合
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SpCampaign extends TaobaoObject {

	private static final long serialVersionUID = 4556791819798979315L;

	/**
		 * 定向计划申请链接
		 */
		@ApiField("sp_apply_link")
		private String spApplyLink;
		/**
		 * 定向计划活动ID
		 */
		@ApiField("sp_cid")
		private String spCid;
		/**
		 * 定向是否锁佣，0=不锁佣 1=锁佣
		 */
		@ApiField("sp_lock_status")
		private String spLockStatus;
		/**
		 * 定向计划名称
		 */
		@ApiField("sp_name")
		private String spName;
		/**
		 * 定向佣金率
		 */
		@ApiField("sp_rate")
		private String spRate;
		/**
		 * 定向计划是否可用 1-可用 0-不可用
		 */
		@ApiField("sp_status")
		private String spStatus;
	

	public String getSpApplyLink() {
			return this.spApplyLink;
		}
		public void setSpApplyLink(String spApplyLink) {
			this.spApplyLink = spApplyLink;
		}
		public String getSpCid() {
			return this.spCid;
		}
		public void setSpCid(String spCid) {
			this.spCid = spCid;
		}
		public String getSpLockStatus() {
			return this.spLockStatus;
		}
		public void setSpLockStatus(String spLockStatus) {
			this.spLockStatus = spLockStatus;
		}
		public String getSpName() {
			return this.spName;
		}
		public void setSpName(String spName) {
			this.spName = spName;
		}
		public String getSpRate() {
			return this.spRate;
		}
		public void setSpRate(String spRate) {
			this.spRate = spRate;
		}
		public String getSpStatus() {
			return this.spStatus;
		}
		public void setSpStatus(String spStatus) {
			this.spStatus = spStatus;
		}

}

	/**
 * resultList
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class MapData extends TaobaoObject {

	private static final long serialVersionUID = 4258921144965525627L;

	/**
		 * 合作伙伴单单补ID，用作“年货节超级单单补”活动合作伙伴奖励统计依据
		 */
		@ApiField("activity_id")
		private String activityId;
		/**
		 * 百亿补贴信息
		 */
		@ApiField("bybt_info")
		private BybtInfoDTO bybtInfo;
		/**
		 * 商品信息-叶子类目id
		 */
		@ApiField("category_id")
		private Long categoryId;
		/**
		 * 商品信息-叶子类目名称
		 */
		@ApiField("category_name")
		private String categoryName;
		/**
		 * 链接-宝贝推广链接
		 */
		@ApiField("click_url")
		private String clickUrl;
		/**
		 * 商品信息-佣金比率(%)
		 */
		@ApiField("commission_rate")
		private String commissionRate;
		/**
		 * 优惠券（元） 若属于预售商品，该优惠券付尾款可用，付定金不可用
		 */
		@ApiField("coupon_amount")
		private Long couponAmount;
		/**
		 * 链接-宝贝+券二合一页面链接(该字段废弃，请勿再用)
		 */
		@ApiField("coupon_click_url")
		private String couponClickUrl;
		/**
		 * 优惠券信息-优惠券结束时间
		 */
		@ApiField("coupon_end_time")
		private String couponEndTime;
		/**
		 * 优惠券信息-优惠券满减信息
		 */
		@ApiField("coupon_info")
		private String couponInfo;
		/**
		 * 优惠券信息-优惠券剩余量
		 */
		@ApiField("coupon_remain_count")
		private Long couponRemainCount;
		/**
		 * 链接-宝贝+券二合一页面链接
		 */
		@ApiField("coupon_share_url")
		private String couponShareUrl;
		/**
		 * 优惠券信息-优惠券起用门槛，满X元可用。如：满299元减20元
		 */
		@ApiField("coupon_start_fee")
		private String couponStartFee;
		/**
		 * 优惠券信息-优惠券开始时间
		 */
		@ApiField("coupon_start_time")
		private String couponStartTime;
		/**
		 * 优惠券信息-优惠券总量
		 */
		@ApiField("coupon_total_count")
		private Long couponTotalCount;
		/**
		 * 额外奖励活动金额，活动奖励金额的类型与cpa_reward_type字段对应，如果一个商品有多个奖励类型，返回结果使用空格分割
		 */
		@ApiField("cpa_reward_amount")
		private String cpaRewardAmount;
		/**
		 * 额外奖励活动类型，如果一个商品有多个奖励类型，返回结果使用空格分割，0=单单奖励(已失效)，1=超级单单奖励(已失效)，2=年货节单单奖励
		 */
		@ApiField("cpa_reward_type")
		private String cpaRewardType;
		/**
		 * 选品库信息
		 */
		@ApiField("favorites_info")
		private FavoritesInfo favoritesInfo;
		/**
		 * 是否是热门商品，0不是，1是
		 */
		@ApiField("hot_flag")
		private String hotFlag;
		/**
		 * 是否品牌快抢，0不是，1是
		 */
		@ApiField("is_brand_flash_sale")
		private String isBrandFlashSale;
		/**
		 * 商品信息-宝贝描述（推荐理由,不一定有）
		 */
		@ApiField("item_description")
		private String itemDescription;
		/**
		 * 商品信息-宝贝id
		 */
		@ApiField("item_id")
		private String itemId;
		/**
		 * 拼团专用-拼团几人团
		 */
		@ApiField("jdd_num")
		private Long jddNum;
		/**
		 * 拼团专用-拼团拼成价，单位元
		 */
		@ApiField("jdd_price")
		private String jddPrice;
		/**
		 * 聚划算商品价格卖点描述
		 */
		@ApiField("jhs_price_usp_list")
		private String jhsPriceUspList;
		/**
		 * 聚划算信息-聚淘结束时间
		 */
		@ApiField("ju_online_end_time")
		private String juOnlineEndTime;
		/**
		 * 聚划算信息-聚淘开始时间
		 */
		@ApiField("ju_online_start_time")
		private String juOnlineStartTime;
		/**
		 * 聚划算满减  -结束时间（毫秒）
		 */
		@ApiField("ju_play_end_time")
		private Long juPlayEndTime;
		/**
		 * 聚划算满减  -开始时间（毫秒）
		 */
		@ApiField("ju_play_start_time")
		private Long juPlayStartTime;
		/**
		 * 聚划算信息-商品预热开始时间（毫秒）
		 */
		@ApiField("ju_pre_show_end_time")
		private String juPreShowEndTime;
		/**
		 * 聚划算信息-商品预热结束时间（毫秒）
		 */
		@ApiField("ju_pre_show_start_time")
		private String juPreShowStartTime;
		/**
		 * 跨店满减信息
		 */
		@ApiField("kuadian_promotion_info")
		private String kuadianPromotionInfo;
		/**
		 * 商品信息-一级类目ID
		 */
		@ApiField("level_one_category_id")
		private Long levelOneCategoryId;
		/**
		 * 商品信息-一级类目名称
		 */
		@ApiField("level_one_category_name")
		private String levelOneCategoryName;
		/**
		 * 锁住的佣金率
		 */
		@ApiField("lock_rate")
		private String lockRate;
		/**
		 * 锁佣结束时间
		 */
		@ApiField("lock_rate_end_time")
		private Long lockRateEndTime;
		/**
		 * 锁佣开始时间
		 */
		@ApiField("lock_rate_start_time")
		private Long lockRateStartTime;
		/**
		 * 猫超买返卡信息
		 */
		@ApiField("maifan_promotion")
		private MaifanPromotionDTO maifanPromotion;
		/**
		 * 猫超玩法信息-折扣条件，价格百分数存储，件数按数量存储。可以有多个折扣条件，与折扣字段对应，','分割
		 */
		@ApiField("maochao_play_conditions")
		private String maochaoPlayConditions;
		/**
		 * 猫超玩法信息-玩法类型，2:折扣(满n件折扣),5:减钱(满n元减m元)
		 */
		@ApiField("maochao_play_discount_type")
		private String maochaoPlayDiscountType;
		/**
		 * 猫超玩法信息-折扣，折扣按照百分数存储，其余按照单位分存储。可以有多个折扣，','分割
		 */
		@ApiField("maochao_play_discounts")
		private String maochaoPlayDiscounts;
		/**
		 * 猫超玩法信息-活动结束时间，精确到毫秒
		 */
		@ApiField("maochao_play_end_time")
		private String maochaoPlayEndTime;
		/**
		 * 猫超玩法信息-当前是否包邮，1:是，0:否
		 */
		@ApiField("maochao_play_free_post_fee")
		private String maochaoPlayFreePostFee;
		/**
		 * 猫超玩法信息-活动开始时间，精确到毫秒
		 */
		@ApiField("maochao_play_start_time")
		private String maochaoPlayStartTime;
		/**
		 * 多件券单品件数
		 */
		@ApiField("multi_coupon_item_count")
		private String multiCouponItemCount;
		/**
		 * 多件券优惠比例
		 */
		@ApiField("multi_coupon_zk_rate")
		private String multiCouponZkRate;
		/**
		 * 商品信息-新人价
		 */
		@ApiField("new_user_price")
		private String newUserPrice;
		/**
		 * 店铺信息-卖家昵称
		 */
		@ApiField("nick")
		private String nick;
		/**
		 * 拼团专用-拼团结束时间
		 */
		@ApiField("oetime")
		private String oetime;
		/**
		 * 拼团专用-拼团一人价（原价)，单位元
		 */
		@ApiField("orig_price")
		private String origPrice;
		/**
		 * 拼团专用-拼团开始时间
		 */
		@ApiField("ostime")
		private String ostime;
		/**
		 * 商品信息-商品主图
		 */
		@ApiField("pict_url")
		private String pictUrl;
		/**
		 * 1聚划算满减：满N件减X元，满N件X折，满N件X元）  2天猫限时抢：前N分钟每件X元，前N分钟满N件每件X元，前N件每件X元）
		 */
		@ApiField("play_info")
		private String playInfo;
		/**
		 * 预售商品-定金（元）
		 */
		@ApiField("presale_deposit")
		private String presaleDeposit;
		/**
		 * 预售商品-优惠信息
		 */
		@ApiField("presale_discount_fee_text")
		private String presaleDiscountFeeText;
		/**
		 * 预售商品-付定金结束时间（毫秒）
		 */
		@ApiField("presale_end_time")
		private Long presaleEndTime;
		/**
		 * 预售商品-付定金开始时间（毫秒）
		 */
		@ApiField("presale_start_time")
		private Long presaleStartTime;
		/**
		 * 预售商品-付尾款结束时间（毫秒）
		 */
		@ApiField("presale_tail_end_time")
		private Long presaleTailEndTime;
		/**
		 * 预售商品-付尾款开始时间（毫秒）
		 */
		@ApiField("presale_tail_start_time")
		private Long presaleTailStartTime;
		/**
		 * 多件券件单价
		 */
		@ApiField("price_after_multi_coupon")
		private String priceAfterMultiCoupon;
		/**
		 * 满减满折优惠（满2件打5折中值为5；满300减20中值为20）
		 */
		@ApiField("promotion_condition")
		private String promotionCondition;
		/**
		 * 满减满折门槛（满2件打5折中值为2；满300减20中值为300）
		 */
		@ApiField("promotion_discount")
		private String promotionDiscount;
		/**
		 * 满减满折信息
		 */
		@ApiField("promotion_info")
		private String promotionInfo;
		/**
		 * 满减满折的类型（1. 满减 2. 满折）
		 */
		@ApiField("promotion_type")
		private String promotionType;
		/**
		 * 商品信息-一口价
		 */
		@ApiField("reserve_price")
		private String reservePrice;
		/**
		 * 活动价
		 */
		@ApiField("sale_price")
		private String salePrice;
		/**
		 * 拼团专用-拼团已售数量
		 */
		@ApiField("sell_num")
		private Long sellNum;
		/**
		 * 店铺信息-卖家id
		 */
		@ApiField("seller_id")
		private Long sellerId;
		/**
		 * 店铺信息-店铺名称
		 */
		@ApiField("shop_title")
		private String shopTitle;
		/**
		 * 商品信息-商品短标题
		 */
		@ApiField("short_title")
		private String shortTitle;
		/**
		 * 商品信息-商品小图列表
		 */
		@ApiListField("small_images")
		@ApiField("string")
		private List<String> smallImages;
		/**
		 * 定向计划集合
		 */
		@ApiListField("sp_campaign_list")
		@ApiField("sp_campaign")
		private List<SpCampaign> spCampaignList;
		/**
		 * 拼团专用-拼团剩余库存
		 */
		@ApiField("stock")
		private Long stock;
		/**
		 * 商品子标题
		 */
		@ApiField("sub_title")
		private String subTitle;
		/**
		 * 是否品牌精选，0不是，1是
		 */
		@ApiField("superior_brand")
		private String superiorBrand;
		/**
		 * 商品信息-商品标题
		 */
		@ApiField("title")
		private String title;
		/**
		 * 天猫限时抢可售  -结束时间（毫秒）
		 */
		@ApiField("tmall_play_activity_end_time")
		private Long tmallPlayActivityEndTime;
		/**
		 * 营销-天猫营销玩法
		 */
		@ApiField("tmall_play_activity_info")
		private String tmallPlayActivityInfo;
		/**
		 * 天猫限时抢可售  -开始时间（毫秒）
		 */
		@ApiField("tmall_play_activity_start_time")
		private Long tmallPlayActivityStartTime;
		/**
		 * 前N件佣金信息-前N件佣金生效或预热时透出以下字段
		 */
		@ApiField("topn_info")
		private TopNInfoDTO topnInfo;
		/**
		 * 拼团专用-拼团库存数量
		 */
		@ApiField("total_stock")
		private Long totalStock;
		/**
		 * 淘抢购商品专用-结束时间
		 */
		@ApiField("tqg_online_end_time")
		private String tqgOnlineEndTime;
		/**
		 * 淘抢购商品专用-开团时间
		 */
		@ApiField("tqg_online_start_time")
		private String tqgOnlineStartTime;
		/**
		 * 淘抢购商品专用-已抢购数量
		 */
		@ApiField("tqg_sold_count")
		private Long tqgSoldCount;
		/**
		 * 淘抢购商品专用-总库存
		 */
		@ApiField("tqg_total_count")
		private Long tqgTotalCount;
		/**
		 * 商品入驻淘特后产生的所有销量量级，不特指某段具体时间
		 */
		@ApiField("tt_sold_count")
		private String ttSoldCount;
		/**
		 * 店铺信息-卖家类型，0表示淘宝，1表示天猫，3表示特价版
		 */
		@ApiField("user_type")
		private Long userType;
		/**
		 * 商品信息-预售数量
		 */
		@ApiField("uv_sum_pre_sale")
		private Long uvSumPreSale;
		/**
		 * 商品信息-30天销量
		 */
		@ApiField("volume")
		private Long volume;
		/**
		 * 商品信息-商品白底图
		 */
		@ApiField("white_image")
		private String whiteImage;
		/**
		 * 商品信息-商品关联词
		 */
		@ApiListField("word_list")
		@ApiField("word_map_data")
		private List<WordMapData> wordList;
		/**
		 * 物料块id(测试中请勿使用)
		 */
		@ApiField("x_id")
		private String xId;
		/**
		 * 预售有礼-推广链接
		 */
		@ApiField("ysyl_click_url")
		private String ysylClickUrl;
		/**
		 * 预售有礼-佣金比例（ 预售有礼活动享受的推广佣金比例，注：推广该活动有特殊分成规则，请详见：https:tbk.bbs.taobao.comdetail.html?appId=45301&postId=9334376 ）
		 */
		@ApiField("ysyl_commission_rate")
		private String ysylCommissionRate;
		/**
		 * 预售有礼-预估淘礼金（元）
		 */
		@ApiField("ysyl_tlj_face")
		private String ysylTljFace;
		/**
		 * 预售有礼-淘礼金发放时间
		 */
		@ApiField("ysyl_tlj_send_time")
		private String ysylTljSendTime;
		/**
		 * 预售有礼-淘礼金使用结束时间
		 */
		@ApiField("ysyl_tlj_use_end_time")
		private String ysylTljUseEndTime;
		/**
		 * 预售有礼-淘礼金使用开始时间
		 */
		@ApiField("ysyl_tlj_use_start_time")
		private String ysylTljUseStartTime;
		/**
		 * 折扣价（元） 若属于预售商品，付定金时间内，折扣价=预售价
		 */
		@ApiField("zk_final_price")
		private String zkFinalPrice;
	

	public String getActivityId() {
			return this.activityId;
		}
		public void setActivityId(String activityId) {
			this.activityId = activityId;
		}
		public BybtInfoDTO getBybtInfo() {
			return this.bybtInfo;
		}
		public void setBybtInfo(BybtInfoDTO bybtInfo) {
			this.bybtInfo = bybtInfo;
		}
		public Long getCategoryId() {
			return this.categoryId;
		}
		public void setCategoryId(Long categoryId) {
			this.categoryId = categoryId;
		}
		public String getCategoryName() {
			return this.categoryName;
		}
		public void setCategoryName(String categoryName) {
			this.categoryName = categoryName;
		}
		public String getClickUrl() {
			return this.clickUrl;
		}
		public void setClickUrl(String clickUrl) {
			this.clickUrl = clickUrl;
		}
		public String getCommissionRate() {
			return this.commissionRate;
		}
		public void setCommissionRate(String commissionRate) {
			this.commissionRate = commissionRate;
		}
		public Long getCouponAmount() {
			return this.couponAmount;
		}
		public void setCouponAmount(Long couponAmount) {
			this.couponAmount = couponAmount;
		}
		public String getCouponClickUrl() {
			return this.couponClickUrl;
		}
		public void setCouponClickUrl(String couponClickUrl) {
			this.couponClickUrl = couponClickUrl;
		}
		public String getCouponEndTime() {
			return this.couponEndTime;
		}
		public void setCouponEndTime(String couponEndTime) {
			this.couponEndTime = couponEndTime;
		}
		public String getCouponInfo() {
			return this.couponInfo;
		}
		public void setCouponInfo(String couponInfo) {
			this.couponInfo = couponInfo;
		}
		public Long getCouponRemainCount() {
			return this.couponRemainCount;
		}
		public void setCouponRemainCount(Long couponRemainCount) {
			this.couponRemainCount = couponRemainCount;
		}
		public String getCouponShareUrl() {
			return this.couponShareUrl;
		}
		public void setCouponShareUrl(String couponShareUrl) {
			this.couponShareUrl = couponShareUrl;
		}
		public String getCouponStartFee() {
			return this.couponStartFee;
		}
		public void setCouponStartFee(String couponStartFee) {
			this.couponStartFee = couponStartFee;
		}
		public String getCouponStartTime() {
			return this.couponStartTime;
		}
		public void setCouponStartTime(String couponStartTime) {
			this.couponStartTime = couponStartTime;
		}
		public Long getCouponTotalCount() {
			return this.couponTotalCount;
		}
		public void setCouponTotalCount(Long couponTotalCount) {
			this.couponTotalCount = couponTotalCount;
		}
		public String getCpaRewardAmount() {
			return this.cpaRewardAmount;
		}
		public void setCpaRewardAmount(String cpaRewardAmount) {
			this.cpaRewardAmount = cpaRewardAmount;
		}
		public String getCpaRewardType() {
			return this.cpaRewardType;
		}
		public void setCpaRewardType(String cpaRewardType) {
			this.cpaRewardType = cpaRewardType;
		}
		public FavoritesInfo getFavoritesInfo() {
			return this.favoritesInfo;
		}
		public void setFavoritesInfo(FavoritesInfo favoritesInfo) {
			this.favoritesInfo = favoritesInfo;
		}
		public String getHotFlag() {
			return this.hotFlag;
		}
		public void setHotFlag(String hotFlag) {
			this.hotFlag = hotFlag;
		}
		public String getIsBrandFlashSale() {
			return this.isBrandFlashSale;
		}
		public void setIsBrandFlashSale(String isBrandFlashSale) {
			this.isBrandFlashSale = isBrandFlashSale;
		}
		public String getItemDescription() {
			return this.itemDescription;
		}
		public void setItemDescription(String itemDescription) {
			this.itemDescription = itemDescription;
		}
		public String getItemId() {
			return this.itemId;
		}
		public void setItemId(String itemId) {
			this.itemId = itemId;
		}
		public Long getJddNum() {
			return this.jddNum;
		}
		public void setJddNum(Long jddNum) {
			this.jddNum = jddNum;
		}
		public String getJddPrice() {
			return this.jddPrice;
		}
		public void setJddPrice(String jddPrice) {
			this.jddPrice = jddPrice;
		}
		public String getJhsPriceUspList() {
			return this.jhsPriceUspList;
		}
		public void setJhsPriceUspList(String jhsPriceUspList) {
			this.jhsPriceUspList = jhsPriceUspList;
		}
		public String getJuOnlineEndTime() {
			return this.juOnlineEndTime;
		}
		public void setJuOnlineEndTime(String juOnlineEndTime) {
			this.juOnlineEndTime = juOnlineEndTime;
		}
		public String getJuOnlineStartTime() {
			return this.juOnlineStartTime;
		}
		public void setJuOnlineStartTime(String juOnlineStartTime) {
			this.juOnlineStartTime = juOnlineStartTime;
		}
		public Long getJuPlayEndTime() {
			return this.juPlayEndTime;
		}
		public void setJuPlayEndTime(Long juPlayEndTime) {
			this.juPlayEndTime = juPlayEndTime;
		}
		public Long getJuPlayStartTime() {
			return this.juPlayStartTime;
		}
		public void setJuPlayStartTime(Long juPlayStartTime) {
			this.juPlayStartTime = juPlayStartTime;
		}
		public String getJuPreShowEndTime() {
			return this.juPreShowEndTime;
		}
		public void setJuPreShowEndTime(String juPreShowEndTime) {
			this.juPreShowEndTime = juPreShowEndTime;
		}
		public String getJuPreShowStartTime() {
			return this.juPreShowStartTime;
		}
		public void setJuPreShowStartTime(String juPreShowStartTime) {
			this.juPreShowStartTime = juPreShowStartTime;
		}
		public String getKuadianPromotionInfo() {
			return this.kuadianPromotionInfo;
		}
		public void setKuadianPromotionInfo(String kuadianPromotionInfo) {
			this.kuadianPromotionInfo = kuadianPromotionInfo;
		}
		public Long getLevelOneCategoryId() {
			return this.levelOneCategoryId;
		}
		public void setLevelOneCategoryId(Long levelOneCategoryId) {
			this.levelOneCategoryId = levelOneCategoryId;
		}
		public String getLevelOneCategoryName() {
			return this.levelOneCategoryName;
		}
		public void setLevelOneCategoryName(String levelOneCategoryName) {
			this.levelOneCategoryName = levelOneCategoryName;
		}
		public String getLockRate() {
			return this.lockRate;
		}
		public void setLockRate(String lockRate) {
			this.lockRate = lockRate;
		}
		public Long getLockRateEndTime() {
			return this.lockRateEndTime;
		}
		public void setLockRateEndTime(Long lockRateEndTime) {
			this.lockRateEndTime = lockRateEndTime;
		}
		public Long getLockRateStartTime() {
			return this.lockRateStartTime;
		}
		public void setLockRateStartTime(Long lockRateStartTime) {
			this.lockRateStartTime = lockRateStartTime;
		}
		public MaifanPromotionDTO getMaifanPromotion() {
			return this.maifanPromotion;
		}
		public void setMaifanPromotion(MaifanPromotionDTO maifanPromotion) {
			this.maifanPromotion = maifanPromotion;
		}
		public String getMaochaoPlayConditions() {
			return this.maochaoPlayConditions;
		}
		public void setMaochaoPlayConditions(String maochaoPlayConditions) {
			this.maochaoPlayConditions = maochaoPlayConditions;
		}
		public String getMaochaoPlayDiscountType() {
			return this.maochaoPlayDiscountType;
		}
		public void setMaochaoPlayDiscountType(String maochaoPlayDiscountType) {
			this.maochaoPlayDiscountType = maochaoPlayDiscountType;
		}
		public String getMaochaoPlayDiscounts() {
			return this.maochaoPlayDiscounts;
		}
		public void setMaochaoPlayDiscounts(String maochaoPlayDiscounts) {
			this.maochaoPlayDiscounts = maochaoPlayDiscounts;
		}
		public String getMaochaoPlayEndTime() {
			return this.maochaoPlayEndTime;
		}
		public void setMaochaoPlayEndTime(String maochaoPlayEndTime) {
			this.maochaoPlayEndTime = maochaoPlayEndTime;
		}
		public String getMaochaoPlayFreePostFee() {
			return this.maochaoPlayFreePostFee;
		}
		public void setMaochaoPlayFreePostFee(String maochaoPlayFreePostFee) {
			this.maochaoPlayFreePostFee = maochaoPlayFreePostFee;
		}
		public String getMaochaoPlayStartTime() {
			return this.maochaoPlayStartTime;
		}
		public void setMaochaoPlayStartTime(String maochaoPlayStartTime) {
			this.maochaoPlayStartTime = maochaoPlayStartTime;
		}
		public String getMultiCouponItemCount() {
			return this.multiCouponItemCount;
		}
		public void setMultiCouponItemCount(String multiCouponItemCount) {
			this.multiCouponItemCount = multiCouponItemCount;
		}
		public String getMultiCouponZkRate() {
			return this.multiCouponZkRate;
		}
		public void setMultiCouponZkRate(String multiCouponZkRate) {
			this.multiCouponZkRate = multiCouponZkRate;
		}
		public String getNewUserPrice() {
			return this.newUserPrice;
		}
		public void setNewUserPrice(String newUserPrice) {
			this.newUserPrice = newUserPrice;
		}
		public String getNick() {
			return this.nick;
		}
		public void setNick(String nick) {
			this.nick = nick;
		}
		public String getOetime() {
			return this.oetime;
		}
		public void setOetime(String oetime) {
			this.oetime = oetime;
		}
		public String getOrigPrice() {
			return this.origPrice;
		}
		public void setOrigPrice(String origPrice) {
			this.origPrice = origPrice;
		}
		public String getOstime() {
			return this.ostime;
		}
		public void setOstime(String ostime) {
			this.ostime = ostime;
		}
		public String getPictUrl() {
			return this.pictUrl;
		}
		public void setPictUrl(String pictUrl) {
			this.pictUrl = pictUrl;
		}
		public String getPlayInfo() {
			return this.playInfo;
		}
		public void setPlayInfo(String playInfo) {
			this.playInfo = playInfo;
		}
		public String getPresaleDeposit() {
			return this.presaleDeposit;
		}
		public void setPresaleDeposit(String presaleDeposit) {
			this.presaleDeposit = presaleDeposit;
		}
		public String getPresaleDiscountFeeText() {
			return this.presaleDiscountFeeText;
		}
		public void setPresaleDiscountFeeText(String presaleDiscountFeeText) {
			this.presaleDiscountFeeText = presaleDiscountFeeText;
		}
		public Long getPresaleEndTime() {
			return this.presaleEndTime;
		}
		public void setPresaleEndTime(Long presaleEndTime) {
			this.presaleEndTime = presaleEndTime;
		}
		public Long getPresaleStartTime() {
			return this.presaleStartTime;
		}
		public void setPresaleStartTime(Long presaleStartTime) {
			this.presaleStartTime = presaleStartTime;
		}
		public Long getPresaleTailEndTime() {
			return this.presaleTailEndTime;
		}
		public void setPresaleTailEndTime(Long presaleTailEndTime) {
			this.presaleTailEndTime = presaleTailEndTime;
		}
		public Long getPresaleTailStartTime() {
			return this.presaleTailStartTime;
		}
		public void setPresaleTailStartTime(Long presaleTailStartTime) {
			this.presaleTailStartTime = presaleTailStartTime;
		}
		public String getPriceAfterMultiCoupon() {
			return this.priceAfterMultiCoupon;
		}
		public void setPriceAfterMultiCoupon(String priceAfterMultiCoupon) {
			this.priceAfterMultiCoupon = priceAfterMultiCoupon;
		}
		public String getPromotionCondition() {
			return this.promotionCondition;
		}
		public void setPromotionCondition(String promotionCondition) {
			this.promotionCondition = promotionCondition;
		}
		public String getPromotionDiscount() {
			return this.promotionDiscount;
		}
		public void setPromotionDiscount(String promotionDiscount) {
			this.promotionDiscount = promotionDiscount;
		}
		public String getPromotionInfo() {
			return this.promotionInfo;
		}
		public void setPromotionInfo(String promotionInfo) {
			this.promotionInfo = promotionInfo;
		}
		public String getPromotionType() {
			return this.promotionType;
		}
		public void setPromotionType(String promotionType) {
			this.promotionType = promotionType;
		}
		public String getReservePrice() {
			return this.reservePrice;
		}
		public void setReservePrice(String reservePrice) {
			this.reservePrice = reservePrice;
		}
		public String getSalePrice() {
			return this.salePrice;
		}
		public void setSalePrice(String salePrice) {
			this.salePrice = salePrice;
		}
		public Long getSellNum() {
			return this.sellNum;
		}
		public void setSellNum(Long sellNum) {
			this.sellNum = sellNum;
		}
		public Long getSellerId() {
			return this.sellerId;
		}
		public void setSellerId(Long sellerId) {
			this.sellerId = sellerId;
		}
		public String getShopTitle() {
			return this.shopTitle;
		}
		public void setShopTitle(String shopTitle) {
			this.shopTitle = shopTitle;
		}
		public String getShortTitle() {
			return this.shortTitle;
		}
		public void setShortTitle(String shortTitle) {
			this.shortTitle = shortTitle;
		}
		public List<String> getSmallImages() {
			return this.smallImages;
		}
		public void setSmallImages(List<String> smallImages) {
			this.smallImages = smallImages;
		}
		public List<SpCampaign> getSpCampaignList() {
			return this.spCampaignList;
		}
		public void setSpCampaignList(List<SpCampaign> spCampaignList) {
			this.spCampaignList = spCampaignList;
		}
		public Long getStock() {
			return this.stock;
		}
		public void setStock(Long stock) {
			this.stock = stock;
		}
		public String getSubTitle() {
			return this.subTitle;
		}
		public void setSubTitle(String subTitle) {
			this.subTitle = subTitle;
		}
		public String getSuperiorBrand() {
			return this.superiorBrand;
		}
		public void setSuperiorBrand(String superiorBrand) {
			this.superiorBrand = superiorBrand;
		}
		public String getTitle() {
			return this.title;
		}
		public void setTitle(String title) {
			this.title = title;
		}
		public Long getTmallPlayActivityEndTime() {
			return this.tmallPlayActivityEndTime;
		}
		public void setTmallPlayActivityEndTime(Long tmallPlayActivityEndTime) {
			this.tmallPlayActivityEndTime = tmallPlayActivityEndTime;
		}
		public String getTmallPlayActivityInfo() {
			return this.tmallPlayActivityInfo;
		}
		public void setTmallPlayActivityInfo(String tmallPlayActivityInfo) {
			this.tmallPlayActivityInfo = tmallPlayActivityInfo;
		}
		public Long getTmallPlayActivityStartTime() {
			return this.tmallPlayActivityStartTime;
		}
		public void setTmallPlayActivityStartTime(Long tmallPlayActivityStartTime) {
			this.tmallPlayActivityStartTime = tmallPlayActivityStartTime;
		}
		public TopNInfoDTO getTopnInfo() {
			return this.topnInfo;
		}
		public void setTopnInfo(TopNInfoDTO topnInfo) {
			this.topnInfo = topnInfo;
		}
		public Long getTotalStock() {
			return this.totalStock;
		}
		public void setTotalStock(Long totalStock) {
			this.totalStock = totalStock;
		}
		public String getTqgOnlineEndTime() {
			return this.tqgOnlineEndTime;
		}
		public void setTqgOnlineEndTime(String tqgOnlineEndTime) {
			this.tqgOnlineEndTime = tqgOnlineEndTime;
		}
		public String getTqgOnlineStartTime() {
			return this.tqgOnlineStartTime;
		}
		public void setTqgOnlineStartTime(String tqgOnlineStartTime) {
			this.tqgOnlineStartTime = tqgOnlineStartTime;
		}
		public Long getTqgSoldCount() {
			return this.tqgSoldCount;
		}
		public void setTqgSoldCount(Long tqgSoldCount) {
			this.tqgSoldCount = tqgSoldCount;
		}
		public Long getTqgTotalCount() {
			return this.tqgTotalCount;
		}
		public void setTqgTotalCount(Long tqgTotalCount) {
			this.tqgTotalCount = tqgTotalCount;
		}
		public String getTtSoldCount() {
			return this.ttSoldCount;
		}
		public void setTtSoldCount(String ttSoldCount) {
			this.ttSoldCount = ttSoldCount;
		}
		public Long getUserType() {
			return this.userType;
		}
		public void setUserType(Long userType) {
			this.userType = userType;
		}
		public Long getUvSumPreSale() {
			return this.uvSumPreSale;
		}
		public void setUvSumPreSale(Long uvSumPreSale) {
			this.uvSumPreSale = uvSumPreSale;
		}
		public Long getVolume() {
			return this.volume;
		}
		public void setVolume(Long volume) {
			this.volume = volume;
		}
		public String getWhiteImage() {
			return this.whiteImage;
		}
		public void setWhiteImage(String whiteImage) {
			this.whiteImage = whiteImage;
		}
		public List<WordMapData> getWordList() {
			return this.wordList;
		}
		public void setWordList(List<WordMapData> wordList) {
			this.wordList = wordList;
		}
		public String getxId() {
			return this.xId;
		}
		public void setxId(String xId) {
			this.xId = xId;
		}
		public String getYsylClickUrl() {
			return this.ysylClickUrl;
		}
		public void setYsylClickUrl(String ysylClickUrl) {
			this.ysylClickUrl = ysylClickUrl;
		}
		public String getYsylCommissionRate() {
			return this.ysylCommissionRate;
		}
		public void setYsylCommissionRate(String ysylCommissionRate) {
			this.ysylCommissionRate = ysylCommissionRate;
		}
		public String getYsylTljFace() {
			return this.ysylTljFace;
		}
		public void setYsylTljFace(String ysylTljFace) {
			this.ysylTljFace = ysylTljFace;
		}
		public String getYsylTljSendTime() {
			return this.ysylTljSendTime;
		}
		public void setYsylTljSendTime(String ysylTljSendTime) {
			this.ysylTljSendTime = ysylTljSendTime;
		}
		public String getYsylTljUseEndTime() {
			return this.ysylTljUseEndTime;
		}
		public void setYsylTljUseEndTime(String ysylTljUseEndTime) {
			this.ysylTljUseEndTime = ysylTljUseEndTime;
		}
		public String getYsylTljUseStartTime() {
			return this.ysylTljUseStartTime;
		}
		public void setYsylTljUseStartTime(String ysylTljUseStartTime) {
			this.ysylTljUseStartTime = ysylTljUseStartTime;
		}
		public String getZkFinalPrice() {
			return this.zkFinalPrice;
		}
		public void setZkFinalPrice(String zkFinalPrice) {
			this.zkFinalPrice = zkFinalPrice;
		}

}



}
