package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.tbk.dg.optimus.promotion response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TbkDgOptimusPromotionResponse extends TaobaoResponse {

	private static final long serialVersionUID = 7379646326261439764L;

	/** 
	 * resultList
	 */
	@ApiListField("result_list")
	@ApiField("map_data")
	private List<MapData> resultList;


	public void setResultList(List<MapData> resultList) {
		this.resultList = resultList;
	}
	public List<MapData> getResultList( ) {
		return this.resultList;
	}
	
	/**
 * 权益信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PromotionList extends TaobaoObject {

	private static final long serialVersionUID = 6429216299695214955L;

	/**
		 * 权益起用门槛，满X元可用，券场景为满元，精确到分，如满100元可用
		 */
		@ApiField("entry_condition")
		private String entryCondition;
		/**
		 * 权益面额，券场景为减钱，精确到分
		 */
		@ApiField("entry_discount")
		private String entryDiscount;
		/**
		 * 权益结束时间，精确到毫秒时间戳
		 */
		@ApiField("entry_used_end_time")
		private String entryUsedEndTime;
		/**
		 * 权益开始时间，精确到毫秒时间戳
		 */
		@ApiField("entry_used_start_time")
		private String entryUsedStartTime;
	

	public String getEntryCondition() {
			return this.entryCondition;
		}
		public void setEntryCondition(String entryCondition) {
			this.entryCondition = entryCondition;
		}
		public String getEntryDiscount() {
			return this.entryDiscount;
		}
		public void setEntryDiscount(String entryDiscount) {
			this.entryDiscount = entryDiscount;
		}
		public String getEntryUsedEndTime() {
			return this.entryUsedEndTime;
		}
		public void setEntryUsedEndTime(String entryUsedEndTime) {
			this.entryUsedEndTime = entryUsedEndTime;
		}
		public String getEntryUsedStartTime() {
			return this.entryUsedStartTime;
		}
		public void setEntryUsedStartTime(String entryUsedStartTime) {
			this.entryUsedStartTime = entryUsedStartTime;
		}

}

	/**
 * 权益推荐商品
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class RecommendItemList extends TaobaoObject {

	private static final long serialVersionUID = 6814935844718278816L;

	/**
		 * 权益推荐商品id
		 */
		@ApiField("item_id")
		private Long itemId;
		/**
		 * 商品链接
		 */
		@ApiField("url")
		private String url;
	

	public Long getItemId() {
			return this.itemId;
		}
		public void setItemId(Long itemId) {
			this.itemId = itemId;
		}
		public String getUrl() {
			return this.url;
		}
		public void setUrl(String url) {
			this.url = url;
		}

}

	/**
 * 有价券信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Youjiacouponinfo extends TaobaoObject {

	private static final long serialVersionUID = 3394147139795535393L;

	/**
		 * 有价券商品id
		 */
		@ApiField("item_id")
		private String itemId;
		/**
		 * 商品链接
		 */
		@ApiField("url")
		private String url;
	

	public String getItemId() {
			return this.itemId;
		}
		public void setItemId(String itemId) {
			this.itemId = itemId;
		}
		public String getUrl() {
			return this.url;
		}
		public void setUrl(String url) {
			this.url = url;
		}

}

	/**
 * 权益扩展信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PromotionExtend extends TaobaoObject {

	private static final long serialVersionUID = 2326113356574666172L;

	/**
		 * 权益链接
		 */
		@ApiField("promotion_url")
		private String promotionUrl;
		/**
		 * 权益推荐商品
		 */
		@ApiListField("recommend_item_list")
		@ApiField("recommend_item_list")
		private List<RecommendItemList> recommendItemList;
		/**
		 * 有价券信息
		 */
		@ApiField("youjia_coupon_info")
		private Youjiacouponinfo youjiaCouponInfo;
	

	public String getPromotionUrl() {
			return this.promotionUrl;
		}
		public void setPromotionUrl(String promotionUrl) {
			this.promotionUrl = promotionUrl;
		}
		public List<RecommendItemList> getRecommendItemList() {
			return this.recommendItemList;
		}
		public void setRecommendItemList(List<RecommendItemList> recommendItemList) {
			this.recommendItemList = recommendItemList;
		}
		public Youjiacouponinfo getYoujiaCouponInfo() {
			return this.youjiaCouponInfo;
		}
		public void setYoujiaCouponInfo(Youjiacouponinfo youjiaCouponInfo) {
			this.youjiaCouponInfo = youjiaCouponInfo;
		}

}

	/**
 * resultList
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class MapData extends TaobaoObject {

	private static final long serialVersionUID = 8194874539486454975L;

	/**
		 * 优惠门槛类型： 1 满元 2 满件
		 */
		@ApiField("condition_type")
		private String conditionType;
		/**
		 * 优惠类型： 1 减钱 2 打折
		 */
		@ApiField("discount_type")
		private String discountType;
		/**
		 * 权益信息展示结束时间，精确到毫秒时间戳
		 */
		@ApiField("display_end_time")
		private String displayEndTime;
		/**
		 * 权益信息展示开始时间，精确到毫秒时间戳
		 */
		@ApiField("display_start_time")
		private String displayStartTime;
		/**
		 * 店铺信息-卖家昵称
		 */
		@ApiField("nick")
		private String nick;
		/**
		 * 权益扩展信息
		 */
		@ApiField("promotion_extend")
		private PromotionExtend promotionExtend;
		/**
		 * 权益信息
		 */
		@ApiListField("promotion_list")
		@ApiField("promotion_list")
		private List<PromotionList> promotionList;
		/**
		 * 权益类型。1 有价券（需要购买的店铺券或单品券） 2 公开券（直接领取的店铺券或单品券） 3 妈妈券（妈妈渠道领取的店铺券或单品券） 4.品类券 （跨店可用券，可与1，2，3叠加）
		 */
		@ApiField("promotion_type")
		private String promotionType;
		/**
		 * 权益信息-剩余库存（权益剩余库存量）
		 */
		@ApiField("remain_count")
		private Long remainCount;
		/**
		 * 店铺信息-卖家ID
		 */
		@ApiField("seller_id")
		private String sellerId;
		/**
		 * 店铺信息-店铺logo
		 */
		@ApiField("shop_picture_url")
		private String shopPictureUrl;
		/**
		 * 店铺信息-店铺名称
		 */
		@ApiField("shop_title")
		private String shopTitle;
		/**
		 * 权益信息-总量（权益初始库存量）
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public String getConditionType() {
			return this.conditionType;
		}
		public void setConditionType(String conditionType) {
			this.conditionType = conditionType;
		}
		public String getDiscountType() {
			return this.discountType;
		}
		public void setDiscountType(String discountType) {
			this.discountType = discountType;
		}
		public String getDisplayEndTime() {
			return this.displayEndTime;
		}
		public void setDisplayEndTime(String displayEndTime) {
			this.displayEndTime = displayEndTime;
		}
		public String getDisplayStartTime() {
			return this.displayStartTime;
		}
		public void setDisplayStartTime(String displayStartTime) {
			this.displayStartTime = displayStartTime;
		}
		public String getNick() {
			return this.nick;
		}
		public void setNick(String nick) {
			this.nick = nick;
		}
		public PromotionExtend getPromotionExtend() {
			return this.promotionExtend;
		}
		public void setPromotionExtend(PromotionExtend promotionExtend) {
			this.promotionExtend = promotionExtend;
		}
		public List<PromotionList> getPromotionList() {
			return this.promotionList;
		}
		public void setPromotionList(List<PromotionList> promotionList) {
			this.promotionList = promotionList;
		}
		public String getPromotionType() {
			return this.promotionType;
		}
		public void setPromotionType(String promotionType) {
			this.promotionType = promotionType;
		}
		public Long getRemainCount() {
			return this.remainCount;
		}
		public void setRemainCount(Long remainCount) {
			this.remainCount = remainCount;
		}
		public String getSellerId() {
			return this.sellerId;
		}
		public void setSellerId(String sellerId) {
			this.sellerId = sellerId;
		}
		public String getShopPictureUrl() {
			return this.shopPictureUrl;
		}
		public void setShopPictureUrl(String shopPictureUrl) {
			this.shopPictureUrl = shopPictureUrl;
		}
		public String getShopTitle() {
			return this.shopTitle;
		}
		public void setShopTitle(String shopTitle) {
			this.shopTitle = shopTitle;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}



}
