package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.tbk.dg.punish.order.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TbkDgPunishOrderGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 3743891472285167851L;

	/** 
	 * 查询的对象
	 */
	@ApiField("result")
	private RpcResult result;


	public void setResult(RpcResult result) {
		this.result = result;
	}
	public RpcResult getResult( ) {
		return this.result;
	}
	
	/**
 * 处罚订单列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Result extends TaobaoObject {

	private static final long serialVersionUID = 5625813615841665562L;

	/**
		 * 处罚状态。0 冻结，1 解冻
		 */
		@ApiField("punish_status")
		private String punishStatus;
		/**
		 * 渠道关系id
		 */
		@ApiField("relation_id")
		private Long relationId;
		/**
		 * 结算月份
		 */
		@ApiField("settle_month")
		private Long settleMonth;
		/**
		 * 会员运营id（该字段不再支持）
		 */
		@ApiField("special_id")
		private Long specialId;
		/**
		 * 子订单号
		 */
		@ApiField("tb_trade_id")
		private Long tbTradeId;
		/**
		 * 父订单号（该字段不再支持）
		 */
		@ApiField("tb_trade_parent_id")
		private Long tbTradeParentId;
		/**
		 * pid里的adzoneid
		 */
		@ApiField("tk_adzone_id")
		private Long tkAdzoneId;
		/**
		 * pid里的pubid
		 */
		@ApiField("tk_pub_id")
		private String tkPubId;
		/**
		 * pid里的siteid
		 */
		@ApiField("tk_site_id")
		private Long tkSiteId;
		/**
		 * 淘客订单创建时间
		 */
		@ApiField("tk_trade_create_time")
		private String tkTradeCreateTime;
		/**
		 * 淘宝联盟unionid（该字段不再支持）
		 */
		@ApiField("union_id")
		private String unionId;
		/**
		 * 处罚类型，目前包括 1.店铺淘宝客 2.订单虚假交易
		 */
		@ApiField("violation_type")
		private String violationType;
	

	public String getPunishStatus() {
			return this.punishStatus;
		}
		public void setPunishStatus(String punishStatus) {
			this.punishStatus = punishStatus;
		}
		public Long getRelationId() {
			return this.relationId;
		}
		public void setRelationId(Long relationId) {
			this.relationId = relationId;
		}
		public Long getSettleMonth() {
			return this.settleMonth;
		}
		public void setSettleMonth(Long settleMonth) {
			this.settleMonth = settleMonth;
		}
		public Long getSpecialId() {
			return this.specialId;
		}
		public void setSpecialId(Long specialId) {
			this.specialId = specialId;
		}
		public Long getTbTradeId() {
			return this.tbTradeId;
		}
		public void setTbTradeId(Long tbTradeId) {
			this.tbTradeId = tbTradeId;
		}
		public Long getTbTradeParentId() {
			return this.tbTradeParentId;
		}
		public void setTbTradeParentId(Long tbTradeParentId) {
			this.tbTradeParentId = tbTradeParentId;
		}
		public Long getTkAdzoneId() {
			return this.tkAdzoneId;
		}
		public void setTkAdzoneId(Long tkAdzoneId) {
			this.tkAdzoneId = tkAdzoneId;
		}
		public String getTkPubId() {
			return this.tkPubId;
		}
		public void setTkPubId(String tkPubId) {
			this.tkPubId = tkPubId;
		}
		public Long getTkSiteId() {
			return this.tkSiteId;
		}
		public void setTkSiteId(Long tkSiteId) {
			this.tkSiteId = tkSiteId;
		}
		public String getTkTradeCreateTime() {
			return this.tkTradeCreateTime;
		}
		public void setTkTradeCreateTime(String tkTradeCreateTime) {
			this.tkTradeCreateTime = tkTradeCreateTime;
		}
		public String getUnionId() {
			return this.unionId;
		}
		public void setUnionId(String unionId) {
			this.unionId = unionId;
		}
		public String getViolationType() {
			return this.violationType;
		}
		public void setViolationType(String violationType) {
			this.violationType = violationType;
		}

}

	/**
 * 结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PageResult extends TaobaoObject {

	private static final long serialVersionUID = 4418169218348791381L;

	/**
		 * 翻页的pageno
		 */
		@ApiField("page_no")
		private Long pageNo;
		/**
		 * 翻页的pagesie
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 处罚订单列表
		 */
		@ApiListField("results")
		@ApiField("result")
		private List<Result> results;
		/**
		 * 一共能查询出来的结果总数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public Long getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(Long pageNo) {
			this.pageNo = pageNo;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public List<Result> getResults() {
			return this.results;
		}
		public void setResults(List<Result> results) {
			this.results = results;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}

	/**
 * 查询的对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class RpcResult extends TaobaoObject {

	private static final long serialVersionUID = 8847196442757671681L;

	/**
		 * 业务出错的状态码
		 */
		@ApiField("biz_error_code")
		private Long bizErrorCode;
		/**
		 * 业务出错的描述
		 */
		@ApiField("biz_error_desc")
		private String bizErrorDesc;
		/**
		 * 结果
		 */
		@ApiField("data")
		private PageResult data;
		/**
		 * 执行结果状态码
		 */
		@ApiField("result_code")
		private Long resultCode;
		/**
		 * 执行结果
		 */
		@ApiField("result_msg")
		private String resultMsg;
	

	public Long getBizErrorCode() {
			return this.bizErrorCode;
		}
		public void setBizErrorCode(Long bizErrorCode) {
			this.bizErrorCode = bizErrorCode;
		}
		public String getBizErrorDesc() {
			return this.bizErrorDesc;
		}
		public void setBizErrorDesc(String bizErrorDesc) {
			this.bizErrorDesc = bizErrorDesc;
		}
		public PageResult getData() {
			return this.data;
		}
		public void setData(PageResult data) {
			this.data = data;
		}
		public Long getResultCode() {
			return this.resultCode;
		}
		public void setResultCode(Long resultCode) {
			this.resultCode = resultCode;
		}
		public String getResultMsg() {
			return this.resultMsg;
		}
		public void setResultMsg(String resultMsg) {
			this.resultMsg = resultMsg;
		}

}



}
