package com.taobao.api.response;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.tbk.dg.vegas.tlj.report response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TbkDgVegasTljReportResponse extends TaobaoResponse {

	private static final long serialVersionUID = 2446259421558724376L;

	/** 
	 * 结果
	 */
	@ApiField("model")
	private InstanceDTO model;

	/** 
	 * msgCode
	 */
	@ApiField("msg_code")
	private String msgCode;

	/** 
	 * msgInfo
	 */
	@ApiField("msg_info")
	private String msgInfo;

	/** 
	 * 调用接口是否成功
	 */
	@ApiField("result_success")
	private Boolean resultSuccess;


	public void setModel(InstanceDTO model) {
		this.model = model;
	}
	public InstanceDTO getModel( ) {
		return this.model;
	}

	public void setMsgCode(String msgCode) {
		this.msgCode = msgCode;
	}
	public String getMsgCode( ) {
		return this.msgCode;
	}

	public void setMsgInfo(String msgInfo) {
		this.msgInfo = msgInfo;
	}
	public String getMsgInfo( ) {
		return this.msgInfo;
	}

	public void setResultSuccess(Boolean resultSuccess) {
		this.resultSuccess = resultSuccess;
	}
	public Boolean getResultSuccess( ) {
		return this.resultSuccess;
	}
	
	/**
 * extra
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Extra extends TaobaoObject {

	private static final long serialVersionUID = 2631536384416258328L;

	/**
		 * 引导付款金额，同一个红包，若因消费者付款使用后取消订单或退货退款，产生二次红包使用行为，引导付款笔数也会记录两单
		 */
		@ApiField("alipay_amt")
		private String alipayAmt;
		/**
		 * 引导付款笔数，同一个红包，若因消费者付款使用后取消订单或退货退款，产生二次红包使用行为，引导付款笔数也会记录两单
		 */
		@ApiField("alipay_num")
		private Long alipayNum;
		/**
		 * 结算佣金，确认收货，产生二次红包使用行为，会记录2次
		 */
		@ApiField("cm_settle_amt")
		private String cmSettleAmt;
		/**
		 * 领取率，领取淘礼金个数创建淘礼金个数
		 */
		@ApiField("get_rate")
		private String getRate;
		/**
		 * 付款佣金，下单付款，产生二次红包使用行为，会记录2次
		 */
		@ApiField("pre_pub_share_fee_for_disp")
		private String prePubShareFeeForDisp;
		/**
		 * 退款淘礼金个数，红包使用后，由于订单取消，退货退款等行为带来的淘礼金红包退回数量，退款红包数量单日内不重复计算，跨天重复计算
		 */
		@ApiField("refund_num")
		private Long refundNum;
		/**
		 * 退款淘礼金金额，红包使用后，由于订单取消，退货退款等行为行为带来的淘礼金红包退回数量 （退款红包若产生多次使用，退款红包金额会被多次计算，退款红包数量单日内不重复计算，跨天重复计算）
		 */
		@ApiField("refund_sum_amt")
		private String refundSumAmt;
		/**
		 * 未领取金额，过了领取有效期或者暂停后没有被领取的红包金额
		 */
		@ApiField("remaining_amt")
		private String remainingAmt;
		/**
		 * 未领取淘礼金个数，过了领取有效期或者暂停后没有被领取的红包个数
		 */
		@ApiField("remaining_num")
		private Long remainingNum;
		/**
		 * 使用淘礼金个数，同一个红包，若因消费者付款使用后取消订单或退货退款，产生二次红包使用行为，使用淘礼金个数一天内会去重，所以相当于不会重记
		 */
		@ApiField("use_num")
		private Long useNum;
		/**
		 * 使用率，使用淘礼金个数领取淘礼金个数
		 */
		@ApiField("use_rate")
		private String useRate;
		/**
		 * 使用淘礼金金额，若红包被重复使用（1)淘礼金红包被拆分，并且产生部分退款，会保留部分退款的订单淘礼金金额；若全部退款，会保留订单全部淘礼金金额），因此，已使用金额可能大于消费者实际使用金额（使用红包后，若产生红包退回后再次使用，已使用金额会被二次计算，已使用数量不会）
		 */
		@ApiField("use_sum_amt")
		private String useSumAmt;
		/**
		 * 领取淘礼金个数
		 */
		@ApiField("win_pv")
		private Long winPv;
		/**
		 * 领取淘礼金金额
		 */
		@ApiField("win_sum_amt")
		private String winSumAmt;
	

	public String getAlipayAmt() {
			return this.alipayAmt;
		}
		public void setAlipayAmt(String alipayAmt) {
			this.alipayAmt = alipayAmt;
		}
		public Long getAlipayNum() {
			return this.alipayNum;
		}
		public void setAlipayNum(Long alipayNum) {
			this.alipayNum = alipayNum;
		}
		public String getCmSettleAmt() {
			return this.cmSettleAmt;
		}
		public void setCmSettleAmt(String cmSettleAmt) {
			this.cmSettleAmt = cmSettleAmt;
		}
		public String getGetRate() {
			return this.getRate;
		}
		public void setGetRate(String getRate) {
			this.getRate = getRate;
		}
		public String getPrePubShareFeeForDisp() {
			return this.prePubShareFeeForDisp;
		}
		public void setPrePubShareFeeForDisp(String prePubShareFeeForDisp) {
			this.prePubShareFeeForDisp = prePubShareFeeForDisp;
		}
		public Long getRefundNum() {
			return this.refundNum;
		}
		public void setRefundNum(Long refundNum) {
			this.refundNum = refundNum;
		}
		public String getRefundSumAmt() {
			return this.refundSumAmt;
		}
		public void setRefundSumAmt(String refundSumAmt) {
			this.refundSumAmt = refundSumAmt;
		}
		public String getRemainingAmt() {
			return this.remainingAmt;
		}
		public void setRemainingAmt(String remainingAmt) {
			this.remainingAmt = remainingAmt;
		}
		public Long getRemainingNum() {
			return this.remainingNum;
		}
		public void setRemainingNum(Long remainingNum) {
			this.remainingNum = remainingNum;
		}
		public Long getUseNum() {
			return this.useNum;
		}
		public void setUseNum(Long useNum) {
			this.useNum = useNum;
		}
		public String getUseRate() {
			return this.useRate;
		}
		public void setUseRate(String useRate) {
			this.useRate = useRate;
		}
		public String getUseSumAmt() {
			return this.useSumAmt;
		}
		public void setUseSumAmt(String useSumAmt) {
			this.useSumAmt = useSumAmt;
		}
		public Long getWinPv() {
			return this.winPv;
		}
		public void setWinPv(Long winPv) {
			this.winPv = winPv;
		}
		public String getWinSumAmt() {
			return this.winSumAmt;
		}
		public void setWinSumAmt(String winSumAmt) {
			this.winSumAmt = winSumAmt;
		}

}

	/**
 * 结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class InstanceDTO extends TaobaoObject {

	private static final long serialVersionUID = 1396916325364769289L;

	/**
		 * extra
		 */
		@ApiField("extra")
		private Extra extra;
	

	public Extra getExtra() {
			return this.extra;
		}
		public void setExtra(Extra extra) {
			this.extra = extra;
		}

}



}
