package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.tbk.relation.refund response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TbkRelationRefundResponse extends TaobaoResponse {

	private static final long serialVersionUID = 8445271989982716444L;

	/** 
	 * 返回结果封装对象
	 */
	@ApiField("result")
	private RpcResult result;


	public void setResult(RpcResult result) {
		this.result = result;
	}
	public RpcResult getResult( ) {
		return this.result;
	}
	
	/**
 * 订单列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Result extends TaobaoObject {

	private static final long serialVersionUID = 7564666442943329633L;

	/**
		 * （口碑订单）口碑子订单号
		 */
		@ApiField("alsc_id")
		private String alscId;
		/**
		 * （口碑订单）口碑父订单号
		 */
		@ApiField("alsc_pid")
		private String alscPid;
		/**
		 * 订单结算时间
		 */
		@ApiField("earning_time")
		private Date earningTime;
		/**
		 * 更新时间
		 */
		@ApiField("modified_time")
		private Date modifiedTime;
		/**
		 * 维权金额
		 */
		@ApiField("refund_fee")
		private String refundFee;
		/**
		 * 维权创建(淘客结算回执) 4,维权成功(淘客结算回执) 2,维权失败(淘客结算回执) 3,发生多次维权，待处理      11,从淘客处补扣（钱已结给淘客） 等待扣款 12,从淘客处补扣（钱已结给淘客） 扣款成功 13,从卖家处补扣（钱已结给卖家） 等待扣款 14,从卖家处补扣（钱已结给卖家） 扣款成功 15
		 */
		@ApiField("refund_status")
		private Long refundStatus;
		/**
		 * 1 表示2方，2表示3方
		 */
		@ApiField("refund_type")
		private Long refundType;
		/**
		 * 渠道关系id
		 */
		@ApiField("relation_id")
		private Long relationId;
		/**
		 * 会员关系id
		 */
		@ApiField("special_id")
		private Long specialId;
		/**
		 * 宝贝标题
		 */
		@ApiField("tb_auction_title")
		private String tbAuctionTitle;
		/**
		 * 订单创建时间
		 */
		@ApiField("tb_trade_create_time")
		private Date tbTradeCreateTime;
		/**
		 * 结算金额
		 */
		@ApiField("tb_trade_finish_price")
		private String tbTradeFinishPrice;
		/**
		 * 淘宝子订单编号
		 */
		@ApiField("tb_trade_id")
		private Long tbTradeId;
		/**
		 * 淘宝订单编号
		 */
		@ApiField("tb_trade_parent_id")
		private Long tbTradeParentId;
		/**
		 * 第三方推广者memberid
		 */
		@ApiField("tk3rd_pub_id")
		private Long tk3rdPubId;
		/**
		 * 应返商家金额(三方)
		 */
		@ApiField("tk3rd_pub_show_return_fee")
		private String tk3rdPubShowReturnFee;
		/**
		 * 第三方应该返还的佣金
		 */
		@ApiField("tk_commission_fee_refund3rd_pub")
		private String tkCommissionFeeRefund3rdPub;
		/**
		 * 第二方应该返还的佣金(不包括技术服务费)
		 */
		@ApiField("tk_commission_fee_refund_pub")
		private String tkCommissionFeeRefundPub;
		/**
		 * 推广者memberid
		 */
		@ApiField("tk_pub_id")
		private Long tkPubId;
		/**
		 * 应返商家金额(二方)
		 */
		@ApiField("tk_pub_show_return_fee")
		private String tkPubShowReturnFee;
		/**
		 * 维权完成时间
		 */
		@ApiField("tk_refund_suit_time")
		private Date tkRefundSuitTime;
		/**
		 * 维权创建时间
		 */
		@ApiField("tk_refund_time")
		private Date tkRefundTime;
		/**
		 * 第三方应该返还的补贴
		 */
		@ApiField("tk_subsidy_fee_refund3rd_pub")
		private String tkSubsidyFeeRefund3rdPub;
		/**
		 * 第二方应该返还的补贴(不包括技术服务费)
		 */
		@ApiField("tk_subsidy_fee_refund_pub")
		private String tkSubsidyFeeRefundPub;
	

	public String getAlscId() {
			return this.alscId;
		}
		public void setAlscId(String alscId) {
			this.alscId = alscId;
		}
		public String getAlscPid() {
			return this.alscPid;
		}
		public void setAlscPid(String alscPid) {
			this.alscPid = alscPid;
		}
		public Date getEarningTime() {
			return this.earningTime;
		}
		public void setEarningTime(Date earningTime) {
			this.earningTime = earningTime;
		}
		public Date getModifiedTime() {
			return this.modifiedTime;
		}
		public void setModifiedTime(Date modifiedTime) {
			this.modifiedTime = modifiedTime;
		}
		public String getRefundFee() {
			return this.refundFee;
		}
		public void setRefundFee(String refundFee) {
			this.refundFee = refundFee;
		}
		public Long getRefundStatus() {
			return this.refundStatus;
		}
		public void setRefundStatus(Long refundStatus) {
			this.refundStatus = refundStatus;
		}
		public Long getRefundType() {
			return this.refundType;
		}
		public void setRefundType(Long refundType) {
			this.refundType = refundType;
		}
		public Long getRelationId() {
			return this.relationId;
		}
		public void setRelationId(Long relationId) {
			this.relationId = relationId;
		}
		public Long getSpecialId() {
			return this.specialId;
		}
		public void setSpecialId(Long specialId) {
			this.specialId = specialId;
		}
		public String getTbAuctionTitle() {
			return this.tbAuctionTitle;
		}
		public void setTbAuctionTitle(String tbAuctionTitle) {
			this.tbAuctionTitle = tbAuctionTitle;
		}
		public Date getTbTradeCreateTime() {
			return this.tbTradeCreateTime;
		}
		public void setTbTradeCreateTime(Date tbTradeCreateTime) {
			this.tbTradeCreateTime = tbTradeCreateTime;
		}
		public String getTbTradeFinishPrice() {
			return this.tbTradeFinishPrice;
		}
		public void setTbTradeFinishPrice(String tbTradeFinishPrice) {
			this.tbTradeFinishPrice = tbTradeFinishPrice;
		}
		public Long getTbTradeId() {
			return this.tbTradeId;
		}
		public void setTbTradeId(Long tbTradeId) {
			this.tbTradeId = tbTradeId;
		}
		public Long getTbTradeParentId() {
			return this.tbTradeParentId;
		}
		public void setTbTradeParentId(Long tbTradeParentId) {
			this.tbTradeParentId = tbTradeParentId;
		}
		public Long getTk3rdPubId() {
			return this.tk3rdPubId;
		}
		public void setTk3rdPubId(Long tk3rdPubId) {
			this.tk3rdPubId = tk3rdPubId;
		}
		public String getTk3rdPubShowReturnFee() {
			return this.tk3rdPubShowReturnFee;
		}
		public void setTk3rdPubShowReturnFee(String tk3rdPubShowReturnFee) {
			this.tk3rdPubShowReturnFee = tk3rdPubShowReturnFee;
		}
		public String getTkCommissionFeeRefund3rdPub() {
			return this.tkCommissionFeeRefund3rdPub;
		}
		public void setTkCommissionFeeRefund3rdPub(String tkCommissionFeeRefund3rdPub) {
			this.tkCommissionFeeRefund3rdPub = tkCommissionFeeRefund3rdPub;
		}
		public String getTkCommissionFeeRefundPub() {
			return this.tkCommissionFeeRefundPub;
		}
		public void setTkCommissionFeeRefundPub(String tkCommissionFeeRefundPub) {
			this.tkCommissionFeeRefundPub = tkCommissionFeeRefundPub;
		}
		public Long getTkPubId() {
			return this.tkPubId;
		}
		public void setTkPubId(Long tkPubId) {
			this.tkPubId = tkPubId;
		}
		public String getTkPubShowReturnFee() {
			return this.tkPubShowReturnFee;
		}
		public void setTkPubShowReturnFee(String tkPubShowReturnFee) {
			this.tkPubShowReturnFee = tkPubShowReturnFee;
		}
		public Date getTkRefundSuitTime() {
			return this.tkRefundSuitTime;
		}
		public void setTkRefundSuitTime(Date tkRefundSuitTime) {
			this.tkRefundSuitTime = tkRefundSuitTime;
		}
		public Date getTkRefundTime() {
			return this.tkRefundTime;
		}
		public void setTkRefundTime(Date tkRefundTime) {
			this.tkRefundTime = tkRefundTime;
		}
		public String getTkSubsidyFeeRefund3rdPub() {
			return this.tkSubsidyFeeRefund3rdPub;
		}
		public void setTkSubsidyFeeRefund3rdPub(String tkSubsidyFeeRefund3rdPub) {
			this.tkSubsidyFeeRefund3rdPub = tkSubsidyFeeRefund3rdPub;
		}
		public String getTkSubsidyFeeRefundPub() {
			return this.tkSubsidyFeeRefundPub;
		}
		public void setTkSubsidyFeeRefundPub(String tkSubsidyFeeRefundPub) {
			this.tkSubsidyFeeRefundPub = tkSubsidyFeeRefundPub;
		}

}

	/**
 * 真正的业务数据结构
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PageResult extends TaobaoObject {

	private static final long serialVersionUID = 4828862161436482618L;

	/**
		 * pageNo
		 */
		@ApiField("page_no")
		private String pageNo;
		/**
		 * pageSize
		 */
		@ApiField("page_size")
		private String pageSize;
		/**
		 * 订单列表
		 */
		@ApiListField("results")
		@ApiField("result")
		private List<Result> results;
		/**
		 * 总值
		 */
		@ApiField("total_count")
		private String totalCount;
	

	public String getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(String pageNo) {
			this.pageNo = pageNo;
		}
		public String getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(String pageSize) {
			this.pageSize = pageSize;
		}
		public List<Result> getResults() {
			return this.results;
		}
		public void setResults(List<Result> results) {
			this.results = results;
		}
		public String getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(String totalCount) {
			this.totalCount = totalCount;
		}

}

	/**
 * 返回结果封装对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class RpcResult extends TaobaoObject {

	private static final long serialVersionUID = 6653975971726712821L;

	/**
		 * 业务错误码 101, 102,103
		 */
		@ApiField("biz_error_code")
		private Long bizErrorCode;
		/**
		 * 业务错误信息
		 */
		@ApiField("biz_error_desc")
		private String bizErrorDesc;
		/**
		 * 真正的业务数据结构
		 */
		@ApiField("data")
		private PageResult data;
		/**
		 * 接口返回值信息，跟rpc架构保持一致
		 */
		@ApiField("result_code")
		private Long resultCode;
		/**
		 * 返回信息
		 */
		@ApiField("result_msg")
		private String resultMsg;
	

	public Long getBizErrorCode() {
			return this.bizErrorCode;
		}
		public void setBizErrorCode(Long bizErrorCode) {
			this.bizErrorCode = bizErrorCode;
		}
		public String getBizErrorDesc() {
			return this.bizErrorDesc;
		}
		public void setBizErrorDesc(String bizErrorDesc) {
			this.bizErrorDesc = bizErrorDesc;
		}
		public PageResult getData() {
			return this.data;
		}
		public void setData(PageResult data) {
			this.data = data;
		}
		public Long getResultCode() {
			return this.resultCode;
		}
		public void setResultCode(Long resultCode) {
			this.resultCode = resultCode;
		}
		public String getResultMsg() {
			return this.resultMsg;
		}
		public void setResultMsg(String resultMsg) {
			this.resultMsg = resultMsg;
		}

}



}
