package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.tbk.sc.publisher.info.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TbkScPublisherInfoGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 3286381226175567665L;

	/** 
	 * data
	 */
	@ApiField("data")
	private Data data;


	public void setData(Data data) {
		this.data = data;
	}
	public Data getData( ) {
		return this.data;
	}
	
	/**
 * 线下备案专属信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class RegisterInfoDto extends TaobaoObject {

	private static final long serialVersionUID = 5344792826574117466L;

	/**
		 * 渠道独有 -经营类型
		 */
		@ApiField("career")
		private String career;
		/**
		 * 渠道独有 - 编号
		 */
		@ApiField("certify_number")
		private String certifyNumber;
		/**
		 * 渠道独有 -信息
		 */
		@ApiField("detail_address")
		private String detailAddress;
		/**
		 * 渠道独有 -区
		 */
		@ApiField("location")
		private String location;
		/**
		 * 渠道独有 - 信息
		 */
		@ApiField("phone_number")
		private String phoneNumber;
		/**
		 * 渠道独有 -类型
		 */
		@ApiField("shop_certify_type")
		private String shopCertifyType;
		/**
		 * 渠道独有 -店铺名称
		 */
		@ApiField("shop_name")
		private String shopName;
		/**
		 * 渠道独有 -店铺类型
		 */
		@ApiField("shop_type")
		private String shopType;
	

	public String getCareer() {
			return this.career;
		}
		public void setCareer(String career) {
			this.career = career;
		}
		public String getCertifyNumber() {
			return this.certifyNumber;
		}
		public void setCertifyNumber(String certifyNumber) {
			this.certifyNumber = certifyNumber;
		}
		public String getDetailAddress() {
			return this.detailAddress;
		}
		public void setDetailAddress(String detailAddress) {
			this.detailAddress = detailAddress;
		}
		public String getLocation() {
			return this.location;
		}
		public void setLocation(String location) {
			this.location = location;
		}
		public String getPhoneNumber() {
			return this.phoneNumber;
		}
		public void setPhoneNumber(String phoneNumber) {
			this.phoneNumber = phoneNumber;
		}
		public String getShopCertifyType() {
			return this.shopCertifyType;
		}
		public void setShopCertifyType(String shopCertifyType) {
			this.shopCertifyType = shopCertifyType;
		}
		public String getShopName() {
			return this.shopName;
		}
		public void setShopName(String shopName) {
			this.shopName = shopName;
		}
		public String getShopType() {
			return this.shopType;
		}
		public void setShopType(String shopType) {
			this.shopType = shopType;
		}

}

	/**
 * 共享字段 - 渠道或会员列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class MapData extends TaobaoObject {

	private static final long serialVersionUID = 5623341526469635725L;

	/**
		 * 渠道独有 - 渠道昵称
		 */
		@ApiField("account_name")
		private String accountName;
		/**
		 * 共享字段 - 备案日期
		 */
		@ApiField("create_date")
		private Date createDate;
		/**
		 * 淘宝客外部用户标记
		 */
		@ApiField("external_id")
		private String externalId;
		/**
		 * 1-微信、2-微博、3-抖音、4-快手、5-QQ，0-其他
		 */
		@ApiField("external_type")
		private String externalType;
		/**
		 * 渠道独有 - 媒体侧渠道备注信息
		 */
		@ApiField("note")
		private String note;
		/**
		 * 线下备案专属信息
		 */
		@ApiField("offline_info")
		private RegisterInfoDto offlineInfo;
		/**
		 * 渠道独有 - 线下场景信息，1 - 门店，2- 学校，3 - 工厂，4 - 其他
		 */
		@ApiField("offline_scene")
		private String offlineScene;
		/**
		 * 渠道独有 - 线上场景信息，1 - 微信群，2- QQ群，3 - 其他
		 */
		@ApiField("online_scene")
		private String onlineScene;
		/**
		 * 渠道独有 - 处罚状态
		 */
		@ApiField("punish_status")
		private String punishStatus;
		/**
		 * 渠道独有 - 渠道名称
		 */
		@ApiField("real_name")
		private String realName;
		/**
		 * 共享字段 - 备案场景：common（通用备案），etao（一淘备案），minietao（一淘小程序备案），offlineShop（线下门店备案），offlinePerson（线下个人备案）
		 */
		@ApiField("relation_app")
		private String relationApp;
		/**
		 * 渠道独有 - 渠道关系ID
		 */
		@ApiField("relation_id")
		private Long relationId;
		/**
		 * 共享字段 - 渠道会员专属pid
		 */
		@ApiField("root_pid")
		private String rootPid;
		/**
		 * 共享字段 - 渠道会员原始身份信息
		 */
		@ApiField("rtag")
		private String rtag;
		/**
		 * 会员独有 - 会员运营ID
		 */
		@ApiField("special_id")
		private Long specialId;
	

	public String getAccountName() {
			return this.accountName;
		}
		public void setAccountName(String accountName) {
			this.accountName = accountName;
		}
		public Date getCreateDate() {
			return this.createDate;
		}
		public void setCreateDate(Date createDate) {
			this.createDate = createDate;
		}
		public String getExternalId() {
			return this.externalId;
		}
		public void setExternalId(String externalId) {
			this.externalId = externalId;
		}
		public String getExternalType() {
			return this.externalType;
		}
		public void setExternalType(String externalType) {
			this.externalType = externalType;
		}
		public String getNote() {
			return this.note;
		}
		public void setNote(String note) {
			this.note = note;
		}
		public RegisterInfoDto getOfflineInfo() {
			return this.offlineInfo;
		}
		public void setOfflineInfo(RegisterInfoDto offlineInfo) {
			this.offlineInfo = offlineInfo;
		}
		public String getOfflineScene() {
			return this.offlineScene;
		}
		public void setOfflineScene(String offlineScene) {
			this.offlineScene = offlineScene;
		}
		public String getOnlineScene() {
			return this.onlineScene;
		}
		public void setOnlineScene(String onlineScene) {
			this.onlineScene = onlineScene;
		}
		public String getPunishStatus() {
			return this.punishStatus;
		}
		public void setPunishStatus(String punishStatus) {
			this.punishStatus = punishStatus;
		}
		public String getRealName() {
			return this.realName;
		}
		public void setRealName(String realName) {
			this.realName = realName;
		}
		public String getRelationApp() {
			return this.relationApp;
		}
		public void setRelationApp(String relationApp) {
			this.relationApp = relationApp;
		}
		public Long getRelationId() {
			return this.relationId;
		}
		public void setRelationId(Long relationId) {
			this.relationId = relationId;
		}
		public String getRootPid() {
			return this.rootPid;
		}
		public void setRootPid(String rootPid) {
			this.rootPid = rootPid;
		}
		public String getRtag() {
			return this.rtag;
		}
		public void setRtag(String rtag) {
			this.rtag = rtag;
		}
		public Long getSpecialId() {
			return this.specialId;
		}
		public void setSpecialId(Long specialId) {
			this.specialId = specialId;
		}

}

	/**
 * data
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Data extends TaobaoObject {

	private static final long serialVersionUID = 1836389149866759835L;

	/**
		 * 共享字段 - 渠道或会员列表
		 */
		@ApiListField("inviter_list")
		@ApiField("map_data")
		private List<MapData> inviterList;
		/**
		 * 渠道专属pidList
		 */
		@ApiListField("root_pid_channel_list")
		@ApiField("string")
		private List<String> rootPidChannelList;
		/**
		 * 共享字段 - 总记录数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public List<MapData> getInviterList() {
			return this.inviterList;
		}
		public void setInviterList(List<MapData> inviterList) {
			this.inviterList = inviterList;
		}
		public List<String> getRootPidChannelList() {
			return this.rootPidChannelList;
		}
		public void setRootPidChannelList(List<String> rootPidChannelList) {
			this.rootPidChannelList = rootPidChannelList;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}



}
