/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.api;

import com.aliyun.api.AliyunAsyncHandler;
import com.aliyun.api.AliyunClient;
import com.aliyun.api.AliyunParser;
import com.aliyun.api.AliyunRequest;
import com.aliyun.api.AliyunResponse;
import com.aliyun.api.AliyunSignature;
import com.aliyun.api.AliyunUploadRequest;
import com.aliyun.api.internal.parser.json.ObjectJsonParser;
import com.aliyun.api.internal.parser.xml.ObjectXmlParser;
import com.aliyun.api.internal.util.AliyunLogger;
import com.aliyun.api.internal.util.AliyunWebUtils;
import com.taobao.api.ApiException;
import com.taobao.api.ApiRuleException;
import com.taobao.api.FileItem;
import com.taobao.api.internal.util.RequestParametersHolder;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAliyunClient
implements AliyunClient {
    private String serverUrl;
    private String accessKeyId;
    private String accessKeySecret;
    private String format = "json";
    private String signatureMethod = "HMAC-SHA1";
    private String signatureVersion = "1.0";
    private ExecutorService executorService;
    private int connectTimeout = 3000;
    private int readTimeout = 80000;
    private boolean needCheckRequest = true;
    private boolean needEnableParser = true;
    private boolean useSimplifyJson = false;
    private static final String PARTNER_ID = "partner_id";
    private static final String SIMPLIFY = "simplify";
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public DefaultAliyunClient(String serverUrl, String accessKeyId, String accessKeySecret) {
        this.serverUrl = serverUrl;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
    }

    public DefaultAliyunClient(String serverUrl, String accessKeyId, String accessKeySecret, String format) {
        this(serverUrl, accessKeyId, accessKeySecret);
        this.format = format;
    }

    public DefaultAliyunClient(String serverUrl, String accessKeyId, String accessKeySecret, String format, int connectTimeout, int readTimeout) {
        this(serverUrl, accessKeyId, accessKeySecret, format);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public DefaultAliyunClient(String serverUrl, String accessKeyId, String accessKeySecret, String format, int connectTimeout, int readTimeout, ExecutorService executorService) {
        this(serverUrl, accessKeyId, accessKeySecret, format, connectTimeout, readTimeout);
        this.executorService = executorService;
    }

    @Override
    public <T extends AliyunResponse> T execute(AliyunRequest<T> request) throws ApiException {
        AliyunParser<T> parser = null;
        if (this.needEnableParser) {
            parser = "xml".equals(this.format) ? new ObjectXmlParser<T>(request.getResponseClass()) : new ObjectJsonParser<T>(request.getResponseClass(), this.useSimplifyJson);
        }
        return this._execute(request, parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends AliyunResponse> Future<T> executeAsync(final AliyunRequest<T> request, final AliyunAsyncHandler<T> asyncHandler) throws ApiException {
        if (this.executorService == null) {
            DefaultAliyunClient defaultAliyunClient = this;
            synchronized (defaultAliyunClient) {
                if (this.executorService == null) {
                    this.executorService = Executors.newFixedThreadPool(50);
                }
            }
        }
        return this.executorService.submit(new Callable<T>(){

            @Override
            public T call() throws ApiException {
                Object response;
                try {
                    response = DefaultAliyunClient.this.execute(request);
                }
                catch (ApiException e) {
                    asyncHandler.onError(e);
                    throw e;
                }
                asyncHandler.onSuccess(request, response);
                return response;
            }
        });
    }

    public <T extends AliyunResponse> T _execute(AliyunRequest<T> request, AliyunParser<T> parser) throws ApiException {
        Map<String, Object> rt;
        if (this.needCheckRequest) {
            try {
                request.check();
            }
            catch (ApiRuleException e) {
                AliyunResponse localResponse = null;
                try {
                    localResponse = (AliyunResponse)request.getResponseClass().newInstance();
                }
                catch (Exception xe) {
                    throw new ApiException(xe);
                }
                localResponse.setErrorCode(e.getErrCode());
                localResponse.setMessage(e.getErrMsg());
                return (T)localResponse;
            }
        }
        if ((rt = this.doPost(request)) == null) {
            return null;
        }
        AliyunResponse tRsp = null;
        if (this.needEnableParser) {
            try {
                tRsp = parser.parse((String)rt.get("rsp"));
                tRsp.setBody((String)rt.get("rsp"));
            }
            catch (RuntimeException e) {
                AliyunLogger.logBizError((String)rt.get("rsp"));
                throw e;
            }
        }
        try {
            tRsp = (AliyunResponse)request.getResponseClass().newInstance();
            tRsp.setBody((String)rt.get("rsp"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        tRsp.setParams((TaobaoHashMap)rt.get("textParams"));
        if (!tRsp.isSuccess()) {
            AliyunLogger.logErrorScene(rt, tRsp, this.accessKeyId);
        }
        return (T)tRsp;
    }

    public <T extends AliyunResponse> Map<String, Object> doPost(AliyunRequest<T> request) throws ApiException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        TaobaoHashMap appParams = new TaobaoHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        requestHolder.setApplicationParams(appParams);
        TaobaoHashMap protocalMustParams = new TaobaoHashMap();
        try {
            this.addProtocalMustParams(request, protocalMustParams);
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        requestHolder.setProtocalMustParams(protocalMustParams);
        TaobaoHashMap protocalOptParams = new TaobaoHashMap();
        this.addProtocalOptParams(protocalOptParams);
        requestHolder.setProtocalOptParams(protocalOptParams);
        String url = null;
        try {
            protocalMustParams.put("Signature", AliyunSignature.computeSignature(requestHolder.getAllParams(), this.accessKeySecret));
            String query = this.paramsToQueryString(requestHolder.getAllParams());
            url = (this.serverUrl.endsWith("/") ? this.serverUrl : this.serverUrl + "/") + "?" + query;
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        String rsp = null;
        try {
            if (request instanceof AliyunUploadRequest) {
                AliyunUploadRequest uRequest = (AliyunUploadRequest)request;
                Map<String, FileItem> fileParams = TaobaoUtils.cleanupMap(uRequest.getFileParams());
                rsp = AliyunWebUtils.doPost(url, null, fileParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap());
            } else {
                rsp = AliyunWebUtils.doPost(url, null, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap());
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        result.put("rsp", rsp);
        result.put("textParams", appParams);
        result.put("protocalMustParams", protocalMustParams);
        result.put("protocalOptParams", protocalOptParams);
        result.put("url", url);
        return result;
    }

    private <T extends AliyunResponse> void addProtocalMustParams(AliyunRequest<T> request, TaobaoHashMap protocalMustParams) throws Exception {
        String[] strArray = request.getApiMethodName().split("\\.");
        if (strArray.length < 5) {
            throw new ApiException("Wrong api name.");
        }
        String action = strArray[3];
        protocalMustParams.put("Action", action);
        String version = strArray[4];
        protocalMustParams.put("Version", version);
        protocalMustParams.put("AccessKeyId", this.accessKeyId);
        protocalMustParams.put("Format", this.format);
        Long timestamp = request.getTimestamp();
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        protocalMustParams.put("Timestamp", this.formatIso8601Date(new Date(timestamp)));
        protocalMustParams.put("SignatureMethod", this.signatureMethod);
        protocalMustParams.put("SignatureVersion", this.signatureVersion);
        protocalMustParams.put("SignatureNonce", UUID.randomUUID().toString());
    }

    private <T extends AliyunResponse> void addProtocalOptParams(TaobaoHashMap protocalOptParams) {
        protocalOptParams.put("Format", this.format);
        protocalOptParams.put(PARTNER_ID, "top-sdk-java-20230209");
        if (this.useSimplifyJson) {
            protocalOptParams.put(SIMPLIFY, Boolean.TRUE.toString());
        }
    }

    private String paramsToQueryString(Map<String, String> params) throws UnsupportedEncodingException {
        if (params == null || params.size() == 0) {
            return null;
        }
        StringBuilder paramString = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> p : params.entrySet()) {
            String key = p.getKey();
            String val = p.getValue();
            if (!first) {
                paramString.append("&");
            }
            paramString.append(URLEncoder.encode(key, "UTF-8"));
            if (val != null) {
                paramString.append("=").append(URLEncoder.encode(val, "UTF-8"));
            }
            first = false;
        }
        return paramString.toString();
    }

    private String formatIso8601Date(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df.format(date);
    }

    public void setNeedCheckRequest(boolean needCheckRequest) {
        this.needCheckRequest = needCheckRequest;
    }

    public void setNeedEnableParser(boolean needEnableParser) {
        this.needEnableParser = needEnableParser;
    }

    public void setNeedEnableLogger(boolean needEnableLogger) {
        AliyunLogger.setNeedEnableLogger(needEnableLogger);
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }
}

