/*
 * Decompiled with CFR 0.152.
 */
package com.tokenview.sign.btc;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tokenview.enums.Version;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.DumpedPrivateKey;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.UTXO;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.script.Script;
import org.spongycastle.util.encoders.Hex;

public class BTCSign {
    public String signBTCTransaction(String privateKey, JSONArray unspents, JSONArray outputs) {
        String hexString = "";
        try {
            MainNetParams params = MainNetParams.get();
            DumpedPrivateKey priKey = DumpedPrivateKey.fromBase58((NetworkParameters)params, (String)privateKey);
            ECKey ecKey = priKey.getKey();
            System.out.println(ecKey.getPrivateKeyAsHex());
            System.out.println(ecKey.getPublicKeyAsHex());
            System.out.println(new String(ecKey.getPubKeyHash()));
            Transaction transaction = new Transaction((NetworkParameters)params);
            transaction.setVersion(Version.BTC.getVersion().intValue());
            long fee = (unspents.size() + outputs.size() * 2) * 148 - 10;
            for (int i = 0; i < outputs.size() - 1; ++i) {
                transaction.addOutput(Coin.valueOf((long)outputs.getJSONObject(i).getLong("amount")), Address.fromBase58((NetworkParameters)params, (String)outputs.getJSONObject(i).getString("account")));
            }
            JSONObject outputChange = outputs.getJSONObject(outputs.size() - 1);
            transaction.addOutput(Coin.valueOf((long)(outputChange.getLong("amount") - fee)), Address.fromBase58((NetworkParameters)params, (String)outputChange.getString("account")));
            for (int i = 0; i < unspents.size(); ++i) {
                UTXO utxo = new UTXO(Sha256Hash.wrap((String)unspents.getJSONObject(i).getString("txid")), Long.parseLong(unspents.getJSONObject(i).getString("tx_output_n")), Coin.valueOf((long)unspents.getJSONObject(i).getLong("value")), 0, false, new Script(Hex.decode((String)unspents.getJSONObject(i).getString("script_hex"))));
                TransactionOutPoint outPoint = new TransactionOutPoint((NetworkParameters)params, utxo.getIndex(), utxo.getHash());
                transaction.addSignedInput(outPoint, utxo.getScript(), priKey.getKey(), Transaction.SigHash.ALL, true);
            }
            hexString = Hex.toHexString((byte[])transaction.bitcoinSerialize());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hexString;
    }

    public String getAddress(String privateKeyHex) {
        MainNetParams params = MainNetParams.get();
        ECKey ecKey = ECKey.fromPrivate((byte[])org.bouncycastle.util.encoders.Hex.decode((String)privateKeyHex));
        return ecKey.toAddress((NetworkParameters)params).toString();
    }
}

