/*
 * Decompiled with CFR 0.152.
 */
package com.tokenview.utils;

import com.tokenview.bean.WalletBean;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.DumpedPrivateKey;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Utils;
import org.bitcoinj.crypto.ChildNumber;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.HDKeyDerivation;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.wallet.DeterministicSeed;
import org.bouncycastle.util.encoders.Hex;
import org.web3j.crypto.ECKeyPair;
import org.web3j.utils.Numeric;

public class BTCWalletUtil {
    public static String BTC_TEST_PATH = "m/44'/1'/0'/0/0";
    public static String BTC_MAIN_PATH = "m/44'/0'/0'/0/0";
    public static String BTC_SEGWIT_MAIN_PATH = "m/49'/0'/0'/0/0";
    public static String BTC_SEGWIT_TEST_PATH = "m/49'/1'/0'/0/0";
    public static String ETH_MAIN_PATH = "m/44'/60'/0'/0/0";

    public static WalletBean loadWalletByDeterministicSeed(DeterministicSeed ds, String pwd, String walletName) {
        String path = BTC_MAIN_PATH;
        MainNetParams params = MainNetParams.get();
        ECKeyPair keyPair = BTCWalletUtil.getEcKeyPairByDeterministicSeed(path, ds);
        if (keyPair == null) {
            return null;
        }
        ECKey ecKey = ECKey.fromPrivate((BigInteger)keyPair.getPrivateKey());
        String privateKeyAsWiF = ecKey.getPrivateKeyAsWiF((NetworkParameters)params);
        String address = ecKey.toAddress((NetworkParameters)params).toString();
        WalletBean bean = new WalletBean();
        bean.setCoin_type("BTC");
        bean.setMnemonic(BTCWalletUtil.getMnemonic(ds));
        bean.setAddress(address);
        bean.setKeystore("");
        bean.setPrivateKey(privateKeyAsWiF);
        return bean;
    }

    public static WalletBean loadWalletBIP49ByDeterministicSeed(List<String> mnemonic) {
        DeterministicSeed ds = BTCWalletUtil.getDeterministicSeed(mnemonic);
        String path = BTC_SEGWIT_MAIN_PATH;
        MainNetParams params = MainNetParams.get();
        String[] pathArray = path.split("/");
        byte[] seedBytes = ds.getSeedBytes();
        DeterministicKey dkKey = HDKeyDerivation.createMasterPrivateKey((byte[])seedBytes);
        for (int i = 1; i < pathArray.length; ++i) {
            ChildNumber childNumber;
            int number;
            if (pathArray[i].endsWith("'")) {
                number = Integer.parseInt(pathArray[i].substring(0, pathArray[i].length() - 1));
                childNumber = new ChildNumber(number, true);
            } else {
                number = Integer.parseInt(pathArray[i]);
                childNumber = new ChildNumber(number, false);
            }
            dkKey = HDKeyDerivation.deriveChildKey((DeterministicKey)dkKey, (ChildNumber)childNumber);
        }
        String publicKey = Numeric.toHexStringNoPrefix((byte[])dkKey.getPubKeyHash());
        String redeemScript = String.format("0x0014%s", publicKey);
        byte[] bytes = Numeric.hexStringToByteArray((String)redeemScript);
        byte[] bytes1 = Utils.sha256hash160((byte[])bytes);
        String p2shAddress = Address.fromP2SHHash((NetworkParameters)params, (byte[])bytes1).toBase58();
        System.out.println("p2sh account == " + p2shAddress);
        WalletBean bean = new WalletBean();
        bean.setCoin_type("BTC");
        bean.setAddress(p2shAddress);
        bean.setMnemonic(BTCWalletUtil.getMnemonic(ds));
        bean.setPrivateKey(dkKey.getPrivateKeyAsWiF((NetworkParameters)params));
        return bean;
    }

    public static WalletBean loadWalletByDeterministicSeedTest(DeterministicSeed ds, String pwd, String walletName) {
        String path = BTC_MAIN_PATH;
        MainNetParams params = MainNetParams.get();
        ECKeyPair keyPair = BTCWalletUtil.getEcKeyPairByDeterministicSeed(path, ds);
        if (keyPair == null) {
            return null;
        }
        ECKey ecKey = ECKey.fromPrivate((BigInteger)keyPair.getPrivateKey());
        String hexPrivateKey = ecKey.getPrivateKeyAsHex();
        ECKey ecKey1 = ECKey.fromPrivate((byte[])Hex.decode((String)hexPrivateKey));
        Address address1 = ecKey1.toAddress((NetworkParameters)params);
        System.out.println("bitcoin account == " + address1);
        System.out.println("privateKeyHex == " + ecKey.getPrivateKeyAsHex());
        String privateKeyAsWiF = ecKey.getPrivateKeyAsWiF((NetworkParameters)params);
        System.out.println("privateKeyWif ==" + privateKeyAsWiF);
        String address = ecKey.toAddress((NetworkParameters)params).toString();
        System.out.println("bitcoin account == " + address);
        WalletBean bean = new WalletBean();
        bean.setCoin_type("BTC");
        bean.setMnemonic(BTCWalletUtil.getMnemonic(ds));
        bean.setAddress(address);
        bean.setKeystore("");
        bean.setPrivateKey(privateKeyAsWiF);
        return bean;
    }

    public static WalletBean loadWalletByPrivateKey(String privateKey) {
        MainNetParams params = MainNetParams.get();
        try {
            DumpedPrivateKey priKey = DumpedPrivateKey.fromBase58((NetworkParameters)params, (String)privateKey);
            ECKey ecKey = priKey.getKey();
            String address = ecKey.toAddress((NetworkParameters)params).toString();
            WalletBean bean = new WalletBean();
            bean.setCoin_type("BTC");
            bean.setMnemonic(" ");
            bean.setAddress(address);
            bean.setKeystore("");
            bean.setPrivateKey(privateKey);
            return bean;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static WalletBean loadWalletByMnemonic(String currency, List<String> list, String pwd, String walletName) {
        String path = "";
        if (currency.equalsIgnoreCase("btc")) {
            path = BTC_MAIN_PATH;
        }
        if (currency.equalsIgnoreCase("eth")) {
            path = ETH_MAIN_PATH;
        }
        MainNetParams params = MainNetParams.get();
        DeterministicSeed ds = BTCWalletUtil.getDeterministicSeed(list);
        ECKeyPair keyPair = BTCWalletUtil.getEcKeyPairByDeterministicSeed(path, ds);
        ECKey ecKey = ECKey.fromPrivate((BigInteger)keyPair.getPrivateKey());
        String privateKeyAsWiF = ecKey.getPrivateKeyAsWiF((NetworkParameters)params);
        String address = ecKey.toAddress((NetworkParameters)params).toString();
        System.out.println("privateKey ====" + ecKey.getPrivateKeyAsHex());
        System.out.println("account =====" + address);
        WalletBean bean = new WalletBean();
        bean.setCoin_type("BTC");
        bean.setMnemonic(BTCWalletUtil.getMnemonic(ds));
        bean.setAddress(address);
        bean.setKeystore("");
        bean.setPrivateKey(privateKeyAsWiF);
        return bean;
    }

    public static ECKeyPair getEcKeyPairByDeterministicSeed(String path, DeterministicSeed ds) {
        String[] pathArray = path.split("/");
        byte[] seedBytes = ds.getSeedBytes();
        if (seedBytes == null) {
            return null;
        }
        DeterministicKey dkKey = HDKeyDerivation.createMasterPrivateKey((byte[])seedBytes);
        for (int i = 1; i < pathArray.length; ++i) {
            ChildNumber childNumber;
            int number;
            if (pathArray[i].endsWith("'")) {
                number = Integer.parseInt(pathArray[i].substring(0, pathArray[i].length() - 1));
                childNumber = new ChildNumber(number, true);
            } else {
                number = Integer.parseInt(pathArray[i]);
                childNumber = new ChildNumber(number, false);
            }
            dkKey = HDKeyDerivation.deriveChildKey((DeterministicKey)dkKey, (ChildNumber)childNumber);
        }
        ECKeyPair keyPair = ECKeyPair.create((byte[])dkKey.getPrivKeyBytes());
        return keyPair;
    }

    public static DeterministicKey getPrivateBySeed(String path, DeterministicSeed ds) {
        String[] pathArray = path.split("/");
        byte[] seedBytes = ds.getSeedBytes();
        if (seedBytes == null) {
            return null;
        }
        DeterministicKey dkKey = HDKeyDerivation.createMasterPrivateKey((byte[])seedBytes);
        for (int i = 1; i < pathArray.length; ++i) {
            ChildNumber childNumber;
            int number;
            if (pathArray[i].endsWith("'")) {
                number = Integer.parseInt(pathArray[i].substring(0, pathArray[i].length() - 1));
                childNumber = new ChildNumber(number, true);
            } else {
                number = Integer.parseInt(pathArray[i]);
                childNumber = new ChildNumber(number, false);
            }
            dkKey = HDKeyDerivation.deriveChildKey((DeterministicKey)dkKey, (ChildNumber)childNumber);
        }
        return dkKey;
    }

    public static DeterministicSeed getDeterministicSeed(List<String> list) {
        try {
            long creationTimeSeconds = System.currentTimeMillis() / 1000L;
            return new DeterministicSeed(list, null, "", creationTimeSeconds);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getPrivateKeyHex(List<String> list) {
        try {
            long creationTimeSeconds = System.currentTimeMillis() / 1000L;
            DeterministicSeed seed = new DeterministicSeed(list, null, "", creationTimeSeconds);
            ECKeyPair keyPair = BTCWalletUtil.getEcKeyPairByDeterministicSeed("m/44'/1'/0'/0/0", seed);
            if (keyPair == null) {
                return null;
            }
            ECKey ecKey = ECKey.fromPrivate((BigInteger)keyPair.getPrivateKey());
            String hexPrivateKey = ecKey.getPrivateKeyAsHex();
            return hexPrivateKey;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getMnemonic(DeterministicSeed ds) {
        StringBuilder sb = new StringBuilder();
        List mnemonicList = ds.getMnemonicCode();
        for (int i = 0; mnemonicList != null && i < mnemonicList.size(); ++i) {
            sb.append((String)mnemonicList.get(i) + " ");
        }
        return sb.toString().trim();
    }

    public static boolean isBTCValidAddress(String input) {
        if (StringUtils.isEmpty((CharSequence)input)) {
            return false;
        }
        try {
            MainNetParams networkParameters = null;
            networkParameters = MainNetParams.get();
            Address address = Address.fromBase58((NetworkParameters)networkParameters, (String)input);
            return address != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

