/*
 * Decompiled with CFR 0.152.
 */
package com.tokenview.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tokenview.utils.HttpClientUtils;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    private String get(String url) {
        return HttpClientUtils.get(url, new HashMap<String, String>());
    }

    public JSONObject getTransactionDetail(String tx) {
        StringBuffer url = new StringBuffer("https://chain.api.btc.com/v3/tx/");
        url.append(tx);
        url.append("?verbose=3");
        String result = null;
        try {
            result = this.get(url.toString());
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
        }
        return JSONObject.parseObject((String)result);
    }

    public JSONArray getUnspent(String txid, List<String> addrList) {
        JSONObject result = new HttpUtil().getTransactionDetail(txid).getJSONObject("data");
        long height = result.getLong("block_height");
        JSONArray outputsArray = result.getJSONArray("outputs");
        JSONArray unspents = new JSONArray();
        int index = 0;
        for (Object o : outputsArray) {
            Object io = JSONObject.parseObject((String)o.toString()).get((Object)"addresses");
            String address = String.valueOf(io).replace("[\"", "").replace("\"]", "");
            if (addrList.contains(address)) {
                JSONObject txJson = JSONObject.parseObject((String)o.toString());
                txJson.put("txid", (Object)txid);
                txJson.put("tx_output_n", (Object)index);
                txJson.put("block_height", (Object)height);
                unspents.add((Object)txJson);
            }
            ++index;
        }
        log.info(JSON.toJSONString((Object)unspents));
        return unspents;
    }
}

