/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.By;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elements.AbstractComponentElement;
import com.vaadin.testbench.elements.AbstractDateFieldElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

@ServerClass(value="com.vaadin.ui.DateField")
public class DateFieldElement
extends AbstractDateFieldElement {
    public void clear() {
        this.getInputElement().clear();
    }

    public String getValue() {
        return this.getInputElement().getAttribute("value");
    }

    public void setValue(CharSequence chars) throws AbstractComponentElement.ReadOnlyException {
        if (this.isReadOnly()) {
            throw new AbstractComponentElement.ReadOnlyException();
        }
        WebElement elem = this.getInputElement();
        TestBenchElement tbElement = (TestBenchElement)elem;
        this.clearElementClientSide((WebElement)tbElement);
        tbElement.sendKeys(new CharSequence[]{chars});
        tbElement.sendKeys(new CharSequence[]{Keys.TAB});
    }

    public void openPopup() {
        this.findElement(By.tagName((String)"button")).click();
    }

    public void setDate(LocalDate value) {
        this.setISOValue(value.format(this.getISOFormatter()));
    }

    public LocalDate getDate() {
        String value = this.getISOValue();
        if (value == null) {
            return null;
        }
        return LocalDate.parse(value, this.getISOFormatter());
    }

    protected DateTimeFormatter getISOFormatter() {
        return DateTimeFormatter.ISO_LOCAL_DATE;
    }

    public WebElement getInputElement() {
        return this.findElement(By.tagName((String)"input"));
    }
}

