/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.elements.AbstractComponentElement;
import com.vaadin.testbench.elements.TreeGridElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@ServerClass(value="com.vaadin.ui.Tree")
public class TreeElement
extends AbstractComponentElement {
    public void expand(int index) {
        if (this.isExpanded(index)) {
            throw new IllegalStateException("The element at row " + index + " was expanded already");
        }
        this.getExpandElement(index).click();
    }

    public boolean isExpanded(int index) {
        WebElement expandElement = this.getExpandElement(index);
        List<String> classes = Arrays.asList(expandElement.getAttribute("class").split(" "));
        return classes.contains("expanded") && !classes.contains("collapsed");
    }

    public boolean isCollapsed(int rowIndex) {
        return !this.isExpanded(rowIndex);
    }

    public WebElement getExpandElement(int rowIndex) {
        return this.asTreeGrid().getCell(rowIndex, 0).findElement(By.className((String)"v-tree8-expander"));
    }

    public void collapse(int index) {
        if (this.isCollapsed(index)) {
            throw new IllegalStateException("The element at row " + index + " was collapsed already");
        }
        this.getExpandElement(index).click();
    }

    public List<TestBenchElement> getAllItems() {
        return this.asTreeGrid().getBody().findElements(By.tagName((String)"tr")).stream().map(this::findCellContentFromRow).collect(Collectors.toList());
    }

    public TestBenchElement getItem(int index) {
        return this.findCellContentFromRow((WebElement)this.asTreeGrid().getRow(index));
    }

    protected TestBenchElement findCellContentFromRow(WebElement rowElement) {
        return TestBenchElement.wrapElement((WebElement)rowElement.findElement(By.className((String)"gwt-HTML")), (TestBenchCommandExecutor)this.getCommandExecutor());
    }

    protected TreeGridElement asTreeGrid() {
        return (TreeGridElement)this.wrap(TreeGridElement.class);
    }
}

