/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.dialect;

import com.ververica.cdc.connectors.base.config.JdbcSourceConfig;
import com.ververica.cdc.connectors.base.dialect.DataSourceDialect;
import com.ververica.cdc.connectors.base.relational.connection.JdbcConnectionFactory;
import com.ververica.cdc.connectors.base.relational.connection.JdbcConnectionPoolFactory;
import com.ververica.cdc.connectors.base.source.meta.split.SourceSplitBase;
import com.ververica.cdc.connectors.base.source.reader.external.FetchTask;
import com.ververica.cdc.connectors.base.source.reader.external.JdbcSourceFetchTaskContext;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.util.FlinkRuntimeException;

@Experimental
public interface JdbcDataSourceDialect
extends DataSourceDialect<JdbcSourceConfig> {
    @Override
    public List<TableId> discoverDataCollections(JdbcSourceConfig var1);

    @Override
    public Map<TableId, TableChanges.TableChange> discoverDataCollectionSchemas(JdbcSourceConfig var1);

    default public JdbcConnection openJdbcConnection(JdbcSourceConfig sourceConfig) {
        JdbcConnection jdbc = new JdbcConnection(sourceConfig.getDbzConfiguration(), new JdbcConnectionFactory(sourceConfig, this.getPooledDataSourceFactory()));
        try {
            jdbc.connect();
        }
        catch (Exception e2) {
            throw new FlinkRuntimeException((Throwable)e2);
        }
        return jdbc;
    }

    public JdbcConnectionPoolFactory getPooledDataSourceFactory();

    public TableChanges.TableChange queryTableSchema(JdbcConnection var1, TableId var2);

    @Override
    public FetchTask<SourceSplitBase> createFetchTask(SourceSplitBase var1);

    public JdbcSourceFetchTaskContext createFetchTaskContext(SourceSplitBase var1, JdbcSourceConfig var2);
}

