/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.source.reader.external;

import com.ververica.cdc.connectors.base.config.JdbcSourceConfig;
import com.ververica.cdc.connectors.base.config.SourceConfig;
import com.ververica.cdc.connectors.base.dialect.JdbcDataSourceDialect;
import com.ververica.cdc.connectors.base.relational.JdbcSourceEventDispatcher;
import com.ververica.cdc.connectors.base.source.reader.external.FetchTask;
import com.ververica.cdc.connectors.base.utils.SourceRecordUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.data.Envelope;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.util.SchemaNameAdjuster;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.table.types.logical.RowType;

public abstract class JdbcSourceFetchTaskContext
implements FetchTask.Context {
    protected final JdbcSourceConfig sourceConfig;
    protected final JdbcDataSourceDialect dataSourceDialect;
    protected final CommonConnectorConfig dbzConnectorConfig;
    protected final SchemaNameAdjuster schemaNameAdjuster;

    public JdbcSourceFetchTaskContext(JdbcSourceConfig sourceConfig, JdbcDataSourceDialect dataSourceDialect) {
        this.sourceConfig = sourceConfig;
        this.dataSourceDialect = dataSourceDialect;
        this.dbzConnectorConfig = sourceConfig.getDbzConnectorConfig();
        this.schemaNameAdjuster = SchemaNameAdjuster.create();
    }

    @Override
    public TableId getTableId(SourceRecord record) {
        return null;
    }

    @Override
    public boolean isDataChangeRecord(SourceRecord record) {
        return false;
    }

    @Override
    public boolean isRecordBetween(SourceRecord record, Object[] splitStart, Object[] splitEnd) {
        RowType splitKeyType = this.getSplitType(this.getDatabaseSchema().tableFor(SourceRecordUtils.getTableId(record)));
        Object[] key = SourceRecordUtils.getSplitKey(splitKeyType, record, this.getSchemaNameAdjuster());
        return SourceRecordUtils.splitKeyRangeContains(key, splitStart, splitEnd);
    }

    @Override
    public void rewriteOutputBuffer(Map<Struct, SourceRecord> outputBuffer, SourceRecord changeRecord) {
        Struct key = (Struct)changeRecord.key();
        Struct value = (Struct)changeRecord.value();
        if (value != null) {
            Envelope.Operation operation = Envelope.Operation.forCode(value.getString("op"));
            switch (operation) {
                case CREATE: 
                case UPDATE: {
                    Envelope envelope = Envelope.fromSchema(changeRecord.valueSchema());
                    Struct source = value.getStruct("source");
                    Struct after = value.getStruct("after");
                    Instant fetchTs = Instant.ofEpochMilli((Long)source.get("ts_ms"));
                    SourceRecord record = new SourceRecord(changeRecord.sourcePartition(), changeRecord.sourceOffset(), changeRecord.topic(), changeRecord.kafkaPartition(), changeRecord.keySchema(), changeRecord.key(), changeRecord.valueSchema(), envelope.read(after, source, fetchTs));
                    outputBuffer.put(key, record);
                    break;
                }
                case DELETE: {
                    outputBuffer.remove(key);
                    break;
                }
                case READ: {
                    throw new IllegalStateException(String.format("Data change record shouldn't use READ operation, the the record is %s.", changeRecord));
                }
            }
        }
    }

    @Override
    public List<SourceRecord> formatMessageTimestamp(Collection<SourceRecord> snapshotRecords) {
        return snapshotRecords.stream().map(record -> {
            Envelope envelope = Envelope.fromSchema(record.valueSchema());
            Struct value = (Struct)record.value();
            Struct updateAfter = value.getStruct("after");
            Struct source = value.getStruct("source");
            source.put("ts_ms", (Object)0L);
            Instant fetchTs = Instant.ofEpochMilli(value.getInt64("ts_ms"));
            SourceRecord sourceRecord = new SourceRecord(record.sourcePartition(), record.sourceOffset(), record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), envelope.read(updateAfter, source, fetchTs));
            return sourceRecord;
        }).collect(Collectors.toList());
    }

    public SourceConfig getSourceConfig() {
        return this.sourceConfig;
    }

    public JdbcDataSourceDialect getDataSourceDialect() {
        return this.dataSourceDialect;
    }

    public CommonConnectorConfig getDbzConnectorConfig() {
        return this.dbzConnectorConfig;
    }

    public SchemaNameAdjuster getSchemaNameAdjuster() {
        return null;
    }

    public abstract RelationalDatabaseSchema getDatabaseSchema();

    public abstract RowType getSplitType(Table var1);

    public abstract ErrorHandler getErrorHandler();

    public abstract JdbcSourceEventDispatcher getDispatcher();

    public abstract OffsetContext getOffsetContext();
}

