/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oracle.source;

import com.ververica.cdc.connectors.base.config.JdbcSourceConfig;
import com.ververica.cdc.connectors.base.relational.connection.JdbcConnectionPoolFactory;
import com.ververica.cdc.connectors.oracle.source.config.OracleSourceConfig;
import org.apache.commons.lang3.StringUtils;

public class OraclePooledDataSourceFactory
extends JdbcConnectionPoolFactory {
    public static final String JDBC_URL_PATTERN = "jdbc:oracle:thin:@%s:%s:%s";

    @Override
    public String getJdbcUrl(JdbcSourceConfig sourceConfig) {
        OracleSourceConfig oracleSourceConfig = (OracleSourceConfig)sourceConfig;
        if (StringUtils.isNotBlank((CharSequence)oracleSourceConfig.getUrl())) {
            return oracleSourceConfig.getUrl();
        }
        String hostName = sourceConfig.getHostname();
        int port = sourceConfig.getPort();
        String database = sourceConfig.getDatabaseList().get(0);
        return String.format(JDBC_URL_PATTERN, hostName, port, database);
    }
}

