/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oracle.source.utils;

import io.debezium.relational.Column;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;

public class OracleTypeUtils {
    public static DataType fromDbzColumn(Column column) {
        DataType dataType = OracleTypeUtils.convertFromColumn(column);
        if (column.isOptional()) {
            return dataType;
        }
        return (DataType)dataType.notNull();
    }

    private static DataType convertFromColumn(Column column) {
        switch (column.jdbcType()) {
            case -15: 
            case -9: 
            case 1: 
            case 12: 
            case 2002: 
            case 2005: {
                return DataTypes.STRING();
            }
            case 2004: {
                return DataTypes.BYTES();
            }
            case -6: 
            case 4: 
            case 5: {
                return DataTypes.INT();
            }
            case 6: 
            case 7: 
            case 100: {
                return DataTypes.FLOAT();
            }
            case 8: 
            case 101: {
                return DataTypes.DOUBLE();
            }
            case 2: 
            case 3: {
                return DataTypes.DECIMAL((int)column.length(), (int)column.scale().orElse(0));
            }
            case 91: {
                return DataTypes.DATE();
            }
            case -102: 
            case -101: 
            case 93: 
            case 2014: {
                return column.length() >= 0 ? DataTypes.TIMESTAMP((int)column.length()) : DataTypes.TIMESTAMP();
            }
            case -103: {
                return DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR(), (DataTypes.Resolution)DataTypes.MONTH());
            }
            case -104: {
                return DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY(), (DataTypes.Resolution)DataTypes.SECOND());
            }
            case 16: {
                return DataTypes.BOOLEAN();
            }
        }
        throw new UnsupportedOperationException(String.format("Don't support Oracle type '%s' yet, jdbcType:'%s'.", column.typeName(), column.jdbcType()));
    }
}

