/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oracle.source.utils;

import com.ververica.cdc.connectors.base.utils.SourceRecordUtils;
import com.ververica.cdc.connectors.oracle.source.meta.offset.RedoLogOffset;
import com.ververica.cdc.connectors.oracle.source.utils.OracleConnectionUtils;
import com.ververica.cdc.connectors.oracle.source.utils.OracleTypeUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleTopicSelector;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.StreamingAdapter;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;

public class OracleUtils {
    private OracleUtils() {
    }

    public static Object[] queryMinMax(JdbcConnection jdbc, TableId tableId, String columnName) throws SQLException {
        String minMaxQuery = String.format("SELECT MIN(%s), MAX(%s) FROM %s", OracleUtils.quote(columnName), OracleUtils.quote(columnName), OracleUtils.quoteSchemaAndTable(tableId));
        return jdbc.queryAndMap(minMaxQuery, rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", minMaxQuery));
            }
            return SourceRecordUtils.rowToArray(rs, 2);
        });
    }

    public static long queryApproximateRowCnt(JdbcConnection jdbc, TableId tableId) throws SQLException {
        String analyzeTable = String.format("analyze table %s compute statistics for table", OracleUtils.quoteSchemaAndTable(tableId));
        String rowCountQuery = String.format("select NUM_ROWS from all_tables where TABLE_NAME = '%s'", tableId.table());
        return jdbc.execute(analyzeTable).queryAndMap(rowCountQuery, rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", rowCountQuery));
            }
            return rs.getLong(1);
        });
    }

    public static Object queryMin(JdbcConnection jdbc, TableId tableId, String columnName, Object excludedLowerBound) throws SQLException {
        String minQuery = String.format("SELECT MIN(%s) FROM %s WHERE %s > ?", OracleUtils.quote(columnName), OracleUtils.quoteSchemaAndTable(tableId), OracleUtils.quote(columnName));
        return jdbc.prepareQueryAndMap(minQuery, ps -> ps.setObject(1, excludedLowerBound), rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", minQuery));
            }
            return rs.getObject(1);
        });
    }

    public static Object queryNextChunkMax(JdbcConnection jdbc, TableId tableId, String splitColumnName, int chunkSize, Object includedLowerBound) throws SQLException {
        String quotedColumn = OracleUtils.quote(splitColumnName);
        String query = String.format("SELECT MAX(%s) FROM (SELECT %s FROM %s WHERE %s >= ? ORDER BY %s ASC ) WHERE ROWNUM <= %s", quotedColumn, quotedColumn, OracleUtils.quoteSchemaAndTable(tableId), quotedColumn, quotedColumn, chunkSize);
        return jdbc.prepareQueryAndMap(query, ps -> ps.setObject(1, includedLowerBound), rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", query));
            }
            return rs.getObject(1);
        });
    }

    public static String buildSplitScanQuery(TableId tableId, RowType pkRowType, boolean isFirstSplit, boolean isLastSplit) {
        return OracleUtils.buildSplitQuery(tableId, pkRowType, isFirstSplit, isLastSplit, -1, true);
    }

    private static String buildSplitQuery(TableId tableId, RowType pkRowType, boolean isFirstSplit, boolean isLastSplit, int limitSize, boolean isScanningData) {
        StringBuilder sql;
        String condition;
        if (isFirstSplit && isLastSplit) {
            condition = null;
        } else if (isFirstSplit) {
            sql = new StringBuilder();
            OracleUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " <= ?");
            if (isScanningData) {
                sql.append(" AND NOT (");
                OracleUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " = ?");
                sql.append(")");
            }
            condition = sql.toString();
        } else if (isLastSplit) {
            sql = new StringBuilder();
            OracleUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " >= ?");
            condition = sql.toString();
        } else {
            sql = new StringBuilder();
            OracleUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " >= ?");
            if (isScanningData) {
                sql.append(" AND NOT (");
                OracleUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " = ?");
                sql.append(")");
            }
            sql.append(" AND ");
            OracleUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " <= ?");
            condition = sql.toString();
        }
        if (isScanningData) {
            return OracleUtils.buildSelectWithRowLimits(tableId, limitSize, "*", Optional.ofNullable(condition), Optional.empty());
        }
        String orderBy = pkRowType.getFieldNames().stream().collect(Collectors.joining(", "));
        return OracleUtils.buildSelectWithBoundaryRowLimits(tableId, limitSize, OracleUtils.getPrimaryKeyColumnsProjection(pkRowType), OracleUtils.getMaxPrimaryKeyColumnsProjection(pkRowType), Optional.ofNullable(condition), orderBy);
    }

    public static PreparedStatement readTableSplitDataStatement(JdbcConnection jdbc, String sql, boolean isFirstSplit, boolean isLastSplit, Object[] splitStart, Object[] splitEnd, int primaryKeyNum, int fetchSize) {
        try {
            PreparedStatement statement = OracleUtils.initStatement(jdbc, sql, fetchSize);
            if (isFirstSplit && isLastSplit) {
                return statement;
            }
            if (isFirstSplit) {
                for (int i2 = 0; i2 < primaryKeyNum; ++i2) {
                    statement.setObject(i2 + 1, splitEnd[i2]);
                    statement.setObject(i2 + 1 + primaryKeyNum, splitEnd[i2]);
                }
            } else if (isLastSplit) {
                for (int i3 = 0; i3 < primaryKeyNum; ++i3) {
                    statement.setObject(i3 + 1, splitStart[i3]);
                }
            } else {
                for (int i4 = 0; i4 < primaryKeyNum; ++i4) {
                    statement.setObject(i4 + 1, splitStart[i4]);
                    statement.setObject(i4 + 1 + primaryKeyNum, splitEnd[i4]);
                    statement.setObject(i4 + 1 + 2 * primaryKeyNum, splitEnd[i4]);
                }
            }
            return statement;
        }
        catch (Exception e2) {
            throw new RuntimeException("Failed to build the split data read statement.", e2);
        }
    }

    public static RowType getSplitType(Table table) {
        List<Column> primaryKeys = table.primaryKeyColumns();
        if (primaryKeys.isEmpty()) {
            throw new ValidationException(String.format("Incremental snapshot for tables requires primary key, but table %s doesn't have primary key.", table.id()));
        }
        return OracleUtils.getSplitType(primaryKeys.get(0));
    }

    public static OracleDatabaseSchema createOracleDatabaseSchema(OracleConnectorConfig dbzOracleConfig) {
        TopicSelector<TableId> topicSelector = OracleTopicSelector.defaultSelector(dbzOracleConfig);
        SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create();
        OracleConnection oracleConnection = OracleConnectionUtils.createOracleConnection(dbzOracleConfig.getJdbcConfig());
        OracleValueConverters oracleValueConverters = new OracleValueConverters(dbzOracleConfig, oracleConnection);
        StreamingAdapter.TableNameCaseSensitivity tableNameCaseSensitivity = dbzOracleConfig.getAdapter().getTableNameCaseSensitivity(oracleConnection);
        return new OracleDatabaseSchema(dbzOracleConfig, oracleValueConverters, schemaNameAdjuster, topicSelector, tableNameCaseSensitivity);
    }

    public static OracleDatabaseSchema createOracleDatabaseSchema(OracleConnectorConfig dbzOracleConfig, boolean tableIdCaseInsensitive) {
        TopicSelector<TableId> topicSelector = OracleTopicSelector.defaultSelector(dbzOracleConfig);
        SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create();
        OracleConnection oracleConnection = OracleConnectionUtils.createOracleConnection((Configuration)((Object)dbzOracleConfig));
        OracleValueConverters oracleValueConverters = new OracleValueConverters(dbzOracleConfig, oracleConnection);
        StreamingAdapter.TableNameCaseSensitivity tableNameCaseSensitivity = tableIdCaseInsensitive ? StreamingAdapter.TableNameCaseSensitivity.SENSITIVE : StreamingAdapter.TableNameCaseSensitivity.INSENSITIVE;
        return new OracleDatabaseSchema(dbzOracleConfig, oracleValueConverters, schemaNameAdjuster, topicSelector, tableNameCaseSensitivity);
    }

    public static RedoLogOffset getRedoLogPosition(SourceRecord dataRecord) {
        return OracleUtils.getRedoLogPosition(dataRecord.sourceOffset());
    }

    public static RedoLogOffset getRedoLogPosition(Map<String, ?> offset) {
        HashMap<String, String> offsetStrMap = new HashMap<String, String>();
        for (Map.Entry<String, ?> entry : offset.entrySet()) {
            offsetStrMap.put(entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
        }
        return new RedoLogOffset(offsetStrMap);
    }

    public static RowType getSplitType(Column splitColumn) {
        return (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)splitColumn.name(), (DataType)OracleTypeUtils.fromDbzColumn(splitColumn))}).getLogicalType();
    }

    public static Column getSplitColumn(Table table) {
        List<Column> primaryKeys = table.primaryKeyColumns();
        if (primaryKeys.isEmpty()) {
            throw new ValidationException(String.format("Incremental snapshot for tables requires primary key, but table %s doesn't have primary key.", table.id()));
        }
        return primaryKeys.get(0);
    }

    public static String quote(String dbOrTableName) {
        return "\"" + dbOrTableName + "\"";
    }

    public static String quoteSchemaAndTable(TableId tableId) {
        StringBuilder quoted = new StringBuilder();
        if (tableId.schema() != null && !tableId.schema().isEmpty()) {
            quoted.append(OracleUtils.quote(tableId.schema())).append(".");
        }
        quoted.append(OracleUtils.quote(tableId.table()));
        return quoted.toString();
    }

    private static PreparedStatement initStatement(JdbcConnection jdbc, String sql, int fetchSize) throws SQLException {
        Connection connection = jdbc.connection();
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setFetchSize(fetchSize);
        return statement;
    }

    private static void addPrimaryKeyColumnsToCondition(RowType pkRowType, StringBuilder sql, String predicate) {
        Iterator fieldNamesIt = pkRowType.getFieldNames().iterator();
        while (fieldNamesIt.hasNext()) {
            sql.append((String)fieldNamesIt.next()).append(predicate);
            if (!fieldNamesIt.hasNext()) continue;
            sql.append(" AND ");
        }
    }

    private static String getPrimaryKeyColumnsProjection(RowType pkRowType) {
        StringBuilder sql = new StringBuilder();
        Iterator fieldNamesIt = pkRowType.getFieldNames().iterator();
        while (fieldNamesIt.hasNext()) {
            sql.append((String)fieldNamesIt.next());
            if (!fieldNamesIt.hasNext()) continue;
            sql.append(" , ");
        }
        return sql.toString();
    }

    private static String getMaxPrimaryKeyColumnsProjection(RowType pkRowType) {
        StringBuilder sql = new StringBuilder();
        Iterator fieldNamesIt = pkRowType.getFieldNames().iterator();
        while (fieldNamesIt.hasNext()) {
            sql.append("MAX(" + (String)fieldNamesIt.next() + ")");
            if (!fieldNamesIt.hasNext()) continue;
            sql.append(" , ");
        }
        return sql.toString();
    }

    private static String buildSelectWithRowLimits(TableId tableId, int limit, String projection, Optional<String> condition, Optional<String> orderBy) {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(projection).append(" FROM ");
        sql.append(OracleUtils.quoteSchemaAndTable(tableId));
        if (condition.isPresent()) {
            sql.append(" WHERE ").append(condition.get());
        }
        if (orderBy.isPresent()) {
            sql.append(" ORDER BY ").append(orderBy.get());
        }
        if (limit > 0) {
            sql.append(" LIMIT ").append(limit);
        }
        return sql.toString();
    }

    private static String buildSelectWithBoundaryRowLimits(TableId tableId, int limit, String projection, String maxColumnProjection, Optional<String> condition, String orderBy) {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(maxColumnProjection);
        sql.append(" FROM (");
        sql.append("SELECT ");
        sql.append(projection);
        sql.append(" FROM ");
        sql.append(OracleUtils.quoteSchemaAndTable(tableId));
        if (condition.isPresent()) {
            sql.append(" WHERE ").append(condition.get());
        }
        sql.append(" ORDER BY ").append(orderBy).append(" LIMIT ").append(limit);
        sql.append(") T");
        return sql.toString();
    }
}

