/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oracle.table;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.debezium.table.DeserializationRuntimeConverter;
import com.ververica.cdc.debezium.table.DeserializationRuntimeConverterFactory;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.data.VariableScaleDecimal;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Optional;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.LogicalType;

public class OracleDeserializationConverterFactory {
    public static DeserializationRuntimeConverterFactory instance() {
        return new DeserializationRuntimeConverterFactory(){
            private static final long serialVersionUID = 1L;

            @Override
            public Optional<DeserializationRuntimeConverter> createUserDefinedConverter(LogicalType logicalType, ZoneId serverTimeZone) {
                return OracleDeserializationConverterFactory.wrapNumericConverter(OracleDeserializationConverterFactory.createNumericConverter(logicalType, serverTimeZone));
            }
        };
    }

    private static Optional<DeserializationRuntimeConverter> createNumericConverter(LogicalType type, ZoneId serverTimeZone) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                return OracleDeserializationConverterFactory.createBooleanConverter();
            }
            case TINYINT: {
                return OracleDeserializationConverterFactory.createByteConverter();
            }
            case SMALLINT: {
                return OracleDeserializationConverterFactory.createShortConverter();
            }
            case INTEGER: {
                return OracleDeserializationConverterFactory.createIntegerConverter();
            }
            case BIGINT: {
                return OracleDeserializationConverterFactory.createLongConverter();
            }
            case FLOAT: {
                return OracleDeserializationConverterFactory.createFloatConverter();
            }
            case DOUBLE: {
                return OracleDeserializationConverterFactory.createDoubleConverter();
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return OracleDeserializationConverterFactory.convertToLocalTimeZoneTimestamp();
            }
        }
        return Optional.empty();
    }

    private static Optional<DeserializationRuntimeConverter> convertToLocalTimeZoneTimestamp() {
        return Optional.of(new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof String) {
                    String str = (String)dbzObj;
                    Instant instant = Instant.parse(str);
                    return TimestampData.fromInstant((Instant)instant);
                }
                throw new IllegalArgumentException("Unable to convert to TimestampData from unexpected value '" + dbzObj + "' of type " + dbzObj.getClass().getName());
            }
        });
    }

    private static Optional<DeserializationRuntimeConverter> wrapNumericConverter(Optional<DeserializationRuntimeConverter> converterOptional) {
        return converterOptional.map(converter -> new DeserializationRuntimeConverter((DeserializationRuntimeConverter)converter){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ DeserializationRuntimeConverter val$converter;
            {
                this.val$converter = deserializationRuntimeConverter;
            }

            @Override
            public Object convert(Object dbzObj, Schema schema) throws Exception {
                if ("io.debezium.data.VariableScaleDecimal".equals(schema.name())) {
                    SpecialValueDecimal decimal = VariableScaleDecimal.toLogical((Struct)dbzObj);
                    return this.val$converter.convert(decimal.getDecimalValue().orElse(BigDecimal.ZERO), schema);
                }
                return this.val$converter.convert(dbzObj, schema);
            }
        });
    }

    private static Optional<DeserializationRuntimeConverter> createBooleanConverter() {
        return Optional.of(new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Boolean) {
                    return dbzObj;
                }
                if (dbzObj instanceof Byte) {
                    return (Byte)dbzObj != 0;
                }
                if (dbzObj instanceof Short) {
                    return (Short)dbzObj != 0;
                }
                if (dbzObj instanceof BigDecimal) {
                    return ((BigDecimal)dbzObj).shortValue() != 0;
                }
                return Boolean.parseBoolean(dbzObj.toString());
            }
        });
    }

    private static Optional<DeserializationRuntimeConverter> createByteConverter() {
        return Optional.of(new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Byte) {
                    return dbzObj;
                }
                if (dbzObj instanceof BigDecimal) {
                    return ((BigDecimal)dbzObj).byteValue();
                }
                return Byte.parseByte(dbzObj.toString());
            }
        });
    }

    private static Optional<DeserializationRuntimeConverter> createShortConverter() {
        return Optional.of(new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Byte) {
                    return ((Byte)dbzObj).shortValue();
                }
                if (dbzObj instanceof Short) {
                    return dbzObj;
                }
                if (dbzObj instanceof BigDecimal) {
                    return ((BigDecimal)dbzObj).shortValue();
                }
                return Short.parseShort(dbzObj.toString());
            }
        });
    }

    private static Optional<DeserializationRuntimeConverter> createIntegerConverter() {
        return Optional.of(new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Integer) {
                    return dbzObj;
                }
                if (dbzObj instanceof Long) {
                    return ((Long)dbzObj).intValue();
                }
                if (dbzObj instanceof BigDecimal) {
                    return ((BigDecimal)dbzObj).intValue();
                }
                return Integer.parseInt(dbzObj.toString());
            }
        });
    }

    private static Optional<DeserializationRuntimeConverter> createLongConverter() {
        return Optional.of(new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Integer) {
                    return ((Integer)dbzObj).longValue();
                }
                if (dbzObj instanceof Long) {
                    return dbzObj;
                }
                if (dbzObj instanceof BigDecimal) {
                    return ((BigDecimal)dbzObj).longValue();
                }
                return Long.parseLong(dbzObj.toString());
            }
        });
    }

    private static Optional<DeserializationRuntimeConverter> createFloatConverter() {
        return Optional.of(new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Float) {
                    return dbzObj;
                }
                if (dbzObj instanceof Double) {
                    return Float.valueOf(((Double)dbzObj).floatValue());
                }
                if (dbzObj instanceof BigDecimal) {
                    return Float.valueOf(((BigDecimal)dbzObj).floatValue());
                }
                return Float.valueOf(Float.parseFloat(dbzObj.toString()));
            }
        });
    }

    private static Optional<DeserializationRuntimeConverter> createDoubleConverter() {
        return Optional.of(new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Float) {
                    return ((Float)dbzObj).doubleValue();
                }
                if (dbzObj instanceof Double) {
                    return dbzObj;
                }
                if (dbzObj instanceof BigDecimal) {
                    return ((BigDecimal)dbzObj).doubleValue();
                }
                return Double.parseDouble(dbzObj.toString());
            }
        });
    }
}

