/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression;

import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.AnalyticType;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.Expression;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.ExpressionVisitor;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.Function;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.KeepExpression;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.OrderByClause;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.PartitionByClause;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.WindowElement;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.OrderByElement;
import java.util.List;

public class AnalyticExpression
extends ASTNodeAccessImpl
implements Expression {
    private final OrderByClause orderBy = new OrderByClause();
    private final PartitionByClause partitionBy = new PartitionByClause();
    private String name;
    private Expression expression;
    private Expression offset;
    private Expression defaultValue;
    private boolean allColumns = false;
    private KeepExpression keep = null;
    private AnalyticType type = AnalyticType.OVER;
    private boolean distinct = false;
    private boolean ignoreNulls = false;

    public AnalyticExpression() {
    }

    public AnalyticExpression(Function function) {
        this.name = function.getName();
        this.allColumns = function.isAllColumns();
        this.distinct = function.isDistinct();
        ExpressionList list = function.getParameters();
        if (list != null) {
            if (list.getExpressions().size() > 3) {
                throw new IllegalArgumentException("function object not valid to initialize analytic expression");
            }
            this.expression = list.getExpressions().get(0);
            if (list.getExpressions().size() > 1) {
                this.offset = list.getExpressions().get(1);
            }
            if (list.getExpressions().size() > 2) {
                this.defaultValue = list.getExpressions().get(2);
            }
        }
        this.ignoreNulls = function.isIgnoreNulls();
        this.keep = function.getKeep();
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderBy.getOrderByElements();
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderBy.setOrderByElements(orderByElements);
    }

    public KeepExpression getKeep() {
        return this.keep;
    }

    public void setKeep(KeepExpression keep) {
        this.keep = keep;
    }

    public ExpressionList getPartitionExpressionList() {
        return this.partitionBy.getPartitionExpressionList();
    }

    public void setPartitionExpressionList(ExpressionList partitionExpressionList) {
        this.partitionBy.setPartitionExpressionList(partitionExpressionList);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getOffset() {
        return this.offset;
    }

    public void setOffset(Expression offset) {
        this.offset = offset;
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Expression defaultValue) {
        this.defaultValue = defaultValue;
    }

    public WindowElement getWindowElement() {
        return this.orderBy.getWindowElement();
    }

    public void setWindowElement(WindowElement windowElement) {
        this.orderBy.setWindowElement(windowElement);
    }

    public AnalyticType getType() {
        return this.type;
    }

    public void setType(AnalyticType type) {
        this.type = type;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isIgnoreNulls() {
        return this.ignoreNulls;
    }

    public void setIgnoreNulls(boolean ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder();
        b2.append(this.name).append("(");
        if (this.isDistinct()) {
            b2.append("DISTINCT ");
        }
        if (this.expression != null) {
            b2.append(this.expression.toString());
            if (this.offset != null) {
                b2.append(", ").append(this.offset.toString());
                if (this.defaultValue != null) {
                    b2.append(", ").append(this.defaultValue.toString());
                }
            }
        } else if (this.isAllColumns()) {
            b2.append("*");
        }
        if (this.isIgnoreNulls()) {
            b2.append(" IGNORE NULLS");
        }
        b2.append(") ");
        if (this.keep != null) {
            b2.append(this.keep.toString()).append(" ");
        }
        switch (this.type) {
            case WITHIN_GROUP: {
                b2.append("WITHIN GROUP");
                break;
            }
            default: {
                b2.append("OVER");
            }
        }
        b2.append(" (");
        this.partitionBy.toStringPartitionBy(b2);
        this.orderBy.toStringOrderByElements(b2);
        b2.append(")");
        return b2.toString();
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(boolean allColumns) {
        this.allColumns = allColumns;
    }
}

