/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.alter;

import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.alter.AlterOperation;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.alter.ConstraintState;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.create.table.ColDataType;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.create.table.Index;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AlterExpression {
    private AlterOperation operation;
    private String optionalSpecifier;
    private String columnName;
    private String columnOldName;
    private List<ColumnDataType> colDataTypeList;
    private List<String> pkColumns;
    private List<String> ukColumns;
    private String ukName;
    private Index index = null;
    private String constraintName;
    private boolean constraintIfExists;
    private boolean onDeleteRestrict;
    private boolean onDeleteSetNull;
    private boolean onDeleteCascade;
    private List<String> fkColumns;
    private String fkSourceTable;
    private List<String> fkSourceColumns;
    private boolean uk;
    private boolean useEqual;
    private List<ConstraintState> constraints;
    private List<String> parameters;

    public AlterOperation getOperation() {
        return this.operation;
    }

    public void setOperation(AlterOperation operation) {
        this.operation = operation;
    }

    public String getOptionalSpecifier() {
        return this.optionalSpecifier;
    }

    public void setOptionalSpecifier(String optionalSpecifier) {
        this.optionalSpecifier = optionalSpecifier;
    }

    public boolean isOnDeleteCascade() {
        return this.onDeleteCascade;
    }

    public void setOnDeleteCascade(boolean onDeleteCascade) {
        this.onDeleteCascade = onDeleteCascade;
    }

    public boolean isOnDeleteRestrict() {
        return this.onDeleteRestrict;
    }

    public void setOnDeleteRestrict(boolean onDeleteRestrict) {
        this.onDeleteRestrict = onDeleteRestrict;
    }

    public boolean isOnDeleteSetNull() {
        return this.onDeleteSetNull;
    }

    public void setOnDeleteSetNull(boolean onDeleteSetNull) {
        this.onDeleteSetNull = onDeleteSetNull;
    }

    public List<String> getFkColumns() {
        return this.fkColumns;
    }

    public void setFkColumns(List<String> fkColumns) {
        this.fkColumns = fkColumns;
    }

    public String getFkSourceTable() {
        return this.fkSourceTable;
    }

    public void setFkSourceTable(String fkSourceTable) {
        this.fkSourceTable = fkSourceTable;
    }

    public List<ColumnDataType> getColDataTypeList() {
        return this.colDataTypeList;
    }

    public void addColDataType(String columnName, ColDataType colDataType) {
        this.addColDataType(new ColumnDataType(columnName, false, colDataType, null));
    }

    public void addColDataType(ColumnDataType columnDataType) {
        if (this.colDataTypeList == null) {
            this.colDataTypeList = new ArrayList<ColumnDataType>();
        }
        this.colDataTypeList.add(columnDataType);
    }

    public List<String> getFkSourceColumns() {
        return this.fkSourceColumns;
    }

    public void setFkSourceColumns(List<String> fkSourceColumns) {
        this.fkSourceColumns = fkSourceColumns;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColOldName() {
        return this.columnOldName;
    }

    public void setColOldName(String columnOldName) {
        this.columnOldName = columnOldName;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public boolean isConstraintIfExists() {
        return this.constraintIfExists;
    }

    public void setConstraintIfExists(boolean constraintIfExists) {
        this.constraintIfExists = constraintIfExists;
    }

    public List<String> getPkColumns() {
        return this.pkColumns;
    }

    public void setPkColumns(List<String> pkColumns) {
        this.pkColumns = pkColumns;
    }

    public List<String> getUkColumns() {
        return this.ukColumns;
    }

    public void setUkColumns(List<String> ukColumns) {
        this.ukColumns = ukColumns;
    }

    public String getUkName() {
        return this.ukName;
    }

    public void setUkName(String ukName) {
        this.ukName = ukName;
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public List<ConstraintState> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<ConstraintState> constraints) {
        this.constraints = constraints;
    }

    public void addParameters(String ... params) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<String>();
        }
        this.parameters.addAll(Arrays.asList(params));
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public boolean getUseEqual() {
        return this.useEqual;
    }

    public void setUseEqual(boolean useEqual) {
        this.useEqual = useEqual;
    }

    public boolean getUk() {
        return this.uk;
    }

    public void setUk(boolean uk) {
        this.uk = uk;
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder();
        b2.append((Object)this.operation).append(" ");
        if (this.columnName != null) {
            b2.append("COLUMN ").append(this.columnName);
        } else if (this.getColDataTypeList() != null) {
            if (this.operation == AlterOperation.CHANGE) {
                if (this.optionalSpecifier != null) {
                    b2.append(this.optionalSpecifier).append(" ");
                }
                b2.append(this.columnOldName).append(" ");
            } else if (this.colDataTypeList.size() > 1) {
                b2.append("(");
            } else {
                b2.append("COLUMN ");
            }
            b2.append(PlainSelect.getStringList(this.colDataTypeList));
            if (this.colDataTypeList.size() > 1) {
                b2.append(")");
            }
        } else if (this.constraintName != null) {
            b2.append("CONSTRAINT ");
            if (this.constraintIfExists) {
                b2.append("IF EXISTS ");
            }
            b2.append(this.constraintName);
        } else if (this.pkColumns != null) {
            b2.append("PRIMARY KEY (").append(PlainSelect.getStringList(this.pkColumns)).append(')');
        } else if (this.ukColumns != null) {
            b2.append("UNIQUE");
            if (this.ukName != null) {
                if (this.getUk()) {
                    b2.append(" KEY ");
                } else {
                    b2.append(" INDEX ");
                }
                b2.append(this.ukName);
            }
            b2.append(" (").append(PlainSelect.getStringList(this.ukColumns)).append(")");
        } else if (this.fkColumns != null) {
            b2.append("FOREIGN KEY (").append(PlainSelect.getStringList(this.fkColumns)).append(") REFERENCES ").append(this.fkSourceTable).append(" (").append(PlainSelect.getStringList(this.fkSourceColumns)).append(")");
            if (this.isOnDeleteCascade()) {
                b2.append(" ON DELETE CASCADE");
            } else if (this.isOnDeleteRestrict()) {
                b2.append(" ON DELETE RESTRICT");
            } else if (this.isOnDeleteSetNull()) {
                b2.append(" ON DELETE SET NULL");
            }
        } else if (this.index != null) {
            b2.append(this.index);
        }
        if (this.getConstraints() != null && !this.getConstraints().isEmpty()) {
            b2.append(' ').append(PlainSelect.getStringList(this.constraints, false, false));
        }
        if (this.getUseEqual()) {
            b2.append('=');
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            b2.append(' ').append(PlainSelect.getStringList(this.parameters, false, false));
        }
        return b2.toString();
    }

    public static class ColumnDataType {
        private final String columnName;
        private final boolean withType;
        private final ColDataType colDataType;
        private final List<String> columnSpecs;

        public ColumnDataType(String columnName, boolean withType, ColDataType colDataType, List<String> columnSpecs) {
            this.columnName = columnName;
            this.withType = withType;
            this.colDataType = colDataType;
            this.columnSpecs = columnSpecs;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public ColDataType getColDataType() {
            return this.colDataType;
        }

        public List<String> getColumnSpecs() {
            if (this.columnSpecs == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.columnSpecs);
        }

        public String toString() {
            return this.columnName + (this.withType ? " TYPE " : " ") + this.colDataType + this.parametersToString();
        }

        private String parametersToString() {
            if (this.columnSpecs == null || this.columnSpecs.isEmpty()) {
                return "";
            }
            return " " + PlainSelect.getStringList(this.columnSpecs, false, false);
        }
    }
}

