/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select;

import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.Expression;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.expression.OracleHint;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.schema.Table;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.Distinct;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.Fetch;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.First;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.FromItem;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.GroupByElement;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.Join;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.KSQLWindow;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.Limit;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.Offset;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.OptimizeFor;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.OrderByElement;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.SelectBody;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.SelectItem;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.SelectVisitor;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.Skip;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.Top;
import com.ververica.cdc.connectors.shaded.net.sf.jsqlparser.statement.select.Wait;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PlainSelect
extends ASTNodeAccessImpl
implements SelectBody {
    private Distinct distinct = null;
    private List<SelectItem> selectItems;
    private List<Table> intoTables;
    private FromItem fromItem;
    private List<Join> joins;
    private Expression where;
    private GroupByElement groupBy;
    private List<OrderByElement> orderByElements;
    private Expression having;
    private Limit limit;
    private Offset offset;
    private Fetch fetch;
    private OptimizeFor optimizeFor;
    private Skip skip;
    private First first;
    private Top top;
    private OracleHierarchicalExpression oracleHierarchical = null;
    private OracleHint oracleHint = null;
    private boolean oracleSiblings = false;
    private boolean forUpdate = false;
    private Table forUpdateTable = null;
    private boolean useBrackets = false;
    private Wait wait;
    private boolean mySqlSqlCalcFoundRows = false;
    private boolean sqlNoCacheFlag = false;
    private String forXmlPath;
    private KSQLWindow ksqlWindow = null;

    public boolean isUseBrackets() {
        return this.useBrackets;
    }

    public void setUseBrackets(boolean useBrackets) {
        this.useBrackets = useBrackets;
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public List<Table> getIntoTables() {
        return this.intoTables;
    }

    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setFromItem(FromItem item) {
        this.fromItem = item;
    }

    public void setIntoTables(List<Table> intoTables) {
        this.intoTables = intoTables;
    }

    public void setSelectItems(List<SelectItem> list) {
        this.selectItems = list;
    }

    public void addSelectItems(SelectItem ... items) {
        if (this.selectItems == null) {
            this.selectItems = new ArrayList<SelectItem>();
        }
        Collections.addAll(this.selectItems, items);
    }

    public void setWhere(Expression where) {
        this.where = where;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> list) {
        this.joins = list;
    }

    @Override
    public void accept(SelectVisitor selectVisitor) {
        selectVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public Fetch getFetch() {
        return this.fetch;
    }

    public void setFetch(Fetch fetch) {
        this.fetch = fetch;
    }

    public OptimizeFor getOptimizeFor() {
        return this.optimizeFor;
    }

    public void setOptimizeFor(OptimizeFor optimizeFor) {
        this.optimizeFor = optimizeFor;
    }

    public Top getTop() {
        return this.top;
    }

    public void setTop(Top top) {
        this.top = top;
    }

    public Skip getSkip() {
        return this.skip;
    }

    public void setSkip(Skip skip) {
        this.skip = skip;
    }

    public First getFirst() {
        return this.first;
    }

    public void setFirst(First first) {
        this.first = first;
    }

    public Distinct getDistinct() {
        return this.distinct;
    }

    public void setDistinct(Distinct distinct) {
        this.distinct = distinct;
    }

    public Expression getHaving() {
        return this.having;
    }

    public void setHaving(Expression expression) {
        this.having = expression;
    }

    public GroupByElement getGroupBy() {
        return this.groupBy;
    }

    public void setGroupByElement(GroupByElement groupBy) {
        this.groupBy = groupBy;
    }

    public void addGroupByColumnReference(Expression expr) {
        if (this.groupBy == null) {
            this.groupBy = new GroupByElement();
        }
        this.groupBy.addGroupByExpression(expr);
    }

    public OracleHierarchicalExpression getOracleHierarchical() {
        return this.oracleHierarchical;
    }

    public void setOracleHierarchical(OracleHierarchicalExpression oracleHierarchical) {
        this.oracleHierarchical = oracleHierarchical;
    }

    public boolean isOracleSiblings() {
        return this.oracleSiblings;
    }

    public void setOracleSiblings(boolean oracleSiblings) {
        this.oracleSiblings = oracleSiblings;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public Table getForUpdateTable() {
        return this.forUpdateTable;
    }

    public void setForUpdateTable(Table forUpdateTable) {
        this.forUpdateTable = forUpdateTable;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public void setWait(Wait wait) {
        this.wait = wait;
    }

    public Wait getWait() {
        return this.wait;
    }

    public String getForXmlPath() {
        return this.forXmlPath;
    }

    public void setForXmlPath(String forXmlPath) {
        this.forXmlPath = forXmlPath;
    }

    public KSQLWindow getKsqlWindow() {
        return this.ksqlWindow;
    }

    public void setKsqlWindow(KSQLWindow ksqlWindow) {
        this.ksqlWindow = ksqlWindow;
    }

    public String toString() {
        StringBuilder sql = new StringBuilder();
        if (this.useBrackets) {
            sql.append("(");
        }
        sql.append("SELECT ");
        if (this.oracleHint != null) {
            sql.append(this.oracleHint).append(" ");
        }
        if (this.skip != null) {
            sql.append(this.skip).append(" ");
        }
        if (this.first != null) {
            sql.append(this.first).append(" ");
        }
        if (this.distinct != null) {
            sql.append(this.distinct).append(" ");
        }
        if (this.top != null) {
            sql.append(this.top).append(" ");
        }
        if (this.sqlNoCacheFlag) {
            sql.append("SQL_NO_CACHE").append(" ");
        }
        if (this.mySqlSqlCalcFoundRows) {
            sql.append("SQL_CALC_FOUND_ROWS").append(" ");
        }
        sql.append(PlainSelect.getStringList(this.selectItems));
        if (this.intoTables != null) {
            sql.append(" INTO ");
            Iterator<Table> iter = this.intoTables.iterator();
            while (iter.hasNext()) {
                sql.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                sql.append(", ");
            }
        }
        if (this.fromItem != null) {
            sql.append(" FROM ").append(this.fromItem);
            if (this.joins != null) {
                for (Join join : this.joins) {
                    if (join.isSimple()) {
                        sql.append(", ").append(join);
                        continue;
                    }
                    sql.append(" ").append(join);
                }
            }
            if (this.ksqlWindow != null) {
                sql.append(" WINDOW ").append(this.ksqlWindow.toString());
            }
            if (this.where != null) {
                sql.append(" WHERE ").append(this.where);
            }
            if (this.oracleHierarchical != null) {
                sql.append(this.oracleHierarchical.toString());
            }
            if (this.groupBy != null) {
                sql.append(" ").append(this.groupBy.toString());
            }
            if (this.having != null) {
                sql.append(" HAVING ").append(this.having);
            }
            sql.append(PlainSelect.orderByToString(this.oracleSiblings, this.orderByElements));
            if (this.limit != null) {
                sql.append(this.limit);
            }
            if (this.offset != null) {
                sql.append(this.offset);
            }
            if (this.fetch != null) {
                sql.append(this.fetch);
            }
            if (this.isForUpdate()) {
                sql.append(" FOR UPDATE");
                if (this.forUpdateTable != null) {
                    sql.append(" OF ").append(this.forUpdateTable);
                }
                if (this.wait != null) {
                    sql.append(this.wait);
                }
            }
            if (this.optimizeFor != null) {
                sql.append(this.optimizeFor);
            }
        } else if (this.where != null) {
            sql.append(" WHERE ").append(this.where);
        }
        if (this.forXmlPath != null) {
            sql.append(" FOR XML PATH(").append(this.forXmlPath).append(")");
        }
        if (this.useBrackets) {
            sql.append(")");
        }
        return sql.toString();
    }

    public static String orderByToString(List<OrderByElement> orderByElements) {
        return PlainSelect.orderByToString(false, orderByElements);
    }

    public static String orderByToString(boolean oracleSiblings, List<OrderByElement> orderByElements) {
        return PlainSelect.getFormatedList(orderByElements, oracleSiblings ? "ORDER SIBLINGS BY" : "ORDER BY");
    }

    public static String getFormatedList(List<?> list, String expression) {
        return PlainSelect.getFormatedList(list, expression, true, false);
    }

    public static String getFormatedList(List<?> list, String expression, boolean useComma, boolean useBrackets) {
        String sql = PlainSelect.getStringList(list, useComma, useBrackets);
        if (sql.length() > 0) {
            sql = expression.length() > 0 ? " " + expression + " " + sql : " " + sql;
        }
        return sql;
    }

    public static String getStringList(List<?> list) {
        return PlainSelect.getStringList(list, true, false);
    }

    public static String getStringList(List<?> list, boolean useComma, boolean useBrackets) {
        StringBuilder ans = new StringBuilder();
        String comma = ",";
        if (!useComma) {
            comma = "";
        }
        if (list != null) {
            if (useBrackets) {
                ans.append("(");
            }
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ans.append(list.get(i2)).append(i2 < list.size() - 1 ? comma + " " : "");
            }
            if (useBrackets) {
                ans.append(")");
            }
        }
        return ans.toString();
    }

    public void setMySqlSqlCalcFoundRows(boolean mySqlCalcFoundRows) {
        this.mySqlSqlCalcFoundRows = mySqlCalcFoundRows;
    }

    public void setMySqlSqlNoCache(boolean sqlNoCacheFlagSet) {
        this.sqlNoCacheFlag = sqlNoCacheFlagSet;
    }

    public boolean getMySqlSqlCalcFoundRows() {
        return this.mySqlSqlCalcFoundRows;
    }

    public boolean getMySqlSqlNoCache() {
        return this.sqlNoCacheFlag;
    }
}

