/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.ScramCredentialInfo;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.ScramMechanism;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.UserScramCredentialsDescription;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.KafkaFuture;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.annotation.InterfaceStability;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.ResourceNotFoundException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.internals.KafkaFutureImpl;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@InterfaceStability.Evolving
public class DescribeUserScramCredentialsResult {
    private final KafkaFuture<DescribeUserScramCredentialsResponseData> dataFuture;

    DescribeUserScramCredentialsResult(KafkaFuture<DescribeUserScramCredentialsResponseData> dataFuture) {
        this.dataFuture = Objects.requireNonNull(dataFuture);
    }

    public KafkaFuture<Map<String, UserScramCredentialsDescription>> all() {
        KafkaFutureImpl<Map<String, UserScramCredentialsDescription>> retval = new KafkaFutureImpl<Map<String, UserScramCredentialsDescription>>();
        this.dataFuture.whenComplete((data, throwable) -> {
            if (throwable != null) {
                retval.completeExceptionally((Throwable)throwable);
            } else {
                Optional<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> optionalFirstFailedDescribe = data.results().stream().filter(result -> result.errorCode() != Errors.NONE.code() && result.errorCode() != Errors.RESOURCE_NOT_FOUND.code()).findFirst();
                if (optionalFirstFailedDescribe.isPresent()) {
                    retval.completeExceptionally(Errors.forCode(optionalFirstFailedDescribe.get().errorCode()).exception(optionalFirstFailedDescribe.get().errorMessage()));
                } else {
                    HashMap retvalMap = new HashMap();
                    data.results().stream().forEach(userResult -> retvalMap.put(userResult.user(), new UserScramCredentialsDescription(userResult.user(), DescribeUserScramCredentialsResult.getScramCredentialInfosFor(userResult))));
                    retval.complete(retvalMap);
                }
            }
        });
        return retval;
    }

    public KafkaFuture<List<String>> users() {
        KafkaFutureImpl<List<String>> retval = new KafkaFutureImpl<List<String>>();
        this.dataFuture.whenComplete((data, throwable) -> {
            if (throwable != null) {
                retval.completeExceptionally((Throwable)throwable);
            } else {
                retval.complete(data.results().stream().filter(result -> result.errorCode() != Errors.RESOURCE_NOT_FOUND.code()).map(result -> result.user()).collect(Collectors.toList()));
            }
        });
        return retval;
    }

    public KafkaFuture<UserScramCredentialsDescription> description(String userName) {
        KafkaFutureImpl<UserScramCredentialsDescription> retval = new KafkaFutureImpl<UserScramCredentialsDescription>();
        this.dataFuture.whenComplete((data, throwable) -> {
            if (throwable != null) {
                retval.completeExceptionally((Throwable)throwable);
            } else {
                Optional<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> optionalUserResult = data.results().stream().filter(result -> result.user().equals(userName)).findFirst();
                if (!optionalUserResult.isPresent()) {
                    retval.completeExceptionally(new ResourceNotFoundException("No such user: " + userName));
                } else {
                    DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult userResult = optionalUserResult.get();
                    if (userResult.errorCode() != Errors.NONE.code()) {
                        retval.completeExceptionally(Errors.forCode(userResult.errorCode()).exception(userResult.errorMessage()));
                    } else {
                        retval.complete(new UserScramCredentialsDescription(userResult.user(), DescribeUserScramCredentialsResult.getScramCredentialInfosFor(userResult)));
                    }
                }
            }
        });
        return retval;
    }

    private static List<ScramCredentialInfo> getScramCredentialInfosFor(DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult userResult) {
        return userResult.credentialInfos().stream().map(c2 -> new ScramCredentialInfo(ScramMechanism.fromType(c2.mechanism()), c2.iterations())).collect(Collectors.toList());
    }
}

