/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.ApiVersions;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.ClientDnsLookup;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.ClientUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.KafkaClient;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.NetworkClient;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.consumer.OffsetAndMetadata;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.Callback;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.Partitioner;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.Producer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.ProducerConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.ProducerInterceptor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.ProducerRecord;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.RecordMetadata;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.internals.BufferPool;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.internals.ProducerInterceptors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.internals.ProducerMetadata;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.internals.ProducerMetrics;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.internals.RecordAccumulator;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.internals.Sender;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.internals.TransactionManager;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.internals.TransactionalRequestResult;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.Cluster;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.KafkaException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.Metric;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.MetricName;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.PartitionInfo;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.ApiException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.InterruptException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.InvalidTopicException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.ProducerFencedException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.RecordTooLargeException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.SerializationException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.TimeoutException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.header.Header;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.header.Headers;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.header.internals.RecordHeaders;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.internals.ClusterResourceListeners;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.metrics.JmxReporter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.metrics.KafkaMetricsContext;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.metrics.MetricConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.metrics.Metrics;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.metrics.MetricsReporter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.metrics.Sensor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.network.ChannelBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.network.Selector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.AbstractRecords;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.CompressionType;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.Serializer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.AppInfoParser;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.KafkaThread;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.LogContext;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Time;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class KafkaProducer<K, V>
implements Producer<K, V> {
    private final Logger log;
    private static final String JMX_PREFIX = "kafka.producer";
    public static final String NETWORK_THREAD_PREFIX = "kafka-producer-network-thread";
    public static final String PRODUCER_METRIC_GROUP_NAME = "producer-metrics";
    private final String clientId;
    final Metrics metrics;
    private final Partitioner partitioner;
    private final int maxRequestSize;
    private final long totalMemorySize;
    private final ProducerMetadata metadata;
    private final RecordAccumulator accumulator;
    private final Sender sender;
    private final Thread ioThread;
    private final CompressionType compressionType;
    private final Sensor errors;
    private final Time time;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final ProducerConfig producerConfig;
    private final long maxBlockTimeMs;
    private final ProducerInterceptors<K, V> interceptors;
    private final ApiVersions apiVersions;
    private final TransactionManager transactionManager;

    public KafkaProducer(Map<String, Object> configs) {
        this(configs, null, null, null, null, null, Time.SYSTEM);
    }

    public KafkaProducer(Map<String, Object> configs, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(configs, keySerializer, valueSerializer, null, null, null, Time.SYSTEM);
    }

    public KafkaProducer(Properties properties) {
        this(Utils.propsToMap(properties), null, null, null, null, null, Time.SYSTEM);
    }

    public KafkaProducer(Properties properties, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(Utils.propsToMap(properties), keySerializer, valueSerializer, null, null, null, Time.SYSTEM);
    }

    KafkaProducer(Map<String, Object> configs, Serializer<K> keySerializer, Serializer<V> valueSerializer, ProducerMetadata metadata, KafkaClient kafkaClient, ProducerInterceptors<K, V> interceptors, Time time) {
        ProducerConfig config = new ProducerConfig(ProducerConfig.appendSerializerToConfig(configs, keySerializer, valueSerializer));
        try {
            Map<String, Object> userProvidedConfigs = config.originals();
            this.producerConfig = config;
            this.time = time;
            String transactionalId = (String)userProvidedConfigs.get("transactional.id");
            this.clientId = config.getString("client.id");
            LogContext logContext = transactionalId == null ? new LogContext(String.format("[Producer clientId=%s] ", this.clientId)) : new LogContext(String.format("[Producer clientId=%s, transactionalId=%s] ", this.clientId, transactionalId));
            this.log = logContext.logger(KafkaProducer.class);
            this.log.trace("Starting the Kafka producer");
            Map<String, String> metricTags = Collections.singletonMap("client-id", this.clientId);
            MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples")).timeWindow(config.getLong("metrics.sample.window.ms"), TimeUnit.MILLISECONDS).recordLevel(Sensor.RecordingLevel.forName(config.getString("metrics.recording.level"))).tags(metricTags);
            List<MetricsReporter> reporters = config.getConfiguredInstances("metric.reporters", MetricsReporter.class, Collections.singletonMap("client.id", this.clientId));
            JmxReporter jmxReporter = new JmxReporter();
            jmxReporter.configure(userProvidedConfigs);
            reporters.add(jmxReporter);
            KafkaMetricsContext metricsContext = new KafkaMetricsContext(JMX_PREFIX, config.originalsWithPrefix("metrics.context."));
            this.metrics = new Metrics(metricConfig, reporters, time, metricsContext);
            this.partitioner = config.getConfiguredInstance("partitioner.class", Partitioner.class);
            long retryBackoffMs = config.getLong("retry.backoff.ms");
            if (keySerializer == null) {
                this.keySerializer = config.getConfiguredInstance("key.serializer", Serializer.class);
                this.keySerializer.configure(config.originals(Collections.singletonMap("client.id", this.clientId)), true);
            } else {
                config.ignore("key.serializer");
                this.keySerializer = keySerializer;
            }
            if (valueSerializer == null) {
                this.valueSerializer = config.getConfiguredInstance("value.serializer", Serializer.class);
                this.valueSerializer.configure(config.originals(Collections.singletonMap("client.id", this.clientId)), false);
            } else {
                config.ignore("value.serializer");
                this.valueSerializer = valueSerializer;
            }
            userProvidedConfigs.put("client.id", this.clientId);
            ProducerConfig configWithClientId = new ProducerConfig(userProvidedConfigs, false);
            List interceptorList = configWithClientId.getConfiguredInstances("interceptor.classes", ProducerInterceptor.class);
            this.interceptors = interceptors != null ? interceptors : new ProducerInterceptors(interceptorList);
            ClusterResourceListeners clusterResourceListeners = this.configureClusterResourceListeners(keySerializer, valueSerializer, interceptorList, reporters);
            this.maxRequestSize = config.getInt("max.request.size");
            this.totalMemorySize = config.getLong("buffer.memory");
            this.compressionType = CompressionType.forName(config.getString("compression.type"));
            this.maxBlockTimeMs = config.getLong("max.block.ms");
            int deliveryTimeoutMs = KafkaProducer.configureDeliveryTimeout(config, this.log);
            this.apiVersions = new ApiVersions();
            this.transactionManager = this.configureTransactionState(config, logContext);
            this.accumulator = new RecordAccumulator(logContext, config.getInt("batch.size"), this.compressionType, KafkaProducer.lingerMs(config), retryBackoffMs, deliveryTimeoutMs, this.metrics, PRODUCER_METRIC_GROUP_NAME, time, this.apiVersions, this.transactionManager, new BufferPool(this.totalMemorySize, config.getInt("batch.size"), this.metrics, time, PRODUCER_METRIC_GROUP_NAME));
            List<InetSocketAddress> addresses = ClientUtils.parseAndValidateAddresses(config.getList("bootstrap.servers"), config.getString("client.dns.lookup"));
            if (metadata != null) {
                this.metadata = metadata;
            } else {
                this.metadata = new ProducerMetadata(retryBackoffMs, config.getLong("metadata.max.age.ms"), config.getLong("metadata.max.idle.ms"), logContext, clusterResourceListeners, Time.SYSTEM);
                this.metadata.bootstrap(addresses);
            }
            this.errors = this.metrics.sensor("errors");
            this.sender = this.newSender(logContext, kafkaClient, this.metadata);
            String ioThreadName = "kafka-producer-network-thread | " + this.clientId;
            this.ioThread = new KafkaThread(ioThreadName, (Runnable)this.sender, true);
            this.ioThread.start();
            config.logUnused();
            AppInfoParser.registerAppInfo(JMX_PREFIX, this.clientId, this.metrics, time.milliseconds());
            this.log.debug("Kafka producer started");
        }
        catch (Throwable t2) {
            this.close(Duration.ofMillis(0L), true);
            throw new KafkaException("Failed to construct kafka producer", t2);
        }
    }

    Sender newSender(LogContext logContext, KafkaClient kafkaClient, ProducerMetadata metadata) {
        int maxInflightRequests = KafkaProducer.configureInflightRequests(this.producerConfig);
        int requestTimeoutMs = this.producerConfig.getInt("request.timeout.ms");
        ChannelBuilder channelBuilder = ClientUtils.createChannelBuilder(this.producerConfig, this.time, logContext);
        ProducerMetrics metricsRegistry = new ProducerMetrics(this.metrics);
        Sensor throttleTimeSensor = Sender.throttleTimeSensor(metricsRegistry.senderMetrics);
        KafkaClient client = kafkaClient != null ? kafkaClient : new NetworkClient(new Selector(this.producerConfig.getLong("connections.max.idle.ms"), this.metrics, this.time, "producer", channelBuilder, logContext), metadata, this.clientId, maxInflightRequests, this.producerConfig.getLong("reconnect.backoff.ms"), this.producerConfig.getLong("reconnect.backoff.max.ms"), this.producerConfig.getInt("send.buffer.bytes"), this.producerConfig.getInt("receive.buffer.bytes"), requestTimeoutMs, this.producerConfig.getLong("socket.connection.setup.timeout.ms"), this.producerConfig.getLong("socket.connection.setup.timeout.max.ms"), ClientDnsLookup.forConfig(this.producerConfig.getString("client.dns.lookup")), this.time, true, this.apiVersions, throttleTimeSensor, logContext);
        short acks = KafkaProducer.configureAcks(this.producerConfig, this.log);
        return new Sender(logContext, client, metadata, this.accumulator, maxInflightRequests == 1, this.producerConfig.getInt("max.request.size"), acks, this.producerConfig.getInt("retries"), metricsRegistry.senderMetrics, this.time, requestTimeoutMs, this.producerConfig.getLong("retry.backoff.ms"), this.transactionManager, this.apiVersions);
    }

    private static int lingerMs(ProducerConfig config) {
        return (int)Math.min(config.getLong("linger.ms"), Integer.MAX_VALUE);
    }

    private static int configureDeliveryTimeout(ProducerConfig config, Logger log) {
        int requestTimeoutMs;
        int lingerMs;
        int lingerAndRequestTimeoutMs;
        int deliveryTimeoutMs = config.getInt("delivery.timeout.ms");
        if (deliveryTimeoutMs < (lingerAndRequestTimeoutMs = (int)Math.min((long)(lingerMs = KafkaProducer.lingerMs(config)) + (long)(requestTimeoutMs = config.getInt("request.timeout.ms").intValue()), Integer.MAX_VALUE))) {
            if (config.originals().containsKey("delivery.timeout.ms")) {
                throw new ConfigException("delivery.timeout.ms should be equal to or larger than linger.ms + request.timeout.ms");
            }
            deliveryTimeoutMs = lingerAndRequestTimeoutMs;
            log.warn("{} should be equal to or larger than {} + {}. Setting it to {}.", new Object[]{"delivery.timeout.ms", "linger.ms", "request.timeout.ms", deliveryTimeoutMs});
        }
        return deliveryTimeoutMs;
    }

    private TransactionManager configureTransactionState(ProducerConfig config, LogContext logContext) {
        TransactionManager transactionManager = null;
        boolean userConfiguredIdempotence = config.originals().containsKey("enable.idempotence");
        boolean userConfiguredTransactions = config.originals().containsKey("transactional.id");
        if (userConfiguredTransactions && !userConfiguredIdempotence) {
            this.log.info("Overriding the default {} to true since {} is specified.", (Object)"enable.idempotence", (Object)"transactional.id");
        }
        if (config.idempotenceEnabled()) {
            boolean autoDowngradeTxnCommit;
            long retryBackoffMs;
            int transactionTimeoutMs;
            String transactionalId = config.getString("transactional.id");
            transactionManager = new TransactionManager(logContext, transactionalId, transactionTimeoutMs = config.getInt("transaction.timeout.ms").intValue(), retryBackoffMs = config.getLong("retry.backoff.ms").longValue(), this.apiVersions, autoDowngradeTxnCommit = config.getBoolean("internal.auto.downgrade.txn.commit").booleanValue());
            if (transactionManager.isTransactional()) {
                this.log.info("Instantiated a transactional producer.");
            } else {
                this.log.info("Instantiated an idempotent producer.");
            }
        }
        return transactionManager;
    }

    private static int configureInflightRequests(ProducerConfig config) {
        if (config.idempotenceEnabled() && 5 < config.getInt("max.in.flight.requests.per.connection")) {
            throw new ConfigException("Must set max.in.flight.requests.per.connection to at most 5 to use the idempotent producer.");
        }
        return config.getInt("max.in.flight.requests.per.connection");
    }

    private static short configureAcks(ProducerConfig config, Logger log) {
        boolean userConfiguredAcks = config.originals().containsKey("acks");
        short acks = Short.parseShort(config.getString("acks"));
        if (config.idempotenceEnabled()) {
            if (!userConfiguredAcks) {
                log.info("Overriding the default {} to all since idempotence is enabled.", (Object)"acks");
            } else if (acks != -1) {
                throw new ConfigException("Must set acks to all in order to use the idempotent producer. Otherwise we cannot guarantee idempotence.");
            }
        }
        return acks;
    }

    @Override
    public void initTransactions() {
        this.throwIfNoTransactionManager();
        this.throwIfProducerClosed();
        TransactionalRequestResult result = this.transactionManager.initializeTransactions();
        this.sender.wakeup();
        result.await(this.maxBlockTimeMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void beginTransaction() throws ProducerFencedException {
        this.throwIfNoTransactionManager();
        this.throwIfProducerClosed();
        this.transactionManager.beginTransaction();
    }

    @Override
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) throws ProducerFencedException {
        this.sendOffsetsToTransaction(offsets, new ConsumerGroupMetadata(consumerGroupId));
    }

    @Override
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) throws ProducerFencedException {
        this.throwIfInvalidGroupMetadata(groupMetadata);
        this.throwIfNoTransactionManager();
        this.throwIfProducerClosed();
        TransactionalRequestResult result = this.transactionManager.sendOffsetsToTransaction(offsets, groupMetadata);
        this.sender.wakeup();
        result.await(this.maxBlockTimeMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void commitTransaction() throws ProducerFencedException {
        this.throwIfNoTransactionManager();
        this.throwIfProducerClosed();
        TransactionalRequestResult result = this.transactionManager.beginCommit();
        this.sender.wakeup();
        result.await(this.maxBlockTimeMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void abortTransaction() throws ProducerFencedException {
        this.throwIfNoTransactionManager();
        this.throwIfProducerClosed();
        this.log.info("Aborting incomplete transaction");
        TransactionalRequestResult result = this.transactionManager.beginAbort();
        this.sender.wakeup();
        result.await(this.maxBlockTimeMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        return this.send(record, null);
    }

    @Override
    public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
        ProducerRecord<K, V> interceptedRecord = this.interceptors.onSend(record);
        return this.doSend(interceptedRecord, callback);
    }

    private void throwIfProducerClosed() {
        if (this.sender == null || !this.sender.isRunning()) {
            throw new IllegalStateException("Cannot perform operation after producer has been closed");
        }
    }

    private Future<RecordMetadata> doSend(ProducerRecord<K, V> record, Callback callback) {
        TopicPartition tp = null;
        try {
            long timestamp;
            byte[] serializedValue;
            byte[] serializedKey;
            ClusterAndWaitTime clusterAndWaitTime;
            this.throwIfProducerClosed();
            long nowMs = this.time.milliseconds();
            try {
                clusterAndWaitTime = this.waitOnMetadata(record.topic(), record.partition(), nowMs, this.maxBlockTimeMs);
            }
            catch (KafkaException e2) {
                if (this.metadata.isClosed()) {
                    throw new KafkaException("Producer closed while send in progress", e2);
                }
                throw e2;
            }
            nowMs += clusterAndWaitTime.waitedOnMetadataMs;
            long remainingWaitMs = Math.max(0L, this.maxBlockTimeMs - clusterAndWaitTime.waitedOnMetadataMs);
            Cluster cluster = clusterAndWaitTime.cluster;
            try {
                serializedKey = this.keySerializer.serialize(record.topic(), record.headers(), record.key());
            }
            catch (ClassCastException cce) {
                throw new SerializationException("Can't convert key of class " + record.key().getClass().getName() + " to class " + this.producerConfig.getClass("key.serializer").getName() + " specified in key.serializer", cce);
            }
            try {
                serializedValue = this.valueSerializer.serialize(record.topic(), record.headers(), record.value());
            }
            catch (ClassCastException cce) {
                throw new SerializationException("Can't convert value of class " + record.value().getClass().getName() + " to class " + this.producerConfig.getClass("value.serializer").getName() + " specified in value.serializer", cce);
            }
            int partition = this.partition(record, serializedKey, serializedValue, cluster);
            tp = new TopicPartition(record.topic(), partition);
            this.setReadOnly(record.headers());
            Header[] headers = record.headers().toArray();
            int serializedSize = AbstractRecords.estimateSizeInBytesUpperBound(this.apiVersions.maxUsableProduceMagic(), this.compressionType, serializedKey, serializedValue, headers);
            this.ensureValidRecordSize(serializedSize);
            long l2 = timestamp = record.timestamp() == null ? nowMs : record.timestamp();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Attempting to append record {} with callback {} to topic {} partition {}", new Object[]{record, callback, record.topic(), partition});
            }
            InterceptorCallback interceptCallback = new InterceptorCallback(callback, this.interceptors, tp);
            if (this.transactionManager != null && this.transactionManager.isTransactional()) {
                this.transactionManager.failIfNotReadyForSend();
            }
            RecordAccumulator.RecordAppendResult result = this.accumulator.append(tp, timestamp, serializedKey, serializedValue, headers, interceptCallback, remainingWaitMs, true, nowMs);
            if (result.abortForNewBatch) {
                int prevPartition = partition;
                this.partitioner.onNewBatch(record.topic(), cluster, prevPartition);
                partition = this.partition(record, serializedKey, serializedValue, cluster);
                tp = new TopicPartition(record.topic(), partition);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Retrying append due to new batch creation for topic {} partition {}. The old partition was {}", new Object[]{record.topic(), partition, prevPartition});
                }
                interceptCallback = new InterceptorCallback(callback, this.interceptors, tp);
                result = this.accumulator.append(tp, timestamp, serializedKey, serializedValue, headers, interceptCallback, remainingWaitMs, false, nowMs);
            }
            if (this.transactionManager != null && this.transactionManager.isTransactional()) {
                this.transactionManager.maybeAddPartitionToTransaction(tp);
            }
            if (result.batchIsFull || result.newBatchCreated) {
                this.log.trace("Waking up the sender since topic {} partition {} is either full or getting a new batch", (Object)record.topic(), (Object)partition);
                this.sender.wakeup();
            }
            return result.future;
        }
        catch (ApiException e3) {
            this.log.debug("Exception occurred during message send:", (Throwable)e3);
            if (callback != null) {
                callback.onCompletion(null, e3);
            }
            this.errors.record();
            this.interceptors.onSendError(record, tp, e3);
            return new FutureFailure(e3);
        }
        catch (InterruptedException e4) {
            this.errors.record();
            this.interceptors.onSendError(record, tp, e4);
            throw new InterruptException(e4);
        }
        catch (KafkaException e5) {
            this.errors.record();
            this.interceptors.onSendError(record, tp, e5);
            throw e5;
        }
        catch (Exception e6) {
            this.interceptors.onSendError(record, tp, e6);
            throw e6;
        }
    }

    private void setReadOnly(Headers headers) {
        if (headers instanceof RecordHeaders) {
            ((RecordHeaders)headers).setReadOnly();
        }
    }

    private ClusterAndWaitTime waitOnMetadata(String topic, Integer partition, long nowMs, long maxWaitMs) throws InterruptedException {
        Cluster cluster = this.metadata.fetch();
        if (cluster.invalidTopics().contains(topic)) {
            throw new InvalidTopicException(topic);
        }
        this.metadata.add(topic, nowMs);
        Integer partitionsCount = cluster.partitionCountForTopic(topic);
        if (partitionsCount != null && (partition == null || partition < partitionsCount)) {
            return new ClusterAndWaitTime(cluster, 0L);
        }
        long remainingWaitMs = maxWaitMs;
        long elapsed = 0L;
        do {
            if (partition != null) {
                this.log.trace("Requesting metadata update for partition {} of topic {}.", (Object)partition, (Object)topic);
            } else {
                this.log.trace("Requesting metadata update for topic {}.", (Object)topic);
            }
            this.metadata.add(topic, nowMs + elapsed);
            int version = this.metadata.requestUpdateForTopic(topic);
            this.sender.wakeup();
            try {
                this.metadata.awaitUpdate(version, remainingWaitMs);
            }
            catch (TimeoutException ex) {
                throw new TimeoutException(String.format("Topic %s not present in metadata after %d ms.", topic, maxWaitMs));
            }
            cluster = this.metadata.fetch();
            elapsed = this.time.milliseconds() - nowMs;
            if (elapsed >= maxWaitMs) {
                throw new TimeoutException(partitionsCount == null ? String.format("Topic %s not present in metadata after %d ms.", topic, maxWaitMs) : String.format("Partition %d of topic %s with partition count %d is not present in metadata after %d ms.", partition, topic, partitionsCount, maxWaitMs));
            }
            this.metadata.maybeThrowExceptionForTopic(topic);
            remainingWaitMs = maxWaitMs - elapsed;
        } while ((partitionsCount = cluster.partitionCountForTopic(topic)) == null || partition != null && partition >= partitionsCount);
        return new ClusterAndWaitTime(cluster, elapsed);
    }

    private void ensureValidRecordSize(int size) {
        if (size > this.maxRequestSize) {
            throw new RecordTooLargeException("The message is " + size + " bytes when serialized which is larger than " + this.maxRequestSize + ", which is the value of the " + "max.request.size" + " configuration.");
        }
        if ((long)size > this.totalMemorySize) {
            throw new RecordTooLargeException("The message is " + size + " bytes when serialized which is larger than the total memory buffer you have configured with the " + "buffer.memory" + " configuration.");
        }
    }

    @Override
    public void flush() {
        this.log.trace("Flushing accumulated records in producer.");
        this.accumulator.beginFlush();
        this.sender.wakeup();
        try {
            this.accumulator.awaitFlushCompletion();
        }
        catch (InterruptedException e2) {
            throw new InterruptException("Flush interrupted.", e2);
        }
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic) {
        Objects.requireNonNull(topic, "topic cannot be null");
        try {
            return this.waitOnMetadata((String)topic, null, (long)this.time.milliseconds(), (long)this.maxBlockTimeMs).cluster.partitionsForTopic(topic);
        }
        catch (InterruptedException e2) {
            throw new InterruptException(e2);
        }
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        return Collections.unmodifiableMap(this.metrics.metrics());
    }

    @Override
    public void close() {
        this.close(Duration.ofMillis(Long.MAX_VALUE));
    }

    @Override
    public void close(Duration timeout) {
        this.close(timeout, false);
    }

    private void close(Duration timeout, boolean swallowException) {
        boolean invokedFromCallback;
        long timeoutMs = timeout.toMillis();
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException("The timeout cannot be negative.");
        }
        this.log.info("Closing the Kafka producer with timeoutMillis = {} ms.", (Object)timeoutMs);
        AtomicReference<Throwable> firstException = new AtomicReference<Throwable>();
        boolean bl = invokedFromCallback = Thread.currentThread() == this.ioThread;
        if (timeoutMs > 0L) {
            if (invokedFromCallback) {
                this.log.warn("Overriding close timeout {} ms to 0 ms in order to prevent useless blocking due to self-join. This means you have incorrectly invoked close with a non-zero timeout from the producer call-back.", (Object)timeoutMs);
            } else {
                if (this.sender != null) {
                    this.sender.initiateClose();
                }
                if (this.ioThread != null) {
                    try {
                        this.ioThread.join(timeoutMs);
                    }
                    catch (InterruptedException t2) {
                        firstException.compareAndSet(null, new InterruptException(t2));
                        this.log.error("Interrupted while joining ioThread", (Throwable)t2);
                    }
                }
            }
        }
        if (this.sender != null && this.ioThread != null && this.ioThread.isAlive()) {
            this.log.info("Proceeding to force close the producer since pending requests could not be completed within timeout {} ms.", (Object)timeoutMs);
            this.sender.forceClose();
            if (!invokedFromCallback) {
                try {
                    this.ioThread.join();
                }
                catch (InterruptedException e2) {
                    firstException.compareAndSet(null, new InterruptException(e2));
                }
            }
        }
        Utils.closeQuietly(this.interceptors, "producer interceptors", firstException);
        Utils.closeQuietly(this.metrics, "producer metrics", firstException);
        Utils.closeQuietly(this.keySerializer, "producer keySerializer", firstException);
        Utils.closeQuietly(this.valueSerializer, "producer valueSerializer", firstException);
        Utils.closeQuietly(this.partitioner, "producer partitioner", firstException);
        AppInfoParser.unregisterAppInfo(JMX_PREFIX, this.clientId, this.metrics);
        Throwable exception = firstException.get();
        if (exception != null && !swallowException) {
            if (exception instanceof InterruptException) {
                throw (InterruptException)exception;
            }
            throw new KafkaException("Failed to close kafka producer", exception);
        }
        this.log.debug("Kafka producer has been closed");
    }

    private ClusterResourceListeners configureClusterResourceListeners(Serializer<K> keySerializer, Serializer<V> valueSerializer, List<?> ... candidateLists) {
        ClusterResourceListeners clusterResourceListeners = new ClusterResourceListeners();
        for (List<?> candidateList : candidateLists) {
            clusterResourceListeners.maybeAddAll(candidateList);
        }
        clusterResourceListeners.maybeAdd(keySerializer);
        clusterResourceListeners.maybeAdd(valueSerializer);
        return clusterResourceListeners;
    }

    private int partition(ProducerRecord<K, V> record, byte[] serializedKey, byte[] serializedValue, Cluster cluster) {
        Integer partition = record.partition();
        return partition != null ? partition.intValue() : this.partitioner.partition(record.topic(), record.key(), serializedKey, record.value(), serializedValue, cluster);
    }

    private void throwIfInvalidGroupMetadata(ConsumerGroupMetadata groupMetadata) {
        if (groupMetadata == null) {
            throw new IllegalArgumentException("Consumer group metadata could not be null");
        }
        if (groupMetadata.generationId() > 0 && "".equals(groupMetadata.memberId())) {
            throw new IllegalArgumentException("Passed in group metadata " + groupMetadata + " has generationId > 0 but member.id ");
        }
    }

    private void throwIfNoTransactionManager() {
        if (this.transactionManager == null) {
            throw new IllegalStateException("Cannot use transactional methods without enabling transactions by setting the transactional.id configuration property");
        }
    }

    String getClientId() {
        return this.clientId;
    }

    private static class InterceptorCallback<K, V>
    implements Callback {
        private final Callback userCallback;
        private final ProducerInterceptors<K, V> interceptors;
        private final TopicPartition tp;

        private InterceptorCallback(Callback userCallback, ProducerInterceptors<K, V> interceptors, TopicPartition tp) {
            this.userCallback = userCallback;
            this.interceptors = interceptors;
            this.tp = tp;
        }

        @Override
        public void onCompletion(RecordMetadata metadata, Exception exception) {
            metadata = metadata != null ? metadata : new RecordMetadata(this.tp, -1L, -1L, -1L, -1L, -1, -1);
            this.interceptors.onAcknowledgement(metadata, exception);
            if (this.userCallback != null) {
                this.userCallback.onCompletion(metadata, exception);
            }
        }
    }

    private static class FutureFailure
    implements Future<RecordMetadata> {
        private final ExecutionException exception;

        public FutureFailure(Exception exception) {
            this.exception = new ExecutionException(exception);
        }

        @Override
        public boolean cancel(boolean interrupt) {
            return false;
        }

        @Override
        public RecordMetadata get() throws ExecutionException {
            throw this.exception;
        }

        @Override
        public RecordMetadata get(long timeout, TimeUnit unit) throws ExecutionException {
            throw this.exception;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }

    private static class ClusterAndWaitTime {
        final Cluster cluster;
        final long waitedOnMetadataMs;

        ClusterAndWaitTime(Cluster cluster, long waitedOnMetadataMs) {
            this.cluster = cluster;
            this.waitedOnMetadataMs = waitedOnMetadataMs;
        }
    }
}

