/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.acl;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.acl.AccessControlEntryData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.acl.AccessControlEntryFilter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.acl.AclOperation;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.acl.AclPermissionType;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.annotation.InterfaceStability;
import java.util.Objects;

@InterfaceStability.Evolving
public class AccessControlEntry {
    final AccessControlEntryData data;

    public AccessControlEntry(String principal, String host, AclOperation operation, AclPermissionType permissionType) {
        Objects.requireNonNull(principal);
        Objects.requireNonNull(host);
        Objects.requireNonNull(operation);
        if (operation == AclOperation.ANY) {
            throw new IllegalArgumentException("operation must not be ANY");
        }
        Objects.requireNonNull(permissionType);
        if (permissionType == AclPermissionType.ANY) {
            throw new IllegalArgumentException("permissionType must not be ANY");
        }
        this.data = new AccessControlEntryData(principal, host, operation, permissionType);
    }

    public String principal() {
        return this.data.principal();
    }

    public String host() {
        return this.data.host();
    }

    public AclOperation operation() {
        return this.data.operation();
    }

    public AclPermissionType permissionType() {
        return this.data.permissionType();
    }

    public AccessControlEntryFilter toFilter() {
        return new AccessControlEntryFilter(this.data);
    }

    public String toString() {
        return this.data.toString();
    }

    public boolean isUnknown() {
        return this.data.isUnknown();
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof AccessControlEntry)) {
            return false;
        }
        AccessControlEntry other = (AccessControlEntry)o2;
        return this.data.equals(other.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }
}

