/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiMessage;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Message;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.MessageUtil;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Readable;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Writable;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Type;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ByteUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class CreatePartitionsRequestData
implements ApiMessage {
    CreatePartitionsTopicCollection topics;
    int timeoutMs;
    boolean validateOnly;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public CreatePartitionsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public CreatePartitionsRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public CreatePartitionsRequestData() {
        this.topics = new CreatePartitionsTopicCollection(0);
        this.timeoutMs = 0;
        this.validateOnly = false;
    }

    @Override
    public short apiKey() {
        return 37;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i2;
        CreatePartitionsTopicCollection newCollection;
        int arrayLength;
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new CreatePartitionsTopicCollection(arrayLength);
            for (i2 = 0; i2 < arrayLength; ++i2) {
                newCollection.add(new CreatePartitionsTopic(_readable, _version));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new CreatePartitionsTopicCollection(arrayLength);
            for (i2 = 0; i2 < arrayLength; ++i2) {
                newCollection.add(new CreatePartitionsTopic(_readable, _version));
            }
            this.topics = newCollection;
        }
        this.timeoutMs = _readable.readInt();
        this.validateOnly = _readable.readByte() != 0;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            for (CreatePartitionsTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.topics.size());
            for (CreatePartitionsTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        }
        _writable.writeInt(this.timeoutMs);
        _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new CreatePartitionsTopicCollection(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new CreatePartitionsTopic((Struct)nestedObject, _version));
        }
        this.timeoutMs = struct.getInt("timeout_ms");
        this.validateOnly = struct.getBoolean("validate_only");
        if (_version >= 2 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 2) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i2 = 0;
        for (CreatePartitionsTopic element : this.topics) {
            _nestedObjects[i2++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        struct.set("timeout_ms", (Object)this.timeoutMs);
        struct.set("validate_only", (Object)this.validateOnly);
        if (_version >= 2) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1)) : (_arraySize += 4);
        for (CreatePartitionsTopic topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        _size += 4;
        ++_size;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 2) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreatePartitionsRequestData)) {
            return false;
        }
        CreatePartitionsRequestData other = (CreatePartitionsRequestData)obj;
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        if (this.validateOnly != other.validateOnly) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public CreatePartitionsRequestData duplicate() {
        CreatePartitionsRequestData _duplicate = new CreatePartitionsRequestData();
        CreatePartitionsTopicCollection newTopics = new CreatePartitionsTopicCollection(this.topics.size());
        for (CreatePartitionsTopic _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        _duplicate.timeoutMs = this.timeoutMs;
        _duplicate.validateOnly = this.validateOnly;
        return _duplicate;
    }

    public String toString() {
        return "CreatePartitionsRequestData(topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", timeoutMs=" + this.timeoutMs + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ")";
    }

    public CreatePartitionsTopicCollection topics() {
        return this.topics;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public CreatePartitionsRequestData setTopics(CreatePartitionsTopicCollection v2) {
        this.topics = v2;
        return this;
    }

    public CreatePartitionsRequestData setTimeoutMs(int v2) {
        this.timeoutMs = v2;
        return this;
    }

    public CreatePartitionsRequestData setValidateOnly(boolean v2) {
        this.validateOnly = v2;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(CreatePartitionsTopic.SCHEMA_0), "Each topic that we want to create new partitions inside."), new Field("timeout_ms", Type.INT32, "The time in ms to wait for the partitions to be created."), new Field("validate_only", Type.BOOLEAN, "If true, then validate the request, but don't actually increase the number of partitions."));
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field("topics", new CompactArrayOf(CreatePartitionsTopic.SCHEMA_2), "Each topic that we want to create new partitions inside."), new Field("timeout_ms", Type.INT32, "The time in ms to wait for the partitions to be created."), new Field("validate_only", Type.BOOLEAN, "If true, then validate the request, but don't actually increase the number of partitions."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class CreatePartitionsTopicCollection
    extends ImplicitLinkedHashMultiCollection<CreatePartitionsTopic> {
        public CreatePartitionsTopicCollection() {
        }

        public CreatePartitionsTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public CreatePartitionsTopicCollection(Iterator<CreatePartitionsTopic> iterator) {
            super(iterator);
        }

        @Override
        public CreatePartitionsTopic find(String name) {
            CreatePartitionsTopic _key = new CreatePartitionsTopic();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<CreatePartitionsTopic> findAll(String name) {
            CreatePartitionsTopic _key = new CreatePartitionsTopic();
            _key.setName(name);
            return this.findAll(_key);
        }

        public CreatePartitionsTopicCollection duplicate() {
            CreatePartitionsTopicCollection _duplicate = new CreatePartitionsTopicCollection(this.size());
            for (CreatePartitionsTopic _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class CreatePartitionsAssignment
    implements Message {
        List<Integer> brokerIds;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public CreatePartitionsAssignment(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public CreatePartitionsAssignment(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public CreatePartitionsAssignment() {
            this.brokerIds = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatePartitionsAssignment");
            }
            int arrayLength = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field brokerIds was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i2 = 0; i2 < arrayLength; ++i2) {
                newCollection.add(_readable.readInt());
            }
            this.brokerIds = newCollection;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.brokerIds.size() + 1);
            } else {
                _writable.writeInt(this.brokerIds.size());
            }
            for (Integer brokerIdsElement : this.brokerIds) {
                _writable.writeInt(brokerIdsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatePartitionsAssignment");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            Object[] _nestedObjects = struct.getArray("broker_ids");
            this.brokerIds = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.brokerIds.add((Integer)nestedObject);
            }
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatePartitionsAssignment");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            Integer[] _nestedObjects = new Integer[this.brokerIds.size()];
            int i2 = 0;
            for (Integer element : this.brokerIds) {
                _nestedObjects[i2++] = element;
            }
            struct.set("broker_ids", (Object)_nestedObjects);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatePartitionsAssignment");
            }
            int _arraySize = 0;
            _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.brokerIds.size() + 1)) : (_arraySize += 4);
            _size += (_arraySize += this.brokerIds.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatePartitionsAssignment)) {
                return false;
            }
            CreatePartitionsAssignment other = (CreatePartitionsAssignment)obj;
            if (this.brokerIds == null ? other.brokerIds != null : !this.brokerIds.equals(other.brokerIds)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.brokerIds == null ? 0 : this.brokerIds.hashCode());
            return hashCode;
        }

        @Override
        public CreatePartitionsAssignment duplicate() {
            CreatePartitionsAssignment _duplicate = new CreatePartitionsAssignment();
            ArrayList<Integer> newBrokerIds = new ArrayList<Integer>(this.brokerIds.size());
            for (Integer _element : this.brokerIds) {
                newBrokerIds.add(_element);
            }
            _duplicate.brokerIds = newBrokerIds;
            return _duplicate;
        }

        public String toString() {
            return "CreatePartitionsAssignment(brokerIds=" + MessageUtil.deepToString(this.brokerIds.iterator()) + ")";
        }

        public List<Integer> brokerIds() {
            return this.brokerIds;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatePartitionsAssignment setBrokerIds(List<Integer> v2) {
            this.brokerIds = v2;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("broker_ids", new ArrayOf(Type.INT32), "The assigned broker IDs."));
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("broker_ids", new CompactArrayOf(Type.INT32), "The assigned broker IDs."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }

    public static class CreatePartitionsTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        int count;
        List<CreatePartitionsAssignment> assignments;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public CreatePartitionsTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public CreatePartitionsTopic(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public CreatePartitionsTopic() {
            this.name = "";
            this.count = 0;
            this.assignments = new ArrayList<CreatePartitionsAssignment>(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i2;
            ArrayList<CreatePartitionsAssignment> newCollection;
            int arrayLength;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatePartitionsTopic");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.count = _readable.readInt();
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.assignments = null;
                } else {
                    newCollection = new ArrayList(arrayLength);
                    for (i2 = 0; i2 < arrayLength; ++i2) {
                        newCollection.add(new CreatePartitionsAssignment(_readable, _version));
                    }
                    this.assignments = newCollection;
                }
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    this.assignments = null;
                } else {
                    newCollection = new ArrayList<CreatePartitionsAssignment>(arrayLength);
                    for (i2 = 0; i2 < arrayLength; ++i2) {
                        newCollection.add(new CreatePartitionsAssignment(_readable, _version));
                    }
                    this.assignments = newCollection;
                }
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.count);
            if (_version >= 2) {
                if (this.assignments == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.assignments.size() + 1);
                    _stringBytes = this.assignments.iterator();
                    while (_stringBytes.hasNext()) {
                        CreatePartitionsAssignment assignmentsElement = (CreatePartitionsAssignment)_stringBytes.next();
                        assignmentsElement.write(_writable, _cache, _version);
                    }
                }
            } else if (this.assignments == null) {
                _writable.writeInt(-1);
            } else {
                _writable.writeInt(this.assignments.size());
                _stringBytes = this.assignments.iterator();
                while (_stringBytes.hasNext()) {
                    CreatePartitionsAssignment assignmentsElement = (CreatePartitionsAssignment)_stringBytes.next();
                    assignmentsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatePartitionsTopic");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.name = struct.getString("name");
            this.count = struct.getInt("count");
            Object[] _nestedObjects = struct.getArray("assignments");
            if (_nestedObjects == null) {
                this.assignments = null;
            } else {
                this.assignments = new ArrayList<CreatePartitionsAssignment>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.assignments.add(new CreatePartitionsAssignment((Struct)nestedObject, _version));
                }
            }
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatePartitionsTopic");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            struct.set("count", (Object)this.count);
            if (this.assignments == null) {
                struct.set("assignments", null);
            } else {
                Struct[] _nestedObjects = new Struct[this.assignments.size()];
                int i2 = 0;
                for (CreatePartitionsAssignment element : this.assignments) {
                    _nestedObjects[i2++] = element.toStruct(_version);
                }
                struct.set("assignments", (Object)_nestedObjects);
            }
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatePartitionsTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            _size += 4;
            if (this.assignments == null) {
                _size = _version >= 2 ? ++_size : (_size += 4);
            } else {
                int _arraySize = 0;
                _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.assignments.size() + 1)) : (_arraySize += 4);
                for (CreatePartitionsAssignment assignmentsElement : this.assignments) {
                    _arraySize += assignmentsElement.size(_cache, _version);
                }
                _size += _arraySize;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof CreatePartitionsTopic)) {
                return false;
            }
            CreatePartitionsTopic other = (CreatePartitionsTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatePartitionsTopic)) {
                return false;
            }
            CreatePartitionsTopic other = (CreatePartitionsTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.count != other.count) {
                return false;
            }
            if (this.assignments == null ? other.assignments != null : !this.assignments.equals(other.assignments)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public CreatePartitionsTopic duplicate() {
            CreatePartitionsTopic _duplicate = new CreatePartitionsTopic();
            _duplicate.name = this.name;
            _duplicate.count = this.count;
            if (this.assignments == null) {
                _duplicate.assignments = null;
            } else {
                ArrayList<CreatePartitionsAssignment> newAssignments = new ArrayList<CreatePartitionsAssignment>(this.assignments.size());
                for (CreatePartitionsAssignment _element : this.assignments) {
                    newAssignments.add(_element.duplicate());
                }
                _duplicate.assignments = newAssignments;
            }
            return _duplicate;
        }

        public String toString() {
            return "CreatePartitionsTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", count=" + this.count + ", assignments=" + (this.assignments == null ? "null" : MessageUtil.deepToString(this.assignments.iterator())) + ")";
        }

        public String name() {
            return this.name;
        }

        public int count() {
            return this.count;
        }

        public List<CreatePartitionsAssignment> assignments() {
            return this.assignments;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatePartitionsTopic setName(String v2) {
            this.name = v2;
            return this;
        }

        public CreatePartitionsTopic setCount(int v2) {
            this.count = v2;
            return this;
        }

        public CreatePartitionsTopic setAssignments(List<CreatePartitionsAssignment> v2) {
            this.assignments = v2;
            return this;
        }

        @Override
        public void setNext(int v2) {
            this.next = v2;
        }

        @Override
        public void setPrev(int v2) {
            this.prev = v2;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("count", Type.INT32, "The new partition count."), new Field("assignments", ArrayOf.nullable(CreatePartitionsAssignment.SCHEMA_0), "The new partition assignments."));
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("count", Type.INT32, "The new partition count."), new Field("assignments", CompactArrayOf.nullable(CreatePartitionsAssignment.SCHEMA_2), "The new partition assignments."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

