/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiMessage;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Message;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.MessageUtil;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Readable;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Writable;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Type;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ByteUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Bytes;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProduceRequestData
implements ApiMessage {
    String transactionalId;
    short acks;
    int timeoutMs;
    List<TopicProduceData> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 8;

    public ProduceRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ProduceRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public ProduceRequestData() {
        this.transactionalId = "";
        this.acks = 0;
        this.timeoutMs = 0;
        this.topics = new ArrayList<TopicProduceData>(0);
    }

    @Override
    public short apiKey() {
        return 0;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 8;
    }

    @Override
    public void read(Readable _readable, short _version) {
        if (_version >= 3) {
            short length = _readable.readShort();
            if (length < 0) {
                this.transactionalId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field transactionalId had invalid length " + length);
                }
                this.transactionalId = _readable.readString(length);
            }
        } else {
            this.transactionalId = "";
        }
        this.acks = _readable.readShort();
        this.timeoutMs = _readable.readInt();
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        ArrayList<TopicProduceData> newCollection = new ArrayList<TopicProduceData>(arrayLength);
        for (int i2 = 0; i2 < arrayLength; ++i2) {
            newCollection.add(new TopicProduceData(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (_version >= 3) {
            if (this.transactionalId == null) {
                _writable.writeShort((short)-1);
            } else {
                _stringBytes = _cache.getSerializedValue(this.transactionalId);
                _writable.writeShort((short)((byte[])_stringBytes).length);
                _writable.writeByteArray((byte[])_stringBytes);
            }
        } else if (this.transactionalId == null || !this.transactionalId.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default transactionalId at version " + _version);
        }
        _writable.writeShort(this.acks);
        _writable.writeInt(this.timeoutMs);
        _writable.writeInt(this.topics.size());
        _stringBytes = this.topics.iterator();
        while (_stringBytes.hasNext()) {
            TopicProduceData topicsElement = (TopicProduceData)_stringBytes.next();
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.transactionalId = _version >= 3 ? struct.getString("transactional_id") : "";
        this.acks = struct.getShort("acks");
        this.timeoutMs = struct.getInt("timeout_ms");
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<TopicProduceData>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new TopicProduceData((Struct)nestedObject, _version));
        }
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 3) {
            struct.set("transactional_id", (Object)this.transactionalId);
        } else if (this.transactionalId == null || !this.transactionalId.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default transactionalId at version " + _version);
        }
        struct.set("acks", (Object)this.acks);
        struct.set("timeout_ms", (Object)this.timeoutMs);
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i2 = 0;
        for (TopicProduceData element : this.topics) {
            _nestedObjects[i2++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 3) {
            if (this.transactionalId == null) {
                _size += 2;
            } else {
                byte[] _stringBytes = this.transactionalId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'transactionalId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.transactionalId, _stringBytes);
                _size += _stringBytes.length + 2;
            }
        }
        _size += 2;
        _size += 4;
        int _arraySize = 0;
        _arraySize += 4;
        for (TopicProduceData topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProduceRequestData)) {
            return false;
        }
        ProduceRequestData other = (ProduceRequestData)obj;
        if (this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId)) {
            return false;
        }
        if (this.acks != other.acks) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.transactionalId == null ? 0 : this.transactionalId.hashCode());
        hashCode = 31 * hashCode + this.acks;
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public ProduceRequestData duplicate() {
        ProduceRequestData _duplicate = new ProduceRequestData();
        _duplicate.transactionalId = this.transactionalId == null ? null : this.transactionalId;
        _duplicate.acks = this.acks;
        _duplicate.timeoutMs = this.timeoutMs;
        ArrayList<TopicProduceData> newTopics = new ArrayList<TopicProduceData>(this.topics.size());
        for (TopicProduceData _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "ProduceRequestData(transactionalId=" + (this.transactionalId == null ? "null" : "'" + this.transactionalId.toString() + "'") + ", acks=" + this.acks + ", timeoutMs=" + this.timeoutMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public short acks() {
        return this.acks;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public List<TopicProduceData> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ProduceRequestData setTransactionalId(String v2) {
        this.transactionalId = v2;
        return this;
    }

    public ProduceRequestData setAcks(short v2) {
        this.acks = v2;
        return this;
    }

    public ProduceRequestData setTimeoutMs(int v2) {
        this.timeoutMs = v2;
        return this;
    }

    public ProduceRequestData setTopics(List<TopicProduceData> v2) {
        this.topics = v2;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("acks", Type.INT16, "The number of acknowledgments the producer requires the leader to have received before considering a request complete. Allowed values: 0 for no acknowledgments, 1 for only the leader and -1 for the full ISR."), new Field("timeout_ms", Type.INT32, "The timeout to await a response in miliseconds."), new Field("topics", new ArrayOf(TopicProduceData.SCHEMA_0), "Each topic to produce to.")));
        SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = new Schema(new Field("transactional_id", Type.NULLABLE_STRING, "The transactional ID, or null if the producer is not transactional."), new Field("acks", Type.INT16, "The number of acknowledgments the producer requires the leader to have received before considering a request complete. Allowed values: 0 for no acknowledgments, 1 for only the leader and -1 for the full ISR."), new Field("timeout_ms", Type.INT32, "The timeout to await a response in miliseconds."), new Field("topics", new ArrayOf(TopicProduceData.SCHEMA_0), "Each topic to produce to."))))));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8};
    }

    public static class PartitionProduceData
    implements Message {
        int partitionIndex;
        byte[] records;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 8;

        public PartitionProduceData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public PartitionProduceData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public PartitionProduceData() {
            this.partitionIndex = 0;
            this.records = Bytes.EMPTY;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 8;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionProduceData");
            }
            this.partitionIndex = _readable.readInt();
            int length = _readable.readInt();
            if (length < 0) {
                this.records = null;
            } else {
                byte[] newBytes = new byte[length];
                _readable.readArray(newBytes);
                this.records = newBytes;
            }
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            if (this.records == null) {
                _writable.writeInt(-1);
            } else {
                _writable.writeInt(this.records.length);
                _writable.writeByteArray(this.records);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionProduceData");
            }
            this._unknownTaggedFields = null;
            this.partitionIndex = struct.getInt("partition_index");
            this.records = struct.getByteArray("records");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of PartitionProduceData");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.setByteArray("records", this.records);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionProduceData");
            }
            _size += 4;
            if (this.records == null) {
                _size += 4;
            } else {
                int _bytesSize = this.records.length;
                _size += (_bytesSize += 4);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionProduceData)) {
                return false;
            }
            PartitionProduceData other = (PartitionProduceData)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (!Arrays.equals(this.records, other.records)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + Arrays.hashCode(this.records);
            return hashCode;
        }

        @Override
        public PartitionProduceData duplicate() {
            PartitionProduceData _duplicate = new PartitionProduceData();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.records = (byte[])(this.records == null ? null : MessageUtil.duplicate(this.records));
            return _duplicate;
        }

        public String toString() {
            return "PartitionProduceData(partitionIndex=" + this.partitionIndex + ", records=" + Arrays.toString(this.records) + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public byte[] records() {
            return this.records;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionProduceData setPartitionIndex(int v2) {
            this.partitionIndex = v2;
            return this;
        }

        public PartitionProduceData setRecords(byte[] v2) {
            this.records = v2;
            return this;
        }

        static {
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("records", Type.NULLABLE_BYTES, "The record data to be produced.")))))))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8};
        }
    }

    public static class TopicProduceData
    implements Message {
        String name;
        List<PartitionProduceData> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 8;

        public TopicProduceData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicProduceData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public TopicProduceData() {
            this.name = "";
            this.partitions = new ArrayList<PartitionProduceData>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 8;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicProduceData");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            ArrayList<PartitionProduceData> newCollection = new ArrayList<PartitionProduceData>(arrayLength);
            for (int i2 = 0; i2 < arrayLength; ++i2) {
                newCollection.add(new PartitionProduceData(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                PartitionProduceData partitionsElement = (PartitionProduceData)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicProduceData");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<PartitionProduceData>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new PartitionProduceData((Struct)nestedObject, _version));
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TopicProduceData");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i2 = 0;
            for (PartitionProduceData element : this.partitions) {
                _nestedObjects[i2++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 8) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicProduceData");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            for (PartitionProduceData partitionsElement : this.partitions) {
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicProduceData)) {
                return false;
            }
            TopicProduceData other = (TopicProduceData)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public TopicProduceData duplicate() {
            TopicProduceData _duplicate = new TopicProduceData();
            _duplicate.name = this.name;
            ArrayList<PartitionProduceData> newPartitions = new ArrayList<PartitionProduceData>(this.partitions.size());
            for (PartitionProduceData _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicProduceData(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<PartitionProduceData> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicProduceData setName(String v2) {
            this.name = v2;
            return this;
        }

        public TopicProduceData setPartitions(List<PartitionProduceData> v2) {
            this.partitions = v2;
            return this;
        }

        static {
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(PartitionProduceData.SCHEMA_0), "Each partition to produce to.")))))))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8};
        }
    }
}

