/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.BoundField;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.SchemaException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Type;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Schema
extends Type {
    private static final Object[] NO_VALUES = new Object[0];
    private final BoundField[] fields;
    private final Map<String, BoundField> fieldsByName;
    private final boolean tolerateMissingFieldsWithDefaults;
    private final Struct cachedStruct;

    public Schema(Field ... fs) {
        this(false, fs);
    }

    public Schema(boolean tolerateMissingFieldsWithDefaults, Field ... fs) {
        this.fields = new BoundField[fs.length];
        this.fieldsByName = new HashMap<String, BoundField>();
        this.tolerateMissingFieldsWithDefaults = tolerateMissingFieldsWithDefaults;
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            Field def = fs[i2];
            if (this.fieldsByName.containsKey(def.name)) {
                throw new SchemaException("Schema contains a duplicate field: " + def.name);
            }
            this.fields[i2] = new BoundField(def, this, i2);
            this.fieldsByName.put(def.name, this.fields[i2]);
        }
        this.cachedStruct = this.fields.length > 0 ? null : new Struct(this, NO_VALUES);
    }

    @Override
    public void write(ByteBuffer buffer, Object o2) {
        Struct r2 = (Struct)o2;
        for (BoundField field : this.fields) {
            try {
                Object value = field.def.type.validate(r2.get(field));
                field.def.type.write(buffer, value);
            }
            catch (Exception e2) {
                throw new SchemaException("Error writing field '" + field.def.name + "': " + (e2.getMessage() == null ? e2.getClass().getName() : e2.getMessage()));
            }
        }
    }

    @Override
    public Struct read(ByteBuffer buffer) {
        if (this.cachedStruct != null) {
            return this.cachedStruct;
        }
        Object[] objects = new Object[this.fields.length];
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            try {
                if (this.tolerateMissingFieldsWithDefaults) {
                    if (buffer.hasRemaining()) {
                        objects[i2] = this.fields[i2].def.type.read(buffer);
                        continue;
                    }
                    if (this.fields[i2].def.hasDefaultValue) {
                        objects[i2] = this.fields[i2].def.defaultValue;
                        continue;
                    }
                    throw new SchemaException("Missing value for field '" + this.fields[i2].def.name + "' which has no default value.");
                }
                objects[i2] = this.fields[i2].def.type.read(buffer);
                continue;
            }
            catch (Exception e2) {
                throw new SchemaException("Error reading field '" + this.fields[i2].def.name + "': " + (e2.getMessage() == null ? e2.getClass().getName() : e2.getMessage()));
            }
        }
        return new Struct(this, objects);
    }

    @Override
    public int sizeOf(Object o2) {
        int size = 0;
        Struct r2 = (Struct)o2;
        for (BoundField field : this.fields) {
            try {
                size += field.def.type.sizeOf(r2.get(field));
            }
            catch (Exception e2) {
                throw new SchemaException("Error computing size for field '" + field.def.name + "': " + (e2.getMessage() == null ? e2.getClass().getName() : e2.getMessage()));
            }
        }
        return size;
    }

    public int numFields() {
        return this.fields.length;
    }

    public BoundField get(int slot) {
        return this.fields[slot];
    }

    public BoundField get(String name) {
        return this.fieldsByName.get(name);
    }

    public BoundField[] fields() {
        return this.fields;
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder();
        b2.append('{');
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            b2.append(this.fields[i2].toString());
            if (i2 >= this.fields.length - 1) continue;
            b2.append(',');
        }
        b2.append("}");
        return b2.toString();
    }

    @Override
    public Struct validate(Object item) {
        try {
            Struct struct = (Struct)item;
            for (BoundField field : this.fields) {
                try {
                    field.def.type.validate(struct.get(field));
                }
                catch (SchemaException e2) {
                    throw new SchemaException("Invalid value for field '" + field.def.name + "': " + e2.getMessage());
                }
            }
            return struct;
        }
        catch (ClassCastException e3) {
            throw new SchemaException("Not a Struct.");
        }
    }

    public void walk(Visitor visitor) {
        Objects.requireNonNull(visitor, "visitor must be non-null");
        Schema.handleNode(this, visitor);
    }

    private static void handleNode(Type node, Visitor visitor) {
        if (node instanceof Schema) {
            Schema schema = (Schema)node;
            visitor.visit(schema);
            for (BoundField f2 : schema.fields()) {
                Schema.handleNode(f2.def.type, visitor);
            }
        } else if (node.isArray()) {
            visitor.visit(node);
            Schema.handleNode(node.arrayElementType().get(), visitor);
        } else {
            visitor.visit(node);
        }
    }

    public static abstract class Visitor {
        public void visit(Schema schema) {
        }

        public void visit(Type field) {
        }
    }
}

