/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.DescribeConfigsRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.DescribeConfigsResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.DescribeConfigsResponse;
import java.nio.ByteBuffer;
import java.util.stream.Collectors;

public class DescribeConfigsRequest
extends AbstractRequest {
    private final DescribeConfigsRequestData data;

    public DescribeConfigsRequest(DescribeConfigsRequestData data, short version) {
        super(ApiKeys.DESCRIBE_CONFIGS, version);
        this.data = data;
    }

    public DescribeConfigsRequest(Struct struct, short version) {
        super(ApiKeys.DESCRIBE_CONFIGS, version);
        this.data = new DescribeConfigsRequestData(struct, version);
    }

    public DescribeConfigsRequestData data() {
        return this.data;
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    @Override
    public DescribeConfigsResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        Errors error = Errors.forException(e2);
        return new DescribeConfigsResponse(new DescribeConfigsResponseData().setThrottleTimeMs(throttleTimeMs).setResults(this.data.resources().stream().map(result -> new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(error.code()).setErrorMessage(error.message()).setResourceName(result.resourceName()).setResourceType(result.resourceType())).collect(Collectors.toList())));
    }

    public static DescribeConfigsRequest parse(ByteBuffer buffer, short version) {
        return new DescribeConfigsRequest(ApiKeys.DESCRIBE_CONFIGS.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeConfigsRequest> {
        private final DescribeConfigsRequestData data;

        public Builder(DescribeConfigsRequestData data) {
            super(ApiKeys.DESCRIBE_CONFIGS);
            this.data = data;
        }

        @Override
        public DescribeConfigsRequest build(short version) {
            return new DescribeConfigsRequest(this.data, version);
        }
    }
}

