/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.InitProducerIdRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.InitProducerIdResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.InitProducerIdResponse;
import java.nio.ByteBuffer;

public class InitProducerIdRequest
extends AbstractRequest {
    public final InitProducerIdRequestData data;

    private InitProducerIdRequest(InitProducerIdRequestData data, short version) {
        super(ApiKeys.INIT_PRODUCER_ID, version);
        this.data = data;
    }

    public InitProducerIdRequest(Struct struct, short version) {
        super(ApiKeys.INIT_PRODUCER_ID, version);
        this.data = new InitProducerIdRequestData(struct, version);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        InitProducerIdResponseData response = new InitProducerIdResponseData().setErrorCode(Errors.forException(e2).code()).setProducerId(-1L).setProducerEpoch((short)-1).setThrottleTimeMs(0);
        return new InitProducerIdResponse(response);
    }

    public static InitProducerIdRequest parse(ByteBuffer buffer, short version) {
        return new InitProducerIdRequest(ApiKeys.INIT_PRODUCER_ID.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractRequest.Builder<InitProducerIdRequest> {
        private final InitProducerIdRequestData data;

        public Builder(InitProducerIdRequestData data) {
            super(ApiKeys.INIT_PRODUCER_ID);
            this.data = data;
        }

        @Override
        public InitProducerIdRequest build(short version) {
            if (this.data.transactionTimeoutMs() <= 0) {
                throw new IllegalArgumentException("transaction timeout value is not positive: " + this.data.transactionTimeoutMs());
            }
            if (this.data.transactionalId() != null && this.data.transactionalId().isEmpty()) {
                throw new IllegalArgumentException("Must set either a null or a non-empty transactional id.");
            }
            return new InitProducerIdRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

