/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.StopReplicaRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.StopReplicaResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractControlRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.StopReplicaResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.MappedIterator;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StopReplicaRequest
extends AbstractControlRequest {
    private final StopReplicaRequestData data;

    private StopReplicaRequest(StopReplicaRequestData data, short version) {
        super(ApiKeys.STOP_REPLICA, version);
        this.data = data;
    }

    public StopReplicaRequest(Struct struct, short version) {
        this(new StopReplicaRequestData(struct, version), version);
    }

    @Override
    public StopReplicaResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        Errors error = Errors.forException(e2);
        StopReplicaResponseData data = new StopReplicaResponseData();
        data.setErrorCode(error.code());
        ArrayList<StopReplicaResponseData.StopReplicaPartitionError> partitions = new ArrayList<StopReplicaResponseData.StopReplicaPartitionError>();
        for (StopReplicaRequestData.StopReplicaTopicState topic : this.topicStates()) {
            for (StopReplicaRequestData.StopReplicaPartitionState partition : topic.partitionStates()) {
                partitions.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName(topic.topicName()).setPartitionIndex(partition.partitionIndex()).setErrorCode(error.code()));
            }
        }
        data.setPartitionErrors(partitions);
        return new StopReplicaResponse(data);
    }

    public Iterable<StopReplicaRequestData.StopReplicaTopicState> topicStates() {
        if (this.version() < 1) {
            HashMap<String, StopReplicaRequestData.StopReplicaTopicState> topicStates = new HashMap<String, StopReplicaRequestData.StopReplicaTopicState>();
            for (StopReplicaRequestData.StopReplicaPartitionV0 partition : this.data.ungroupedPartitions()) {
                StopReplicaRequestData.StopReplicaTopicState topicState = topicStates.computeIfAbsent(partition.topicName(), topic -> new StopReplicaRequestData.StopReplicaTopicState().setTopicName((String)topic));
                topicState.partitionStates().add(new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(partition.partitionIndex()).setDeletePartition(this.data.deletePartitions()));
            }
            return topicStates.values();
        }
        if (this.version() < 3) {
            return () -> new MappedIterator<StopReplicaRequestData.StopReplicaTopicV1, StopReplicaRequestData.StopReplicaTopicState>(this.data.topics().iterator(), topic -> new StopReplicaRequestData.StopReplicaTopicState().setTopicName(topic.name()).setPartitionStates(topic.partitionIndexes().stream().map(partition -> new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex((int)partition).setDeletePartition(this.data.deletePartitions())).collect(Collectors.toList())));
        }
        return this.data.topicStates();
    }

    public Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState> partitionStates() {
        HashMap<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState> partitionStates = new HashMap<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState>();
        if (this.version() < 1) {
            for (StopReplicaRequestData.StopReplicaPartitionV0 partition : this.data.ungroupedPartitions()) {
                partitionStates.put(new TopicPartition(partition.topicName(), partition.partitionIndex()), new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(partition.partitionIndex()).setDeletePartition(this.data.deletePartitions()));
            }
        } else if (this.version() < 3) {
            for (StopReplicaRequestData.StopReplicaTopicV1 topic : this.data.topics()) {
                for (Integer partitionIndex : topic.partitionIndexes()) {
                    partitionStates.put(new TopicPartition(topic.name(), partitionIndex), new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(partitionIndex).setDeletePartition(this.data.deletePartitions()));
                }
            }
        } else {
            for (StopReplicaRequestData.StopReplicaTopicState topicState : this.data.topicStates()) {
                for (StopReplicaRequestData.StopReplicaPartitionState partitionState : topicState.partitionStates()) {
                    partitionStates.put(new TopicPartition(topicState.topicName(), partitionState.partitionIndex()), partitionState);
                }
            }
        }
        return partitionStates;
    }

    @Override
    public int controllerId() {
        return this.data.controllerId();
    }

    @Override
    public int controllerEpoch() {
        return this.data.controllerEpoch();
    }

    @Override
    public long brokerEpoch() {
        return this.data.brokerEpoch();
    }

    public static StopReplicaRequest parse(ByteBuffer buffer, short version) {
        return new StopReplicaRequest(ApiKeys.STOP_REPLICA.parseRequest(version, buffer), version);
    }

    public StopReplicaRequestData data() {
        return this.data;
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractControlRequest.Builder<StopReplicaRequest> {
        private final boolean deletePartitions;
        private final List<StopReplicaRequestData.StopReplicaTopicState> topicStates;

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, boolean deletePartitions, List<StopReplicaRequestData.StopReplicaTopicState> topicStates) {
            super(ApiKeys.STOP_REPLICA, version, controllerId, controllerEpoch, brokerEpoch);
            this.deletePartitions = deletePartitions;
            this.topicStates = topicStates;
        }

        @Override
        public StopReplicaRequest build(short version) {
            StopReplicaRequestData data = new StopReplicaRequestData().setControllerId(this.controllerId).setControllerEpoch(this.controllerEpoch).setBrokerEpoch(this.brokerEpoch);
            if (version >= 3) {
                data.setTopicStates(this.topicStates);
            } else if (version >= 1) {
                data.setDeletePartitions(this.deletePartitions);
                List<StopReplicaRequestData.StopReplicaTopicV1> topics = this.topicStates.stream().map(topic -> new StopReplicaRequestData.StopReplicaTopicV1().setName(topic.topicName()).setPartitionIndexes(topic.partitionStates().stream().map(StopReplicaRequestData.StopReplicaPartitionState::partitionIndex).collect(Collectors.toList()))).collect(Collectors.toList());
                data.setTopics(topics);
            } else {
                data.setDeletePartitions(this.deletePartitions);
                List<StopReplicaRequestData.StopReplicaPartitionV0> partitions = this.topicStates.stream().flatMap(topic -> topic.partitionStates().stream().map(partition -> new StopReplicaRequestData.StopReplicaPartitionV0().setTopicName(topic.topicName()).setPartitionIndex(partition.partitionIndex()))).collect(Collectors.toList());
                data.setUngroupedPartitions(partitions);
            }
            return new StopReplicaRequest(data, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=StopReplicaRequest").append(", controllerId=").append(this.controllerId).append(", controllerEpoch=").append(this.controllerEpoch).append(", brokerEpoch=").append(this.brokerEpoch).append(", deletePartitions=").append(this.deletePartitions).append(", topicStates=").append(Utils.join(this.topicStates, ",")).append(")");
            return bld.toString();
        }
    }
}

