/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.SyncGroupRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.SyncGroupResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.SyncGroupResponse;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class SyncGroupRequest
extends AbstractRequest {
    public final SyncGroupRequestData data;

    public SyncGroupRequest(SyncGroupRequestData data, short version) {
        super(ApiKeys.SYNC_GROUP, version);
        this.data = data;
    }

    public SyncGroupRequest(Struct struct, short version) {
        super(ApiKeys.SYNC_GROUP, version);
        this.data = new SyncGroupRequestData(struct, version);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        return new SyncGroupResponse(new SyncGroupResponseData().setErrorCode(Errors.forException(e2).code()).setAssignment(new byte[0]).setThrottleTimeMs(throttleTimeMs));
    }

    public Map<String, ByteBuffer> groupAssignments() {
        HashMap<String, ByteBuffer> groupAssignments = new HashMap<String, ByteBuffer>();
        for (SyncGroupRequestData.SyncGroupRequestAssignment assignment : this.data.assignments()) {
            groupAssignments.put(assignment.memberId(), ByteBuffer.wrap(assignment.assignment()));
        }
        return groupAssignments;
    }

    public boolean areMandatoryProtocolTypeAndNamePresent() {
        if (this.version() >= 5) {
            return this.data.protocolType() != null && this.data.protocolName() != null;
        }
        return true;
    }

    public static SyncGroupRequest parse(ByteBuffer buffer, short version) {
        return new SyncGroupRequest(ApiKeys.SYNC_GROUP.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractRequest.Builder<SyncGroupRequest> {
        private final SyncGroupRequestData data;

        public Builder(SyncGroupRequestData data) {
            super(ApiKeys.SYNC_GROUP);
            this.data = data;
        }

        @Override
        public SyncGroupRequest build(short version) {
            if (this.data.groupInstanceId() != null && version < 3) {
                throw new UnsupportedVersionException("The broker sync group protocol version " + version + " does not support usage of config group.instance.id.");
            }
            return new SyncGroupRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

