/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.KafkaException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import javax.management.ObjectName;

public class Sanitizer {
    private static final Pattern MBEAN_PATTERN = Pattern.compile("[\\w-%\\. \t]*");

    public static String sanitize(String name) {
        String encoded = "";
        try {
            encoded = URLEncoder.encode(name, StandardCharsets.UTF_8.name());
            StringBuilder builder = new StringBuilder();
            for (int i2 = 0; i2 < encoded.length(); ++i2) {
                char c2 = encoded.charAt(i2);
                if (c2 == '*') {
                    builder.append("%2A");
                    continue;
                }
                if (c2 == '+') {
                    builder.append("%20");
                    continue;
                }
                builder.append(c2);
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException e2) {
            throw new KafkaException(e2);
        }
    }

    public static String desanitize(String name) {
        try {
            return URLDecoder.decode(name, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e2) {
            throw new KafkaException(e2);
        }
    }

    public static String jmxSanitize(String name) {
        return MBEAN_PATTERN.matcher(name).matches() ? name : ObjectName.quote(name);
    }
}

