/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.header.ConnectHeaders;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.header.Header;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.header.Headers;
import java.util.Objects;

public abstract class ConnectRecord<R extends ConnectRecord<R>> {
    private final String topic;
    private final Integer kafkaPartition;
    private final Schema keySchema;
    private final Object key;
    private final Schema valueSchema;
    private final Object value;
    private final Long timestamp;
    private final Headers headers;

    public ConnectRecord(String topic, Integer kafkaPartition, Schema keySchema, Object key, Schema valueSchema, Object value, Long timestamp) {
        this(topic, kafkaPartition, keySchema, key, valueSchema, value, timestamp, new ConnectHeaders());
    }

    public ConnectRecord(String topic, Integer kafkaPartition, Schema keySchema, Object key, Schema valueSchema, Object value, Long timestamp, Iterable<Header> headers) {
        this.topic = topic;
        this.kafkaPartition = kafkaPartition;
        this.keySchema = keySchema;
        this.key = key;
        this.valueSchema = valueSchema;
        this.value = value;
        this.timestamp = timestamp;
        this.headers = headers instanceof ConnectHeaders ? (ConnectHeaders)headers : new ConnectHeaders(headers);
    }

    public String topic() {
        return this.topic;
    }

    public Integer kafkaPartition() {
        return this.kafkaPartition;
    }

    public Object key() {
        return this.key;
    }

    public Schema keySchema() {
        return this.keySchema;
    }

    public Object value() {
        return this.value;
    }

    public Schema valueSchema() {
        return this.valueSchema;
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public Headers headers() {
        return this.headers;
    }

    public abstract R newRecord(String var1, Integer var2, Schema var3, Object var4, Schema var5, Object var6, Long var7);

    public abstract R newRecord(String var1, Integer var2, Schema var3, Object var4, Schema var5, Object var6, Long var7, Iterable<Header> var8);

    public String toString() {
        return "ConnectRecord{topic='" + this.topic + '\'' + ", kafkaPartition=" + this.kafkaPartition + ", key=" + this.key + ", keySchema=" + this.keySchema + ", value=" + this.value + ", valueSchema=" + this.valueSchema + ", timestamp=" + this.timestamp + ", headers=" + this.headers + '}';
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ConnectRecord that = (ConnectRecord)o2;
        return Objects.equals(this.kafkaPartition, that.kafkaPartition) && Objects.equals(this.topic, that.topic) && Objects.equals(this.keySchema, that.keySchema) && Objects.equals(this.key, that.key) && Objects.equals(this.valueSchema, that.valueSchema) && Objects.equals(this.value, that.value) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        int result = this.topic != null ? this.topic.hashCode() : 0;
        result = 31 * result + (this.kafkaPartition != null ? this.kafkaPartition.hashCode() : 0);
        result = 31 * result + (this.keySchema != null ? this.keySchema.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.valueSchema != null ? this.valueSchema.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        result = 31 * result + this.headers.hashCode();
        return result;
    }
}

