/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.json;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.SerializationException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.Serializer;
import java.util.Collections;
import java.util.Set;

public class JsonSerializer
implements Serializer<JsonNode> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonSerializer() {
        this(Collections.emptySet(), JsonNodeFactory.withExactBigDecimals(true));
    }

    JsonSerializer(Set<SerializationFeature> serializationFeatures, JsonNodeFactory jsonNodeFactory) {
        serializationFeatures.forEach(this.objectMapper::enable);
        this.objectMapper.setNodeFactory(jsonNodeFactory);
    }

    @Override
    public byte[] serialize(String topic, JsonNode data) {
        if (data == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsBytes(data);
        }
        catch (Exception e2) {
            throw new SerializationException("Error serializing JSON message", e2);
        }
    }
}

