/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.ProducerConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.AbstractConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.Config;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigTransformer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigValue;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.Connector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.policy.ConnectorClientConfigRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.NotFoundException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.AbstractStatus;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.ConnectorConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.ConnectorStatus;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.Herder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.SinkConnectorConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.SourceConnectorConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.TargetState;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.TaskStatus;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.TopicStatus;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.Worker;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.distributed.ClusterConfigState;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.isolation.Plugins;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.entities.ActiveTopicsInfo;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.entities.ConfigInfo;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.entities.ConfigInfos;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.entities.ConfigKeyInfo;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.entities.ConfigValueInfo;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.entities.ConnectorStateInfo;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.entities.ConnectorType;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.errors.BadRequestException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceConnector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.ConfigBackingStore;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.StatusBackingStore;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.util.Callback;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.util.ConnectorTaskId;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class AbstractHerder
implements Herder,
TaskStatus.Listener,
ConnectorStatus.Listener {
    private final String workerId;
    protected final Worker worker;
    private final String kafkaClusterId;
    protected final StatusBackingStore statusBackingStore;
    protected final ConfigBackingStore configBackingStore;
    private final ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy;
    protected volatile boolean running = false;
    private final ExecutorService connectorExecutor;
    private Map<String, Connector> tempConnectors = new ConcurrentHashMap<String, Connector>();

    public AbstractHerder(Worker worker, String workerId, String kafkaClusterId, StatusBackingStore statusBackingStore, ConfigBackingStore configBackingStore, ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy) {
        this.worker = worker;
        this.worker.herder = this;
        this.workerId = workerId;
        this.kafkaClusterId = kafkaClusterId;
        this.statusBackingStore = statusBackingStore;
        this.configBackingStore = configBackingStore;
        this.connectorClientConfigOverridePolicy = connectorClientConfigOverridePolicy;
        this.connectorExecutor = Executors.newCachedThreadPool();
    }

    @Override
    public String kafkaClusterId() {
        return this.kafkaClusterId;
    }

    protected abstract int generation();

    protected void startServices() {
        this.worker.start();
        this.statusBackingStore.start();
        this.configBackingStore.start();
    }

    protected void stopServices() {
        this.statusBackingStore.stop();
        this.configBackingStore.stop();
        this.worker.stop();
        this.connectorExecutor.shutdown();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void onStartup(String connector) {
        this.statusBackingStore.put(new ConnectorStatus(connector, AbstractStatus.State.RUNNING, this.workerId, this.generation()));
    }

    @Override
    public void onPause(String connector) {
        this.statusBackingStore.put(new ConnectorStatus(connector, AbstractStatus.State.PAUSED, this.workerId, this.generation()));
    }

    @Override
    public void onResume(String connector) {
        this.statusBackingStore.put(new ConnectorStatus(connector, AbstractStatus.State.RUNNING, this.workerId, this.generation()));
    }

    @Override
    public void onShutdown(String connector) {
        this.statusBackingStore.putSafe(new ConnectorStatus(connector, AbstractStatus.State.UNASSIGNED, this.workerId, this.generation()));
    }

    @Override
    public void onFailure(String connector, Throwable cause) {
        this.statusBackingStore.putSafe(new ConnectorStatus(connector, AbstractStatus.State.FAILED, this.trace(cause), this.workerId, this.generation()));
    }

    @Override
    public void onStartup(ConnectorTaskId id) {
        this.statusBackingStore.put(new TaskStatus(id, AbstractStatus.State.RUNNING, this.workerId, this.generation()));
    }

    @Override
    public void onFailure(ConnectorTaskId id, Throwable cause) {
        this.statusBackingStore.putSafe(new TaskStatus(id, AbstractStatus.State.FAILED, this.workerId, this.generation(), this.trace(cause)));
    }

    @Override
    public void onShutdown(ConnectorTaskId id) {
        this.statusBackingStore.putSafe(new TaskStatus(id, AbstractStatus.State.UNASSIGNED, this.workerId, this.generation()));
    }

    @Override
    public void onResume(ConnectorTaskId id) {
        this.statusBackingStore.put(new TaskStatus(id, AbstractStatus.State.RUNNING, this.workerId, this.generation()));
    }

    @Override
    public void onPause(ConnectorTaskId id) {
        this.statusBackingStore.put(new TaskStatus(id, AbstractStatus.State.PAUSED, this.workerId, this.generation()));
    }

    @Override
    public void onDeletion(String connector) {
        for (TaskStatus status : this.statusBackingStore.getAll(connector)) {
            this.onDeletion((ConnectorTaskId)status.id());
        }
        this.statusBackingStore.put(new ConnectorStatus(connector, AbstractStatus.State.DESTROYED, this.workerId, this.generation()));
    }

    @Override
    public void onDeletion(ConnectorTaskId id) {
        this.statusBackingStore.put(new TaskStatus(id, AbstractStatus.State.DESTROYED, this.workerId, this.generation()));
    }

    @Override
    public void pauseConnector(String connector) {
        if (!this.configBackingStore.contains(connector)) {
            throw new NotFoundException("Unknown connector " + connector);
        }
        this.configBackingStore.putTargetState(connector, TargetState.PAUSED);
    }

    @Override
    public void resumeConnector(String connector) {
        if (!this.configBackingStore.contains(connector)) {
            throw new NotFoundException("Unknown connector " + connector);
        }
        this.configBackingStore.putTargetState(connector, TargetState.STARTED);
    }

    @Override
    public Plugins plugins() {
        return this.worker.getPlugins();
    }

    protected abstract Map<String, String> rawConfig(String var1);

    @Override
    public Collection<String> connectors() {
        return this.configBackingStore.snapshot().connectors();
    }

    @Override
    public ConnectorInfo connectorInfo(String connector) {
        ClusterConfigState configState = this.configBackingStore.snapshot();
        if (!configState.contains(connector)) {
            return null;
        }
        Map<String, String> config = configState.rawConnectorConfig(connector);
        return new ConnectorInfo(connector, config, configState.tasks(connector), this.connectorTypeForClass(config.get("connector.class")));
    }

    @Override
    public ConnectorStateInfo connectorStatus(String connName) {
        ConnectorStatus connector = this.statusBackingStore.get(connName);
        if (connector == null) {
            throw new NotFoundException("No status found for connector " + connName);
        }
        Collection<TaskStatus> tasks = this.statusBackingStore.getAll(connName);
        ConnectorStateInfo.ConnectorState connectorState = new ConnectorStateInfo.ConnectorState(connector.state().toString(), connector.workerId(), connector.trace());
        ArrayList<ConnectorStateInfo.TaskState> taskStates = new ArrayList<ConnectorStateInfo.TaskState>();
        for (TaskStatus status : tasks) {
            taskStates.add(new ConnectorStateInfo.TaskState(((ConnectorTaskId)status.id()).task(), status.state().toString(), status.workerId(), status.trace()));
        }
        Collections.sort(taskStates);
        Map<String, String> conf = this.rawConfig(connName);
        return new ConnectorStateInfo(connName, connectorState, taskStates, conf == null ? ConnectorType.UNKNOWN : this.connectorTypeForClass(conf.get("connector.class")));
    }

    @Override
    public ActiveTopicsInfo connectorActiveTopics(String connName) {
        Collection topics = this.statusBackingStore.getAllTopics(connName).stream().map(TopicStatus::topic).collect(Collectors.toList());
        return new ActiveTopicsInfo(connName, topics);
    }

    @Override
    public void resetConnectorActiveTopics(String connName) {
        this.statusBackingStore.getAllTopics(connName).stream().forEach(status -> this.statusBackingStore.deleteTopic(status.connector(), status.topic()));
    }

    @Override
    public StatusBackingStore statusBackingStore() {
        return this.statusBackingStore;
    }

    @Override
    public ConnectorStateInfo.TaskState taskStatus(ConnectorTaskId id) {
        TaskStatus status = this.statusBackingStore.get(id);
        if (status == null) {
            throw new NotFoundException("No status found for task " + id);
        }
        return new ConnectorStateInfo.TaskState(id.task(), status.state().toString(), status.workerId(), status.trace());
    }

    protected Map<String, ConfigValue> validateBasicConnectorConfig(Connector connector, ConfigDef configDef, Map<String, String> config) {
        return configDef.validateAll(config);
    }

    @Override
    public void validateConnectorConfig(Map<String, String> connectorProps, Callback<ConfigInfos> callback) {
        this.validateConnectorConfig(connectorProps, callback, true);
    }

    @Override
    public void validateConnectorConfig(Map<String, String> connectorProps, Callback<ConfigInfos> callback, boolean doLog) {
        this.connectorExecutor.submit(() -> {
            try {
                ConfigInfos result = this.validateConnectorConfig(connectorProps, doLog);
                callback.onCompletion(null, result);
            }
            catch (Throwable t2) {
                callback.onCompletion(t2, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigInfos validateConnectorConfig(Map<String, String> connectorProps, boolean doLog) {
        String connType;
        if (this.worker.configTransformer() != null) {
            connectorProps = this.worker.configTransformer().transform(connectorProps);
        }
        if ((connType = connectorProps.get("connector.class")) == null) {
            throw new BadRequestException("Connector config " + connectorProps + " contains no connector type");
        }
        Connector connector = this.getConnector(connType);
        ClassLoader savedLoader = this.plugins().compareAndSwapLoaders(connector);
        try {
            com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.health.ConnectorType connectorType;
            ConfigDef baseConfigDef;
            if (connector instanceof SourceConnector) {
                baseConfigDef = SourceConnectorConfig.configDef();
                connectorType = com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.health.ConnectorType.SOURCE;
            } else {
                baseConfigDef = SinkConnectorConfig.configDef();
                SinkConnectorConfig.validate(connectorProps);
                connectorType = com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.health.ConnectorType.SINK;
            }
            ConfigDef enrichedConfigDef = ConnectorConfig.enrich(this.plugins(), baseConfigDef, connectorProps, false);
            Map<String, ConfigValue> validatedConnectorConfig = this.validateBasicConnectorConfig(connector, enrichedConfigDef, connectorProps);
            ArrayList<ConfigValue> configValues = new ArrayList<ConfigValue>(validatedConnectorConfig.values());
            LinkedHashMap<String, ConfigDef.ConfigKey> configKeys = new LinkedHashMap<String, ConfigDef.ConfigKey>(enrichedConfigDef.configKeys());
            LinkedHashSet<String> allGroups = new LinkedHashSet<String>(enrichedConfigDef.groups());
            ConfigDef configDef = connector.config();
            if (null == configDef) {
                throw new BadRequestException(String.format("%s.config() must return a ConfigDef that is not null.", connector.getClass().getName()));
            }
            Config config = connector.validate(connectorProps);
            if (null == config) {
                throw new BadRequestException(String.format("%s.validate() must return a Config that is not null.", connector.getClass().getName()));
            }
            configKeys.putAll(configDef.configKeys());
            allGroups.addAll(configDef.groups());
            configValues.addAll(config.configValues());
            ConfigInfos configInfos = AbstractHerder.generateResult(connType, configKeys, configValues, new ArrayList<String>(allGroups));
            AbstractConfig connectorConfig = new AbstractConfig(new ConfigDef(), connectorProps, doLog);
            String connName = connectorProps.get("name");
            ConfigInfos producerConfigInfos = null;
            ConfigInfos consumerConfigInfos = null;
            ConfigInfos adminConfigInfos = null;
            if (connectorType.equals((Object)com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.health.ConnectorType.SOURCE)) {
                producerConfigInfos = AbstractHerder.validateClientOverrides(connName, "producer.override.", connectorConfig, ProducerConfig.configDef(), connector.getClass(), connectorType, ConnectorClientConfigRequest.ClientType.PRODUCER, this.connectorClientConfigOverridePolicy);
                ConfigInfos configInfos2 = AbstractHerder.mergeConfigInfos(connType, configInfos, producerConfigInfos);
                return configInfos2;
            }
            consumerConfigInfos = AbstractHerder.validateClientOverrides(connName, "consumer.override.", connectorConfig, ProducerConfig.configDef(), connector.getClass(), connectorType, ConnectorClientConfigRequest.ClientType.CONSUMER, this.connectorClientConfigOverridePolicy);
            String topic = connectorProps.get("errors.deadletterqueue.topic.name");
            if (topic != null && !topic.isEmpty()) {
                adminConfigInfos = AbstractHerder.validateClientOverrides(connName, "admin.override.", connectorConfig, ProducerConfig.configDef(), connector.getClass(), connectorType, ConnectorClientConfigRequest.ClientType.ADMIN, this.connectorClientConfigOverridePolicy);
            }
            ConfigInfos configInfos3 = AbstractHerder.mergeConfigInfos(connType, configInfos, producerConfigInfos, consumerConfigInfos, adminConfigInfos);
            return configInfos3;
        }
        finally {
            Plugins.compareAndSwapLoaders(savedLoader);
        }
    }

    private static ConfigInfos mergeConfigInfos(String connType, ConfigInfos ... configInfosList) {
        int errorCount = 0;
        LinkedList<ConfigInfo> configInfoList = new LinkedList<ConfigInfo>();
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        for (ConfigInfos configInfos : configInfosList) {
            if (configInfos == null) continue;
            errorCount += configInfos.errorCount();
            configInfoList.addAll(configInfos.values());
            groups.addAll(configInfos.groups());
        }
        return new ConfigInfos(connType, errorCount, new ArrayList<String>(groups), configInfoList);
    }

    private static ConfigInfos validateClientOverrides(String connName, String prefix, AbstractConfig connectorConfig, ConfigDef configDef, Class<? extends Connector> connectorClass, com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.health.ConnectorType connectorType, ConnectorClientConfigRequest.ClientType clientType, ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy) {
        ConfigDef.ConfigKey configKey;
        int errorCount = 0;
        LinkedList<ConfigInfo> configInfoList = new LinkedList<ConfigInfo>();
        Map<String, ConfigDef.ConfigKey> configKeys = configDef.configKeys();
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        HashMap<String, Object> clientConfigs = new HashMap<String, Object>();
        for (Map.Entry<String, Object> rawClientConfig : connectorConfig.originalsWithPrefix(prefix).entrySet()) {
            String configName = rawClientConfig.getKey();
            Object rawConfigValue = rawClientConfig.getValue();
            configKey = configDef.configKeys().get(configName);
            Object parsedConfigValue = configKey != null ? ConfigDef.parseType(configName, rawConfigValue, configKey.type) : rawConfigValue;
            clientConfigs.put(configName, parsedConfigValue);
        }
        ConnectorClientConfigRequest connectorClientConfigRequest = new ConnectorClientConfigRequest(connName, connectorType, connectorClass, clientConfigs, clientType);
        List<ConfigValue> configValues = connectorClientConfigOverridePolicy.validate(connectorClientConfigRequest);
        if (configValues != null) {
            for (ConfigValue validatedConfigValue : configValues) {
                ConfigValue configValue;
                configKey = configKeys.get(validatedConfigValue.name());
                ConfigKeyInfo configKeyInfo = null;
                if (configKey != null) {
                    if (configKey.group != null) {
                        groups.add(configKey.group);
                    }
                    configKeyInfo = AbstractHerder.convertConfigKey(configKey, prefix);
                }
                if ((configValue = new ConfigValue(prefix + validatedConfigValue.name(), validatedConfigValue.value(), validatedConfigValue.recommendedValues(), validatedConfigValue.errorMessages())).errorMessages().size() > 0) {
                    ++errorCount;
                }
                ConfigValueInfo configValueInfo = AbstractHerder.convertConfigValue(configValue, configKey != null ? configKey.type : null);
                configInfoList.add(new ConfigInfo(configKeyInfo, configValueInfo));
            }
        }
        return new ConfigInfos(connectorClass.toString(), errorCount, new ArrayList<String>(groups), configInfoList);
    }

    public static ConfigInfos generateResult(String connType, Map<String, ConfigDef.ConfigKey> configKeys, List<ConfigValue> configValues, List<String> groups) {
        String configName;
        int errorCount = 0;
        LinkedList<ConfigInfo> configInfoList = new LinkedList<ConfigInfo>();
        HashMap<String, ConfigValue> configValueMap = new HashMap<String, ConfigValue>();
        for (ConfigValue configValue : configValues) {
            configName = configValue.name();
            configValueMap.put(configName, configValue);
            if (configKeys.containsKey(configName)) continue;
            configInfoList.add(new ConfigInfo(null, AbstractHerder.convertConfigValue(configValue, null)));
            errorCount += configValue.errorMessages().size();
        }
        for (Map.Entry entry : configKeys.entrySet()) {
            configName = (String)entry.getKey();
            ConfigKeyInfo configKeyInfo = AbstractHerder.convertConfigKey((ConfigDef.ConfigKey)entry.getValue());
            ConfigDef.Type type = ((ConfigDef.ConfigKey)entry.getValue()).type;
            ConfigValueInfo configValueInfo = null;
            if (configValueMap.containsKey(configName)) {
                ConfigValue configValue = (ConfigValue)configValueMap.get(configName);
                configValueInfo = AbstractHerder.convertConfigValue(configValue, type);
                errorCount += configValue.errorMessages().size();
            }
            configInfoList.add(new ConfigInfo(configKeyInfo, configValueInfo));
        }
        return new ConfigInfos(connType, errorCount, groups, configInfoList);
    }

    private static ConfigKeyInfo convertConfigKey(ConfigDef.ConfigKey configKey) {
        return AbstractHerder.convertConfigKey(configKey, "");
    }

    private static ConfigKeyInfo convertConfigKey(ConfigDef.ConfigKey configKey, String prefix) {
        String defaultValue;
        String name = prefix + configKey.name;
        ConfigDef.Type type = configKey.type;
        String typeName = configKey.type.name();
        boolean required = false;
        if (ConfigDef.NO_DEFAULT_VALUE.equals(configKey.defaultValue)) {
            defaultValue = null;
            required = true;
        } else {
            defaultValue = ConfigDef.convertToString(configKey.defaultValue, type);
        }
        String importance = configKey.importance.name();
        String documentation = configKey.documentation;
        String group = configKey.group;
        int orderInGroup = configKey.orderInGroup;
        String width = configKey.width.name();
        String displayName = configKey.displayName;
        List<String> dependents = configKey.dependents;
        return new ConfigKeyInfo(name, typeName, required, defaultValue, importance, documentation, group, orderInGroup, width, displayName, dependents);
    }

    private static ConfigValueInfo convertConfigValue(ConfigValue configValue, ConfigDef.Type type) {
        String value = ConfigDef.convertToString(configValue.value(), type);
        LinkedList<String> recommendedValues = new LinkedList<String>();
        if (type == ConfigDef.Type.LIST) {
            for (Object object : configValue.recommendedValues()) {
                recommendedValues.add(ConfigDef.convertToString(object, ConfigDef.Type.STRING));
            }
        } else {
            for (Object object : configValue.recommendedValues()) {
                recommendedValues.add(ConfigDef.convertToString(object, type));
            }
        }
        return new ConfigValueInfo(configValue.name(), value, recommendedValues, configValue.errorMessages(), configValue.visible());
    }

    protected Connector getConnector(String connType) {
        if (this.tempConnectors.containsKey(connType)) {
            return this.tempConnectors.get(connType);
        }
        Connector connector = this.plugins().newConnector(connType);
        this.tempConnectors.put(connType, connector);
        return connector;
    }

    public ConnectorType connectorTypeForClass(String connClass) {
        return ConnectorType.from(this.getConnector(connClass).getClass());
    }

    protected final boolean maybeAddConfigErrors(ConfigInfos configInfos, Callback<Herder.Created<ConnectorInfo>> callback) {
        boolean hasErrors;
        int errors = configInfos.errorCount();
        boolean bl = hasErrors = errors > 0;
        if (hasErrors) {
            StringBuilder messages = new StringBuilder();
            messages.append("Connector configuration is invalid and contains the following ").append(errors).append(" error(s):");
            for (ConfigInfo configInfo : configInfos.values()) {
                for (String msg : configInfo.configValue().errors()) {
                    messages.append('\n').append(msg);
                }
            }
            callback.onCompletion(new BadRequestException(messages.append("\nYou can also find the above list of errors at the endpoint `/connector-plugins/{connectorType}/config/validate`").toString()), null);
        }
        return hasErrors;
    }

    private String trace(Throwable t2) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            t2.printStackTrace(new PrintStream((OutputStream)output, false, StandardCharsets.UTF_8.name()));
            return output.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            return null;
        }
    }

    public static List<Map<String, String>> reverseTransform(String connName, ClusterConfigState configState, List<Map<String, String>> configs) {
        Map<String, String> rawConnConfig = configState.rawConnectorConfig(connName);
        Set<String> connKeysWithVariableValues = AbstractHerder.keysWithVariableValues(rawConnConfig, ConfigTransformer.DEFAULT_PATTERN);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (Map<String, String> config : configs) {
            HashMap<String, String> newConfig = new HashMap<String, String>(config);
            for (String key : connKeysWithVariableValues) {
                if (!newConfig.containsKey(key)) continue;
                newConfig.put(key, rawConnConfig.get(key));
            }
            result.add(newConfig);
        }
        return result;
    }

    static Set<String> keysWithVariableValues(Map<String, String> rawConfig, Pattern pattern) {
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<String, String> config : rawConfig.entrySet()) {
            Matcher matcher;
            if (config.getValue() == null || !(matcher = pattern.matcher(config.getValue())).find()) continue;
            keys.add(config.getKey());
        }
        return keys;
    }
}

